/*******************************************************************************
 * See COPYRIGHT.txt & LICENSE.txt for copyright and licensing details.
 *******************************************************************************/

#ifndef __QL_ISCSI_BASETYPES_H
#define __QL_ISCSI_BASETYPES_H

#include <vmkapi.h>

#ifndef UINT8
#define UINT8		vmk_uint8
#endif

#ifndef UINT16
#define UINT16		vmk_uint16
#endif

#ifndef UINT32
#define UINT32		vmk_uint32
#endif

#ifndef UINT64
#define UINT64		vmk_uint64
#endif

#ifndef INT8
#define INT8		vmk_int8
#endif

#ifndef INT16
#define INT16		vmk_int16
#endif

#ifndef INT32
#define INT32		vmk_int32
#endif

#ifndef INT64
#define INT64		vmk_int64
#endif

#define BIT_0		0x1
#define BIT_1		0x2
#define BIT_2		0x4
#define BIT_3		0x8
#define BIT_4		0x10
#define BIT_5		0x20
#define BIT_6		0x40
#define BIT_7		0x80
#define BIT_8		0x100
#define BIT_9		0x200
#define BIT_10		0x400
#define BIT_11		0x800
#define BIT_12		0x1000
#define BIT_13		0x2000
#define BIT_14		0x4000
#define BIT_15		0x8000
#define BIT_16		0x10000
#define BIT_17		0x20000
#define BIT_18		0x40000
#define BIT_19		0x80000
#define BIT_20		0x100000
#define BIT_21		0x200000
#define BIT_22		0x400000
#define BIT_23		0x800000
#define BIT_24		0x1000000
#define BIT_25		0x2000000
#define BIT_26		0x4000000
#define BIT_27		0x8000000
#define BIT_28		0x10000000
#define BIT_29		0x20000000
#define BIT_30		0x40000000
#define BIT_31		0x80000000

#ifndef min
#define min(x, y)	((x > y)? y : x)
#endif

#ifndef max
#define max(x, y)	((x > y)? x : y)
#endif

#define QLEVIS_SIZE_4		BIT_2
#define QLEVIS_SIZE_6		6
#define QLEVIS_SIZE_8		BIT_3
#define QLEVIS_SIZE_10		10
#define QLEVIS_SIZE_16		BIT_4
#define QLEVIS_SIZE_32		BIT_5
#define QLEVIS_SIZE_64		BIT_6
#define QLEVIS_SIZE_128		BIT_7
#define QLEVIS_SIZE_256		BIT_8
#define QLEVIS_SIZE_512		BIT_9
#define QLEVIS_SIZE_1K		BIT_10
#define QLEVIS_SIZE_2K		BIT_11
#define QLEVIS_SIZE_4K		BIT_12
#define QLEVIS_SIZE_8K		BIT_13
#define QLEVIS_SIZE_16K		BIT_14
#define QLEVIS_SIZE_32K		BIT_15
#define QLEVIS_SIZE_64K		BIT_16
#define QLEVIS_SIZE_128K	BIT_17
#define QLEVIS_SIZE_256K	BIT_18
#define QLEVIS_SIZE_512K	BIT_19
#define QLEVIS_SIZE_1M		BIT_20
#define QLEVIS_SIZE_2M		BIT_21
#define QLEVIS_SIZE_4M		BIT_22
#define QLEVIS_SIZE_8M		BIT_23
#define QLEVIS_SIZE_16M		BIT_24

#define	EXT_STATUS_OK			0
#define	EXT_STATUS_ERR			1
#define	EXT_STATUS_BUSY			2
#define EXT_STATUS_NOT_SUPPORTED	3
#define	EXT_STATUS_INVALID_PARAM	4
#define	EXT_STATUS_DATA_OVERRUN		5
#define	EXT_STATUS_DATA_UNDERRUN	6
#define	EXT_STATUS_DEV_NOT_FOUND	7
#define	EXT_STATUS_COPY_ERR		8
#define	EXT_STATUS_BUFFER_TOO_SMALL	9
#define	EXT_STATUS_NO_MEMORY		10
#define	EXT_STATUS_UNKNOWN		11
#define EXT_STATUS_DEVICE_NOT_READY	12
#define EXT_STATUS_DEVICE_OFFLINE	13

#endif /* QL_ISCSI_BASETYPES_H */
