/*******************************************************************************
 * See COPYRIGHT.txt & LICENSE.txt for copyright and licensing details.
 *******************************************************************************/

#ifndef __QL_ISCSI_VMKMGMT_H
#define __QL_ISCSI_VMKMGMT_H

#include "ql_iscsi_vmkmgmt_struct.h"

#define	QL_ISCSI_GET_HBACNT	(VMK_MGMT_RESERVED_CALLBACKS + 1)
#define	QL_ISCSI_GET_HOSTNO	(VMK_MGMT_RESERVED_CALLBACKS + 2)
#define	QL_ISCSI_GET_PCI_INFO	(VMK_MGMT_RESERVED_CALLBACKS + 3)
#define	QL_ISCSI_GET_PORT_INFO	(VMK_MGMT_RESERVED_CALLBACKS + 4)
#define	QL_ISCSI_GET_SESS_INFO	(VMK_MGMT_RESERVED_CALLBACKS + 5)
#define	QL_ISCSI_GET_TGT_INFO	(VMK_MGMT_RESERVED_CALLBACKS + 6)
#define	QL_ISCSI_SEND_SCSI_CMD	(VMK_MGMT_RESERVED_CALLBACKS + 7)
#define	QL_ISCSI_CHECK_SSAN      (VMK_MGMT_RESERVED_CALLBACKS + 8)
#define	QL_ISCSI_READ_RDP        (VMK_MGMT_RESERVED_CALLBACKS + 9)

#define	QL_ISCSI_NUM_CALLBACKS	9

/* The name used to describe Common interface. */
#define	QL_ISCSI_INTERFACE_NAME		"qfle3i"

#define QL_ISCSI_INTERFACE_VENDOR	"QLogic"

struct ql_iscsi_hba_cnt_cb {
	INT32 hba_cnt;
	INT32 status;
} __attribute__((__packed__));

struct ql_iscsi_hostno_cb {
	UINT64 inst;
	UINT32 host_no;
	UINT32 status;
} __attribute__((__packed__));

struct ql_iscsi_pci_info_cb {
	UINT32 host_no;
	UINT32 status;
	struct ql_iscsi_pci_info pci;
} __attribute__((__packed__));	/* 72 */

struct ql_iscsi_port_info_cb {
	UINT32 host_no;
	UINT32 status;
	struct ql_iscsi_port_info port;
} __attribute__((__packed__));	/* 520 */

struct ql_iscsi_sess_info_cb {
	UINT32 host_no;
	UINT32 status;
	struct ql_iscsi_sess_info sess;
} __attribute__((__packed__));	/* 520 */

struct ql_iscsi_tgt_info_cb {
	UINT32 host_no;
	UINT32 status;
	struct ql_iscsi_tgt_info tgt;
} __attribute__((__packed__));	/* 72 */

struct ql_iscsi_scsi_cmd_cb {
	UINT32 host_no;
	UINT32 status;
	struct ql_iscsi_scsi_cmd cmnd;
} __attribute__((__packed__));	/* 262444 */

/* RDP Response attributes */
#define SSAN_RDP_ATTR_COUNT          13
#define SSAN_RDP_MAC_ADDR            3001
#define SSAN_RDP_SFP_TEMP            4001
#define SSAN_RDP_SFP_VCC             4002
#define SSAN_RDP_SFP_TX_BIAS         4003
#define SSAN_RDP_SFP_TX_POWER        4004
#define SSAN_RDP_SFP_RX_POWER        4005
#define SSAN_RDP_PORT_SPEED_CAP      4006
#define SSAN_RDP_PORT_OPR_SPEED      4007
#define SSAN_RDP_LINK_FAIL_CNT       4008
#define SSAN_RDP_VLINK_FAIL_CNT      4009
#define SSAN_RDP_SYM_ERR_DCC         4010
#define SSAN_RDP_ERR_BLK_CNT         4011
#define SSAN_RDP_FRAME_CHK_SEQ       4012

#define SSAN_DISABLED_IN_DRIVER      0x01
#define SSAN_NO_ADAPTER_SUPPORT      0x02

/* structure that will let application layer know if
 * smartsan is supported by this adapter.
 * if supported driver will return number of hbas currently
 * populated in driver, with status as 0x0.
 * if feature is disabled thru module param, status: 0x01
 * if fw does not have support for ssan,     status: 0x02
 */
struct ssan_support {
	UINT32 hba_cnt;
	UINT32 status;
};

/* RDP supported fields */
struct ssan_rdp_attr{
	UINT16 type;
	UINT16 len;
	union {
		UINT8  mac_addr[8];
		UINT32 sfp_temp;
		UINT32 sfp_vcc;
		UINT32 sfp_tx_bias;
		UINT32 sfp_tx_power;
		UINT32 sfp_rx_power;
		UINT32 port_cap;
		UINT32 opr_speed;
		UINT32 link_fail_cnt;
		UINT32 vlink_fail_cnt;
		UINT32 sym_err_dcc;
		UINT32 err_blk_cnt;
		UINT32 frame_chk_seq;
	} a;
};

/* RDP response structure for application layer */
struct ssan_rdp_attributes {
	UINT32 hostno;
	UINT32 count;
	struct ssan_rdp_attr entry[SSAN_RDP_ATTR_COUNT];
	UINT16 total_len;
};

/* Callback function declarations */
#ifdef VMKERNEL
int ql_iscsi_get_hba_cnt(UINT64, UINT64, struct ql_iscsi_hba_cnt_cb *);
int ql_iscsi_get_hostno(UINT64, UINT64, struct ql_iscsi_hostno_cb *);
int ql_iscsi_get_pci_info(UINT64, UINT64, struct ql_iscsi_pci_info_cb *);
int ql_iscsi_get_port_info(UINT64, UINT64, struct ql_iscsi_port_info_cb *);
int ql_iscsi_get_sess_info(UINT64, UINT64, struct ql_iscsi_sess_info_cb *);
int ql_iscsi_get_tgt_info(UINT64, UINT64, struct ql_iscsi_tgt_info_cb *);
int ql_iscsi_send_scsi_cmd(UINT64, UINT64, struct ql_iscsi_scsi_cmd_cb *);
int ql_iscsi_read_rdp(UINT64, UINT64, struct ssan_rdp_attributes *);
int ql_iscsi_ssan_support(UINT64, UINT64, struct ssan_support *);
#else
#define ql_iscsi_get_hba_cnt   NULL
#define ql_iscsi_get_hostno    NULL
#define ql_iscsi_get_pci_info  NULL
#define ql_iscsi_get_port_info NULL
#define ql_iscsi_get_sess_info NULL
#define ql_iscsi_get_tgt_info  NULL
#define ql_iscsi_send_scsi_cmd NULL
#define ql_iscsi_read_rdp      NULL
#define ql_iscsi_ssan_support  NULL
#endif /* VMKERNEL */

vmk_MgmtCallbackInfo ql_iscsi_callbacks[QL_ISCSI_NUM_CALLBACKS] = {
	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_iscsi_get_hba_cnt,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ql_iscsi_hba_cnt_cb) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_ISCSI_GET_HBACNT,
	},

	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_iscsi_get_hostno,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ql_iscsi_hostno_cb) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_ISCSI_GET_HOSTNO,
	},

	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_iscsi_get_pci_info,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ql_iscsi_pci_info_cb) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_ISCSI_GET_PCI_INFO,
	},

	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_iscsi_get_port_info,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ql_iscsi_port_info_cb) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_ISCSI_GET_PORT_INFO,
	},

	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_iscsi_get_sess_info,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ql_iscsi_sess_info_cb) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_ISCSI_GET_SESS_INFO,
	},

	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_iscsi_get_tgt_info,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ql_iscsi_tgt_info_cb) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_ISCSI_GET_TGT_INFO,
	},

	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_iscsi_send_scsi_cmd,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ql_iscsi_scsi_cmd_cb) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_ISCSI_SEND_SCSI_CMD,
	},

	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_iscsi_read_rdp,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ssan_rdp_attributes) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_ISCSI_READ_RDP,
	},

	{
		.location = VMK_MGMT_CALLBACK_KERNEL,
		.callback = ql_iscsi_ssan_support,
		.synchronous = 1,
		.numParms = 1,
		.parmSizes = { sizeof(struct ssan_support) },
		.parmTypes = { VMK_MGMT_PARMTYPE_INOUT },
		.callbackId = QL_ISCSI_CHECK_SSAN,
	},

};

vmk_MgmtApiSignature ql_iscsi_sig = {
	.version = VMK_REVISION_FROM_NUMBERS(1,0,0,0),
	.name.string = QL_ISCSI_INTERFACE_NAME,
	.vendor.string = QL_ISCSI_INTERFACE_VENDOR,
	.numCallbacks = QL_ISCSI_NUM_CALLBACKS,
	.callbacks = ql_iscsi_callbacks,
};

#endif /* __QEDFC_VMKMGMT_H */
