/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.discovery;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jolokia.discovery.AgentDetailsHolder;
import org.jolokia.discovery.MulticastSocketListenerThread;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.LogHandler;
import org.jolokia.util.NetworkUtil;

public class DiscoveryMulticastResponder {
    private final AgentDetailsHolder detailsHolder;
    private final Restrictor restrictor;
    private final String multicastGroup;
    private final int multicastPort;
    private final LogHandler logHandler;
    private InetAddress hostAddress;
    private List<MulticastSocketListenerThread> listenerThreads;

    public DiscoveryMulticastResponder(AgentDetailsHolder pDetailsHolder, Restrictor pRestrictor, String pMulticastGroup, int pMulticastPort, LogHandler pLogHandler) throws UnknownHostException {
        this(null, pDetailsHolder, pRestrictor, pMulticastGroup, pMulticastPort, pLogHandler);
    }

    public DiscoveryMulticastResponder(InetAddress pHostAddress, AgentDetailsHolder pDetailsHolder, Restrictor pRestrictor, String pMulticastGroup, int pMulticastPort, LogHandler pLogHandler) {
        this.hostAddress = pHostAddress;
        this.detailsHolder = pDetailsHolder;
        this.restrictor = pRestrictor;
        this.multicastGroup = pMulticastGroup;
        this.multicastPort = pMulticastPort;
        this.logHandler = pLogHandler;
        this.listenerThreads = new ArrayList<MulticastSocketListenerThread>();
    }

    public synchronized void start() throws IOException {
        if (this.listenerThreads.size() == 0) {
            List<InetAddress> addresses;
            List<InetAddress> list = addresses = this.hostAddress == null ? NetworkUtil.getMulticastAddresses() : Arrays.asList(this.hostAddress);
            if (addresses.size() == 0) {
                this.logHandler.info("No suitable address found for listening on multicast discovery requests");
                return;
            }
            for (InetAddress addr : addresses) {
                try {
                    MulticastSocketListenerThread thread = new MulticastSocketListenerThread("JolokiaDiscoveryListenerThread-" + addr.getHostAddress(), addr, this.detailsHolder, this.restrictor, this.multicastGroup, this.multicastPort, this.logHandler);
                    thread.start();
                    this.listenerThreads.add(thread);
                }
                catch (IOException exp) {
                    this.logHandler.info("Couldn't start discovery thread for " + addr + ": " + exp);
                }
            }
        }
    }

    public synchronized void stop() {
        if (this.listenerThreads.size() > 0) {
            for (MulticastSocketListenerThread thread : this.listenerThreads) {
                thread.shutdown();
            }
        }
        this.listenerThreads.clear();
    }
}

