/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.google.protobuf.BoolValue;
import com.google.protobuf.BytesValue;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.FieldMask;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.NullValue;
import com.google.protobuf.StringValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.Value;
import com.hubspot.jackson.datatype.protobuf.MessageDeserializerFactory;
import com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import com.hubspot.jackson.datatype.protobuf.builtin.deserializers.DurationDeserializer;
import com.hubspot.jackson.datatype.protobuf.builtin.deserializers.FieldMaskDeserializer;
import com.hubspot.jackson.datatype.protobuf.builtin.deserializers.ListValueDeserializer;
import com.hubspot.jackson.datatype.protobuf.builtin.deserializers.NullValueDeserializer;
import com.hubspot.jackson.datatype.protobuf.builtin.deserializers.StructDeserializer;
import com.hubspot.jackson.datatype.protobuf.builtin.deserializers.TimestampDeserializer;
import com.hubspot.jackson.datatype.protobuf.builtin.deserializers.ValueDeserializer;
import com.hubspot.jackson.datatype.protobuf.builtin.deserializers.WrappedPrimitiveDeserializer;
import com.hubspot.jackson.datatype.protobuf.builtin.serializers.DurationSerializer;
import com.hubspot.jackson.datatype.protobuf.builtin.serializers.FieldMaskSerializer;
import com.hubspot.jackson.datatype.protobuf.builtin.serializers.ListValueSerializer;
import com.hubspot.jackson.datatype.protobuf.builtin.serializers.MessageSerializer;
import com.hubspot.jackson.datatype.protobuf.builtin.serializers.NullValueSerializer;
import com.hubspot.jackson.datatype.protobuf.builtin.serializers.StructSerializer;
import com.hubspot.jackson.datatype.protobuf.builtin.serializers.TimestampSerializer;
import com.hubspot.jackson.datatype.protobuf.builtin.serializers.ValueSerializer;
import com.hubspot.jackson.datatype.protobuf.builtin.serializers.WrappedPrimitiveSerializer;

public class ProtobufModule
extends Module {
    private final ProtobufJacksonConfig config;

    public ProtobufModule() {
        this(ProtobufJacksonConfig.getDefaultInstance());
    }

    @Deprecated
    public ProtobufModule(ExtensionRegistry extensionRegistry) {
        this(ProtobufJacksonConfig.builder().extensionRegistry(extensionRegistry).build());
    }

    public ProtobufModule(ProtobufJacksonConfig config) {
        this.config = config;
    }

    public String getModuleName() {
        return "ProtobufModule";
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void setupModule(Module.SetupContext context) {
        SimpleSerializers serializers = new SimpleSerializers();
        serializers.addSerializer((JsonSerializer)new MessageSerializer(this.config));
        serializers.addSerializer((JsonSerializer)new DurationSerializer(this.config));
        serializers.addSerializer((JsonSerializer)new FieldMaskSerializer(this.config));
        serializers.addSerializer((JsonSerializer)new ListValueSerializer(this.config));
        serializers.addSerializer((JsonSerializer)new NullValueSerializer(this.config));
        serializers.addSerializer((JsonSerializer)new StructSerializer(this.config));
        serializers.addSerializer((JsonSerializer)new TimestampSerializer(this.config));
        serializers.addSerializer((JsonSerializer)new ValueSerializer(this.config));
        serializers.addSerializer(new WrappedPrimitiveSerializer<DoubleValue>(DoubleValue.getDefaultInstance(), this.config));
        serializers.addSerializer(new WrappedPrimitiveSerializer<FloatValue>(FloatValue.getDefaultInstance(), this.config));
        serializers.addSerializer(new WrappedPrimitiveSerializer<Int64Value>(Int64Value.getDefaultInstance(), this.config));
        serializers.addSerializer(new WrappedPrimitiveSerializer<UInt64Value>(UInt64Value.getDefaultInstance(), this.config));
        serializers.addSerializer(new WrappedPrimitiveSerializer<Int32Value>(Int32Value.getDefaultInstance(), this.config));
        serializers.addSerializer(new WrappedPrimitiveSerializer<UInt32Value>(UInt32Value.getDefaultInstance(), this.config));
        serializers.addSerializer(new WrappedPrimitiveSerializer<BoolValue>(BoolValue.getDefaultInstance(), this.config));
        serializers.addSerializer(new WrappedPrimitiveSerializer<StringValue>(StringValue.getDefaultInstance(), this.config));
        serializers.addSerializer(new WrappedPrimitiveSerializer<BytesValue>(BytesValue.getDefaultInstance(), this.config));
        context.addSerializers((Serializers)serializers);
        context.addDeserializers((Deserializers)new MessageDeserializerFactory(this.config));
        SimpleDeserializers deserializers = new SimpleDeserializers();
        deserializers.addDeserializer(Duration.class, (JsonDeserializer)new DurationDeserializer());
        deserializers.addDeserializer(FieldMask.class, (JsonDeserializer)new FieldMaskDeserializer());
        deserializers.addDeserializer(ListValue.class, new ListValueDeserializer().buildAtEnd());
        deserializers.addDeserializer(NullValue.class, (JsonDeserializer)new NullValueDeserializer());
        deserializers.addDeserializer(Struct.class, new StructDeserializer().buildAtEnd());
        deserializers.addDeserializer(Timestamp.class, (JsonDeserializer)new TimestampDeserializer());
        deserializers.addDeserializer(Value.class, new ValueDeserializer().buildAtEnd());
        deserializers.addDeserializer(DoubleValue.class, ProtobufModule.wrappedPrimitiveDeserializer(DoubleValue.class));
        deserializers.addDeserializer(FloatValue.class, ProtobufModule.wrappedPrimitiveDeserializer(FloatValue.class));
        deserializers.addDeserializer(Int64Value.class, ProtobufModule.wrappedPrimitiveDeserializer(Int64Value.class));
        deserializers.addDeserializer(UInt64Value.class, ProtobufModule.wrappedPrimitiveDeserializer(UInt64Value.class));
        deserializers.addDeserializer(Int32Value.class, ProtobufModule.wrappedPrimitiveDeserializer(Int32Value.class));
        deserializers.addDeserializer(UInt32Value.class, ProtobufModule.wrappedPrimitiveDeserializer(UInt32Value.class));
        deserializers.addDeserializer(BoolValue.class, ProtobufModule.wrappedPrimitiveDeserializer(BoolValue.class));
        deserializers.addDeserializer(StringValue.class, ProtobufModule.wrappedPrimitiveDeserializer(StringValue.class));
        deserializers.addDeserializer(BytesValue.class, ProtobufModule.wrappedPrimitiveDeserializer(BytesValue.class));
        context.addDeserializers((Deserializers)deserializers);
        context.setMixInAnnotations(MessageOrBuilder.class, MessageOrBuilderMixin.class);
    }

    private static <T extends Message> JsonDeserializer<T> wrappedPrimitiveDeserializer(Class<T> type) {
        return new WrappedPrimitiveDeserializer(type).buildAtEnd();
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    private static class MessageOrBuilderMixin {
        private MessageOrBuilderMixin() {
        }
    }
}

