/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.api;

import jakarta.persistence.EntityNotFoundException;
import org.apache.custos.core.exception.UnauthorizedException;
import org.apache.custos.service.exceptions.AuthenticationException;
import org.apache.custos.service.exceptions.InternalServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={AuthenticationException.class})
    public ResponseEntity<String> handleAuthenticationException(AuthenticationException ex) {
        logger.error("Authentication exception: ", (Throwable)ex);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)ex.getMessage());
    }

    @ExceptionHandler(value={InternalServerException.class})
    public ResponseEntity<String> handleInternalServerError(InternalServerException ex) {
        logger.error("Internal server error: ", (Throwable)ex);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ex.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<String> handleIllegalArgumentException(IllegalArgumentException ex) {
        logger.error("Illegal argument error: ", (Throwable)ex);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ex.getMessage());
    }

    @ExceptionHandler(value={EntityNotFoundException.class})
    public ResponseEntity<String> handleEntityNotFoundException(EntityNotFoundException ex) {
        logger.error("Entity not found: ", (Throwable)ex);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)ex.getMessage());
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    public ResponseEntity<String> handleUnauthorizedExceptions(UnauthorizedException ex) {
        logger.error("Unauthorized exception: ", (Throwable)ex);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)("Unauthorized: " + ex.getMessage()));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<String> handleOtherExceptions(Exception ex) {
        logger.error("Unexpected error occurred: ", (Throwable)ex);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Unexpected error occurred");
    }
}

