/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.failover;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.StartableApplication;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.group.DynamicGroup;
import org.apache.brooklyn.policy.failover.ElectPrimaryConfig;
import org.apache.brooklyn.policy.failover.ElectPrimaryEffector;
import org.apache.brooklyn.policy.failover.PropagatePrimaryEnricher;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ElectPrimaryPolicy
extends AbstractPolicy
implements ElectPrimaryConfig {
    private static final Logger log = LoggerFactory.getLogger(ElectPrimaryPolicy.class);
    public static ConfigKey<String> EFFECTOR_NAME = ConfigKeys.newStringConfigKey((String)"primary.election.effector", (String)"The effector to invoke to perform the scan; if not set, it will use electPrimary and create if necessary", (String)"electPrimary");
    public static ConfigKey<Collection<?>> PROPAGATE_PRIMARY_SENSORS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Collection<?>>(){}, (String)"propagate.primary.sensors");
    private final transient List<String> rescanTriggers = MutableList.of();
    private transient boolean rescanInProgress = false;

    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.checkAndMaybeAddEffector(entity);
        this.checkQuorums((Entity)entity);
        Collection sensorsToPropagate = (Collection)this.config().get(PROPAGATE_PRIMARY_SENSORS);
        if (sensorsToPropagate != null) {
            MutableList realSensors = MutableList.of();
            for (Object s : sensorsToPropagate) {
                if (s instanceof String) {
                    s = Sensors.newSensor(Object.class, (String)((String)s));
                }
                if (s instanceof Sensor) {
                    realSensors.add((Sensor)s);
                    continue;
                }
                throw new IllegalArgumentException("Config " + PROPAGATE_PRIMARY_SENSORS.getName() + " had invalid entry '" + s + "'; expected string or sensor");
            }
            entity.enrichers().add((EnricherSpec)EnricherSpec.create(PropagatePrimaryEnricher.class).configure(PropagatePrimaryEnricher.PROPAGATING, (Object)realSensors));
        }
        this.addSubscriptions((Entity)entity);
        this.rescanRequest("policy initialization");
    }

    protected void checkAndMaybeAddEffector(EntityLocal entity) {
        String effName = (String)this.config().get(EFFECTOR_NAME);
        if (((EntityInternal)entity).getEffector(effName) == null) {
            if (this.config().getRaw(EFFECTOR_NAME).isAbsent()) {
                log.debug("No effector '" + effName + "' present at " + entity + "; creating default");
                new ElectPrimaryEffector(this.config().getBag()).apply(entity);
            } else {
                throw new IllegalStateException("No such effector '" + effName + "' on " + entity);
            }
        }
    }

    private void checkQuorums(Entity entity) {
        if (((EntityInternal)entity).config().getRaw(StartableApplication.UP_QUORUM_CHECK).isAbsent()) {
            entity.config().set(StartableApplication.UP_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.newInstance((int)1, (double)0.0, (boolean)false));
        }
        if (((EntityInternal)entity).config().getRaw(StartableApplication.RUNNING_QUORUM_CHECK).isAbsent()) {
            entity.config().set(StartableApplication.RUNNING_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.newInstance((int)1, (double)0.0, (boolean)false));
        }
    }

    protected void addSubscriptions(Entity entity) {
        String weightSensorName = (String)this.config().get(PRIMARY_WEIGHT_NAME);
        ElectPrimaryConfig.TargetMode target = (ElectPrimaryConfig.TargetMode)((Object)this.config().get(TARGET_MODE));
        if (target == ElectPrimaryConfig.TargetMode.AUTO) {
            target = entity instanceof Group ? ElectPrimaryConfig.TargetMode.MEMBERS : ElectPrimaryConfig.TargetMode.CHILDREN;
        }
        this.highlightTriggers("Listening for " + weightSensorName + " and service up, state on all " + target.name().toLowerCase());
        Change candidateSetChange = new Change();
        Change candidateUpChange = new Change();
        Change candidateLifecycleChange = new Change();
        Change candidateWeightChange = new Change();
        AttributeSensor weightSensor = Sensors.newSensor(Number.class, (String)weightSensorName);
        switch (target) {
            case CHILDREN: {
                this.subscriptions().subscribe(entity, (Sensor)AbstractEntity.CHILD_ADDED, candidateSetChange);
                this.subscriptions().subscribe(entity, (Sensor)AbstractEntity.CHILD_REMOVED, candidateSetChange);
                this.subscriptions().subscribeToChildren(entity, (Sensor)Attributes.SERVICE_UP, candidateUpChange);
                this.subscriptions().subscribeToChildren(entity, (Sensor)Attributes.SERVICE_STATE_ACTUAL, candidateLifecycleChange);
                this.subscriptions().subscribeToChildren(entity, (Sensor)weightSensor, candidateWeightChange);
                break;
            }
            case MEMBERS: {
                this.subscriptions().subscribe(entity, (Sensor)DynamicGroup.MEMBER_ADDED, candidateSetChange);
                this.subscriptions().subscribe(entity, (Sensor)DynamicGroup.MEMBER_REMOVED, candidateSetChange);
                this.subscriptions().subscribeToMembers((Group)entity, (Sensor)Attributes.SERVICE_UP, candidateUpChange);
                this.subscriptions().subscribeToMembers((Group)entity, (Sensor)Attributes.SERVICE_STATE_ACTUAL, candidateLifecycleChange);
                this.subscriptions().subscribeToMembers((Group)entity, (Sensor)weightSensor, candidateWeightChange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected target mode " + (Object)((Object)target));
            }
        }
    }

    public void rescan(SensorEvent<?> event) {
        this.rescanRequest(event.getSensor().getName() + " " + this.displayValue(event.getValue()) + " from " + event.getSource().getId());
    }

    private String displayValue(Object o) {
        return Strings.maxlenWithEllipsis((String)String.valueOf(o), (int)40);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanRequest(String triggerDescription) {
        List<String> list = this.rescanTriggers;
        synchronized (list) {
            boolean rescanNeeded = this.rescanTriggers.isEmpty();
            this.rescanTriggers.add(triggerDescription);
            if (rescanNeeded) {
                this.getExecutionContext().submit("Scan for primary on " + triggerDescription, () -> {
                    this.rescanImpl();
                    return null;
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanImpl() throws InterruptedException {
        String contextString;
        List<String> list = this.rescanTriggers;
        synchronized (list) {
            while (this.rescanInProgress) {
                Tasks.setBlockingDetails((String)"Waiting for ongoing scan to complete");
                this.rescanTriggers.wait();
                Tasks.resetBlockingDetails();
            }
            if (this.rescanTriggers.isEmpty()) {
                if (log.isTraceEnabled()) {
                    log.trace("Policy " + this + " scheduled rescan unnecessary, trigger already handled");
                }
                return;
            }
            contextString = Strings.join(this.rescanTriggers, (String)", ");
            this.rescanTriggers.clear();
            this.rescanInProgress = true;
        }
        String code = null;
        try {
            String effName = (String)this.config().get(EFFECTOR_NAME);
            if (log.isTraceEnabled()) {
                log.trace("Policy " + this + " got event: " + contextString + "; triggering rescan with " + effName);
            }
            Task task = Effectors.invocation((Entity)this.entity, (Effector)((Effector)Preconditions.checkNotNull((Object)((EntityInternal)this.entity).getEffector(effName))), (ConfigBag)this.config().getBag()).asTask();
            BrooklynTaskTags.addTagDynamically((TaskAdaptable)task, (Object)"NON-TRANSIENT");
            this.highlight("lastScan", "Running " + effName + " on " + contextString, task);
            Object result = DynamicTasks.get((TaskAdaptable)task);
            if (result instanceof Map) {
                code = Strings.toString(((Map)result).get("code"));
            }
            if (ElectPrimaryEffector.ResultCode.NEW_PRIMARY_ELECTED.name().equalsIgnoreCase(code)) {
                this.highlightAction("New primary elected: " + ((Map)result).get("primary"), null);
            }
            if (ElectPrimaryEffector.ResultCode.NO_PRIMARY_AVAILABLE.name().equalsIgnoreCase(code)) {
                this.highlightViolation("No primary available");
            }
        }
        catch (Throwable e) {
            Exceptions.propagateIfFatal((Throwable)e);
            if (Entities.isNoLongerManaged((Entity)this.entity)) {
                throw Exceptions.propagate((Throwable)e);
            }
            Throwable root = Throwables.getRootCause((Throwable)e);
            if (root instanceof UserFacingException) {
                e = root;
            }
            if (e instanceof UserFacingException) {
                log.warn("Error running policy " + this + " on " + this.entity + ": " + Exceptions.collapseText((Throwable)e));
            }
            log.warn("Error running policy " + this + " on " + this.entity + ": " + Exceptions.collapseText((Throwable)e), e);
        }
        List<String> list2 = this.rescanTriggers;
        synchronized (list2) {
            this.rescanTriggers.notifyAll();
            this.rescanInProgress = false;
        }
    }

    public class Change<T>
    implements SensorEventListener<T> {
        public void onEvent(SensorEvent<T> event) {
            ElectPrimaryPolicy.this.rescan(event);
        }
    }
}

