/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.followthesun;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.policy.followthesun.FollowTheSunModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFollowTheSunModel<ContainerType, ItemType>
implements FollowTheSunModel<ContainerType, ItemType> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFollowTheSunModel.class);
    private static final String NULL = "null-val";
    private static final Location NULL_LOCATION = new AbstractLocation(DefaultFollowTheSunModel.newHashMap("name", "null-location")){};
    private final String name;
    private final Set<ContainerType> containers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<ItemType, ContainerType> itemToContainer = new ConcurrentHashMap<ItemType, ContainerType>();
    private final Map<ContainerType, Location> containerToLocation = new ConcurrentHashMap<ContainerType, Location>();
    private final Map<ItemType, Location> itemToLocation = new ConcurrentHashMap<ItemType, Location>();
    private final Map<ItemType, Map<? extends ItemType, Double>> itemUsage = new ConcurrentHashMap<ItemType, Map<? extends ItemType, Double>>();
    private final Set<ItemType> immovableItems = Collections.newSetFromMap(new ConcurrentHashMap());

    public DefaultFollowTheSunModel(String name) {
        this.name = name;
    }

    @Override
    public Set<ItemType> getItems() {
        return this.itemToContainer.keySet();
    }

    @Override
    public ContainerType getItemContainer(ItemType item) {
        ContainerType result = this.itemToContainer.get(item);
        return this.isNull(result) ? null : (ContainerType)result;
    }

    @Override
    public Location getItemLocation(ItemType item) {
        Location result = this.itemToLocation.get(item);
        return this.isNull(result) ? null : result;
    }

    @Override
    public Location getContainerLocation(ContainerType container) {
        Location result = this.containerToLocation.get(container);
        return this.isNull(result) ? null : result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getName(ItemType item) {
        return item.toString();
    }

    @Override
    public boolean isItemMoveable(ItemType item) {
        return this.hasItem(item) && !this.immovableItems.contains(item);
    }

    @Override
    public boolean isItemAllowedIn(ItemType item, Location location) {
        return true;
    }

    @Override
    public boolean hasActiveMigration(ItemType item) {
        return false;
    }

    @Override
    public Map<ItemType, Map<Location, Double>> getDirectSendsToItemByLocation() {
        LinkedHashMap result = new LinkedHashMap(this.getNumItems());
        for (Map.Entry<ItemType, Map<ItemType, Double>> entry : this.itemUsage.entrySet()) {
            ItemType targetItem = entry.getKey();
            Map<ItemType, Double> sources = entry.getValue();
            if (sources.isEmpty()) continue;
            LinkedHashMap<Location, Double> targetUsageByLocation = new LinkedHashMap<Location, Double>();
            result.put(targetItem, targetUsageByLocation);
            for (Map.Entry<ItemType, Double> entry2 : sources.entrySet()) {
                double usageVal;
                ItemType sourceItem = entry2.getKey();
                Location sourceLocation = this.getItemLocation(sourceItem);
                double d = usageVal = entry.getValue() != null ? entry2.getValue() : 0.0;
                if (sourceLocation == null || sourceItem.equals(targetItem)) continue;
                Double usageValTotal = (Double)targetUsageByLocation.get(sourceLocation);
                double newUsageValTotal = (usageValTotal != null ? usageValTotal : 0.0) + usageVal;
                targetUsageByLocation.put(sourceLocation, newUsageValTotal);
            }
        }
        return result;
    }

    @Override
    public Set<ContainerType> getAvailableContainersFor(ItemType item, Location location) {
        Preconditions.checkNotNull((Object)location);
        return this.getContainersInLocation(location);
    }

    @Override
    public void onItemMoved(ItemType item, ContainerType newContainer) {
        Location newLocation = newContainer != null ? this.containerToLocation.get(newContainer) : null;
        ContainerType newContainerNonNull = this.toNonNullContainer(newContainer);
        Location newLocationNonNull = this.toNonNullLocation(newLocation);
        ContainerType oldContainer = this.itemToContainer.put(item, newContainerNonNull);
        Location oldLocation = this.itemToLocation.put(item, newLocationNonNull);
    }

    @Override
    public void onContainerAdded(ContainerType container, Location location) {
        Location locationNonNull = this.toNonNullLocation(location);
        this.containers.add(container);
        this.containerToLocation.put(container, locationNonNull);
        for (ItemType item : this.getItemsOnContainer(container)) {
            this.itemToLocation.put(item, locationNonNull);
        }
    }

    @Override
    public void onContainerRemoved(ContainerType container) {
        this.containers.remove(container);
        this.containerToLocation.remove(container);
    }

    @Override
    public void onContainerLocationUpdated(ContainerType container, Location location) {
        if (!this.containers.contains(container)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring setting of location for unknown container {}, to {}", container, (Object)location);
            }
            return;
        }
        Location locationNonNull = this.toNonNullLocation(location);
        this.containerToLocation.put(container, locationNonNull);
        for (ItemType item : this.getItemsOnContainer(container)) {
            this.itemToLocation.put(item, locationNonNull);
        }
    }

    @Override
    public void onItemAdded(ItemType item, ContainerType container, boolean immovable) {
        if (immovable) {
            this.immovableItems.add(item);
        }
        Location location = container != null ? this.containerToLocation.get(container) : null;
        ContainerType containerNonNull = this.toNonNullContainer(container);
        Location locationNonNull = this.toNonNullLocation(location);
        ContainerType oldContainer = this.itemToContainer.put(item, containerNonNull);
        Location oldLocation = this.itemToLocation.put(item, locationNonNull);
    }

    @Override
    public void onItemRemoved(ItemType item) {
        this.itemToContainer.remove(item);
        this.itemToLocation.remove(item);
        this.itemUsage.remove(item);
        this.immovableItems.remove(item);
    }

    @Override
    public void onItemUsageUpdated(ItemType item, Map<? extends ItemType, Double> newValue) {
        if (this.hasItem(item)) {
            this.itemUsage.put(item, newValue);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring setting of usage for unknown item {}, to {}", item, newValue);
        }
    }

    @VisibleForTesting
    public String itemDistributionToString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.dumpItemDistribution(new PrintStream(baos));
        return new String(baos.toByteArray());
    }

    @VisibleForTesting
    public void dumpItemDistribution() {
        this.dumpItemDistribution(System.out);
    }

    @VisibleForTesting
    public void dumpItemDistribution(PrintStream out) {
        Map<ItemType, Map<Location, Double>> directSendsToItemByLocation = this.getDirectSendsToItemByLocation();
        out.println("Follow-The-Sun dump: ");
        for (Location location : this.getLocations()) {
            out.println("\tLocation " + location);
            for (ContainerType container : this.getContainersInLocation(location)) {
                out.println("\t\tContainer " + container);
                for (ItemType item : this.getItemsOnContainer(container)) {
                    Map<Location, Double> inboundUsage = directSendsToItemByLocation.get(item);
                    Map<ItemType, Double> outboundUsage = this.itemUsage.get(item);
                    double totalInboundByLocation = inboundUsage != null ? DefaultFollowTheSunModel.sum(inboundUsage.values()) : 0.0;
                    double totalInboundByActor = outboundUsage != null ? DefaultFollowTheSunModel.sum(outboundUsage.values()) : 0.0;
                    out.println("\t\t\tItem " + item);
                    out.println("\t\t\t\tInbound-by-location: " + totalInboundByLocation + ": " + inboundUsage);
                    out.println("\t\t\t\tInbound-by-actor: " + totalInboundByActor + ": " + outboundUsage);
                }
            }
        }
        out.flush();
    }

    private boolean hasItem(ItemType item) {
        return this.itemToContainer.containsKey(item);
    }

    private Set<Location> getLocations() {
        return ImmutableSet.copyOf(this.containerToLocation.values());
    }

    private Set<ContainerType> getContainersInLocation(Location location) {
        LinkedHashSet<ContainerType> result = new LinkedHashSet<ContainerType>();
        for (Map.Entry<ContainerType, Location> entry : this.containerToLocation.entrySet()) {
            if (!location.equals(entry.getValue())) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private Set<ItemType> getItemsOnContainer(ContainerType container) {
        LinkedHashSet<ItemType> result = new LinkedHashSet<ItemType>();
        for (Map.Entry<ItemType, ContainerType> entry : this.itemToContainer.entrySet()) {
            if (!container.equals(entry.getValue())) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private int getNumItems() {
        return this.itemToContainer.size();
    }

    private ContainerType nullContainer() {
        return (ContainerType)NULL;
    }

    private Location nullLocation() {
        return NULL_LOCATION;
    }

    private ContainerType toNonNullContainer(ContainerType val) {
        return val != null ? val : this.nullContainer();
    }

    private Location toNonNullLocation(Location val) {
        return val != null ? val : this.nullLocation();
    }

    private boolean isNull(Object val) {
        return val == NULL || val == NULL_LOCATION;
    }

    public static <K, V> Map<K, V> newHashMap(K k, V v) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        result.put(k, v);
        return result;
    }

    public static double sum(Collection<? extends Number> values) {
        double total = 0.0;
        for (Number number : values) {
            total += number.doubleValue();
        }
        return total;
    }
}

