/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging;

import java.util.Map;
import java.util.Properties;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogConfigurationException;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.PaxLoggingManagerAwareLogger;
import org.ops4j.pax.logging.internal.Activator;
import org.ops4j.pax.logging.juli.JuliLogger;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.osgi.framework.FrameworkUtil;

public class LogFactory {
    private static PaxLoggingManager m_paxLogging;
    public static final String FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "org.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    public static final String HASHTABLE_IMPLEMENTATION_PROPERTY = "org.apache.commons.logging.LogFactory.HashtableImpl";
    private static LogFactory singleton;

    public static void setPaxLoggingManager(PaxLoggingManager manager) {
        m_paxLogging = manager;
    }

    private LogFactory() {
    }

    void setLogConfig(Properties p) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log getInstance(String name) throws LogConfigurationException {
        PaxLogger logger = m_paxLogging == null ? FallbackLogFactory.createFallbackLog(FrameworkUtil.getBundle(Log.class), name) : m_paxLogging.getLogger(name, JuliLogger.JULI_FQCN);
        JuliLogger juliLogger = new JuliLogger(name, logger);
        if (m_paxLogging == null) {
            Map<String, PaxLoggingManagerAwareLogger> map = Activator.m_loggers;
            synchronized (map) {
                Activator.m_loggers.put(name, juliLogger);
            }
        }
        return juliLogger;
    }

    public void release() {
    }

    public Object getAttribute(String name) {
        return null;
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public void removeAttribute(String name) {
    }

    public void setAttribute(String name, Object value) {
    }

    public Log getInstance(Class<?> clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        return singleton;
    }

    public static Log getLog(Class<?> clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String name) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(name);
    }

    public static void release(ClassLoader classLoader) {
    }

    public static void releaseAll() {
    }

    public static String objectId(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getName() + "@" + System.identityHashCode(o);
    }

    static {
        singleton = new LogFactory();
    }
}

