/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind.dto;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.mgmt.rebind.mementos.LocationMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.TreeNode;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.mgmt.rebind.dto.AbstractTreeNodeMemento;
import org.apache.brooklyn.util.core.config.ConfigBag;

public class BasicLocationMemento
extends AbstractTreeNodeMemento
implements LocationMemento,
Serializable {
    private static final long serialVersionUID = -4025337943126838761L;
    private Map<String, Object> locationConfig;
    private Set<String> locationConfigUnused;
    private String locationConfigDescription;

    public static Builder builder() {
        return new Builder();
    }

    private BasicLocationMemento() {
    }

    protected BasicLocationMemento(Builder builder) {
        super(builder);
        this.locationConfig = this.toPersistedMap(builder.locationConfig);
        this.locationConfigUnused = this.toPersistedSet(builder.locationConfigUnused);
        this.locationConfigDescription = builder.locationConfigDescription;
    }

    public Map<String, Object> getLocationConfig() {
        return this.fromPersistedMap(this.locationConfig);
    }

    public Set<String> getLocationConfigUnused() {
        return this.fromPersistedSet(this.locationConfigUnused);
    }

    public String getLocationConfigDescription() {
        return this.locationConfigDescription;
    }

    @Override
    protected MoreObjects.ToStringHelper newVerboseStringHelper() {
        return super.newVerboseStringHelper().add("config", Sanitizer.sanitize(this.getLocationConfig())).add("locationConfigDescription", (Object)this.getLocationConfigDescription());
    }

    public static class Builder
    extends AbstractTreeNodeMemento.Builder<Builder> {
        protected Map<String, Object> locationConfig = Maps.newLinkedHashMap();
        protected Set<String> locationConfigUnused = Sets.newLinkedHashSet();
        protected String locationConfigDescription;

        public Builder from(LocationMemento other) {
            super.from((TreeNode)other);
            this.displayName = other.getDisplayName();
            this.locationConfig.putAll(other.getLocationConfig());
            this.locationConfigUnused.addAll(other.getLocationConfigUnused());
            this.locationConfigDescription = other.getLocationConfigDescription();
            return (Builder)this.self();
        }

        public LocationMemento build() {
            return new BasicLocationMemento(this);
        }

        public void copyConfig(ConfigBag config) {
            this.locationConfig.putAll(config.getAllConfig());
            this.locationConfigUnused.addAll(config.getUnusedConfig().keySet());
            this.locationConfigDescription = config.getDescription();
        }
    }
}

