/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.spi.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.camp.spi.AbstractResource;
import org.apache.brooklyn.camp.spi.collection.AbstractResourceLookup;
import org.apache.brooklyn.camp.spi.collection.ResolvableLink;
import org.apache.brooklyn.util.collections.MutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicResourceLookup<T extends AbstractResource>
extends AbstractResourceLookup<T> {
    private static final Logger log = LoggerFactory.getLogger(BasicResourceLookup.class);
    Map<String, T> items = new MutableMap();
    Map<String, ResolvableLink<T>> links = new MutableMap();

    @Override
    public T get(String id) {
        return (T)((AbstractResource)this.items.get(id));
    }

    @Override
    public synchronized List<ResolvableLink<T>> links() {
        return new ArrayList<ResolvableLink<T>>(this.links.values());
    }

    public synchronized void add(T item) {
        if (this.items.containsKey(((AbstractResource)item).getId())) {
            throw new IllegalStateException("Already contains item for " + ((AbstractResource)item).getId() + " (adding " + item + ")");
        }
        if (!this.items.isEmpty() && this.items.size() % 100 == 0) {
            log.debug("Creating new CAMP item in " + this + " (had " + this.items.size() + "): " + item);
        }
        this.items.put(((AbstractResource)item).getId(), item);
        this.links.put(((AbstractResource)item).getId(), this.newLink(((AbstractResource)item).getId(), ((AbstractResource)item).getName()));
    }

    public synchronized void addAll(T ... items) {
        for (T item : items) {
            this.add(item);
        }
    }

    public synchronized T update(T item) {
        AbstractResource old = (AbstractResource)this.items.put(((AbstractResource)item).getId(), item);
        this.links.put(((AbstractResource)item).getId(), this.newLink(((AbstractResource)item).getId(), ((AbstractResource)item).getName()));
        return (T)old;
    }

    public synchronized boolean remove(String id) {
        this.items.remove(id);
        return this.links.remove(id) != null;
    }

    @SafeVarargs
    public static <T extends AbstractResource> BasicResourceLookup<T> of(T ... items) {
        BasicResourceLookup<T> result = new BasicResourceLookup<T>();
        for (T item : items) {
            result.add(item);
        }
        return result;
    }
}

