/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LimitRangeItem;
import io.fabric8.kubernetes.api.model.LimitRangeItemBuilder;
import io.fabric8.kubernetes.api.model.LimitRangeItemFluentImpl;
import io.fabric8.kubernetes.api.model.LimitRangeSpec;
import io.fabric8.kubernetes.api.model.LimitRangeSpecFluent;
import java.util.ArrayList;
import java.util.List;

public class LimitRangeSpecFluentImpl<A extends LimitRangeSpecFluent<A>>
extends BaseFluent<A>
implements LimitRangeSpecFluent<A> {
    private List<VisitableBuilder<? extends LimitRangeItem, ?>> limits = new ArrayList();

    public LimitRangeSpecFluentImpl() {
    }

    public LimitRangeSpecFluentImpl(LimitRangeSpec instance) {
        this.withLimits(instance.getLimits());
    }

    @Override
    public A addToLimits(LimitRangeItem ... items) {
        for (LimitRangeItem item : items) {
            LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
            this._visitables.add(builder);
            this.limits.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromLimits(LimitRangeItem ... items) {
        for (LimitRangeItem item : items) {
            LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
            this._visitables.remove(builder);
            this.limits.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<LimitRangeItem> getLimits() {
        return LimitRangeSpecFluentImpl.build(this.limits);
    }

    @Override
    public A withLimits(List<LimitRangeItem> limits) {
        this._visitables.removeAll(this.limits);
        this.limits.clear();
        if (limits != null) {
            for (LimitRangeItem item : limits) {
                this.addToLimits(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withLimits(LimitRangeItem ... limits) {
        this.limits.clear();
        if (limits != null) {
            for (LimitRangeItem item : limits) {
                this.addToLimits(item);
            }
        }
        return (A)this;
    }

    @Override
    public LimitRangeSpecFluent.LimitsNested<A> addNewLimit() {
        return new LimitsNestedImpl();
    }

    @Override
    public LimitRangeSpecFluent.LimitsNested<A> addNewLimitLike(LimitRangeItem item) {
        return new LimitsNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitRangeSpecFluentImpl that = (LimitRangeSpecFluentImpl)o;
        return !(this.limits != null ? !this.limits.equals(that.limits) : that.limits != null);
    }

    public class LimitsNestedImpl<N>
    extends LimitRangeItemFluentImpl<LimitRangeSpecFluent.LimitsNested<N>>
    implements LimitRangeSpecFluent.LimitsNested<N>,
    Nested<N> {
        private final LimitRangeItemBuilder builder;

        LimitsNestedImpl(LimitRangeItem item) {
            this.builder = new LimitRangeItemBuilder(this, item);
        }

        LimitsNestedImpl() {
            this.builder = new LimitRangeItemBuilder(this);
        }

        @Override
        public N and() {
            return (N)LimitRangeSpecFluentImpl.this.addToLimits(this.builder.build());
        }

        @Override
        public N endLimit() {
            return this.and();
        }
    }
}

