/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.time;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.util.time.Duration;

public class DurationPredicates {
    public static Predicate<Duration> positive() {
        return new Positive();
    }

    public static Predicate<Duration> negative() {
        return new Negative();
    }

    public static Predicate<Duration> longerThan(Duration duration) {
        return new LongerThan(duration);
    }

    public static Predicate<Duration> shorterThan(Duration duration) {
        return new ShorterThan(duration);
    }

    public static Predicate<Stopwatch> longerThanDuration(Duration duration) {
        return new LongerThanDuration(duration);
    }

    public static Predicate<Stopwatch> shorterThanDuration(Duration duration) {
        return new ShorterThanDuration(duration);
    }

    protected static class ShorterThanDuration
    implements Predicate<Stopwatch> {
        private final Duration value;

        protected ShorterThanDuration(Duration value) {
            Preconditions.checkNotNull((Object)value);
            this.value = value;
        }

        public boolean apply(Stopwatch input) {
            return input != null && Duration.millis(input.elapsed(TimeUnit.MILLISECONDS)).isShorterThan(this.value);
        }
    }

    protected static class LongerThanDuration
    implements Predicate<Stopwatch> {
        private final Duration value;

        protected LongerThanDuration(Duration value) {
            Preconditions.checkNotNull((Object)value);
            this.value = value;
        }

        public boolean apply(Stopwatch input) {
            return input != null && Duration.millis(input.elapsed(TimeUnit.MILLISECONDS)).isLongerThan(this.value);
        }
    }

    protected static class ShorterThan
    implements Predicate<Duration> {
        private final Duration value;

        protected ShorterThan(Duration value) {
            Preconditions.checkNotNull((Object)value);
            this.value = value;
        }

        public boolean apply(Duration input) {
            return input != null && input.isShorterThan(this.value);
        }
    }

    protected static class LongerThan
    implements Predicate<Duration> {
        private final Duration value;

        protected LongerThan(Duration value) {
            Preconditions.checkNotNull((Object)value);
            this.value = value;
        }

        public boolean apply(Duration input) {
            return input != null && input.isLongerThan(this.value);
        }
    }

    protected static class Negative
    implements Predicate<Duration> {
        protected Negative() {
        }

        public boolean apply(Duration input) {
            return input != null && input.isNegative();
        }
    }

    protected static class Positive
    implements Predicate<Duration> {
        protected Positive() {
        }

        public boolean apply(Duration input) {
            return input != null && input.isPositive();
        }
    }
}

