/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.proxy.nginx;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.entity.drivers.downloads.DownloadResolver;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.entity.proxy.AbstractController;
import org.apache.brooklyn.entity.proxy.nginx.NginxController;
import org.apache.brooklyn.entity.proxy.nginx.NginxControllerImpl;
import org.apache.brooklyn.entity.proxy.nginx.NginxDriver;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.software.base.lifecycle.ScriptHelper;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ssh.SshTasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NginxSshDriver
extends AbstractSoftwareProcessSshDriver
implements NginxDriver {
    public static final Logger log = LoggerFactory.getLogger(NginxSshDriver.class);
    public static final String NGINX_PID_FILE = "logs/nginx.pid";
    private boolean customizationCompleted = false;
    private final ExecController reloadExecutor = new ExecController(this.entity + "->reload", new Runnable(){

        @Override
        public void run() {
            NginxSshDriver.this.reloadImpl();
        }
    });

    public NginxSshDriver(NginxControllerImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
        entity.sensors().set(Attributes.LOG_FILE_LOCATION, (Object)this.getLogFileLocation());
        entity.sensors().set(NginxController.ACCESS_LOG_LOCATION, (Object)this.getAccessLogLocation());
        entity.sensors().set(NginxController.ERROR_LOG_LOCATION, (Object)this.getErrorLogLocation());
    }

    public NginxControllerImpl getEntity() {
        return (NginxControllerImpl)super.getEntity();
    }

    public String getLogFileLocation() {
        return String.format("%s/console", this.getRunDir());
    }

    public String getAccessLogLocation() {
        String accessLog = (String)this.entity.getConfig(NginxController.ACCESS_LOG_LOCATION);
        return String.format("%s/%s", this.getRunDir(), accessLog);
    }

    public String getErrorLogLocation() {
        String errorLog = (String)this.entity.getConfig(NginxController.ERROR_LOG_LOCATION);
        return String.format("%s/%s", this.getRunDir(), errorLog);
    }

    @Override
    public String getPidFile() {
        return String.format("%s/%s", this.getRunDir(), NGINX_PID_FILE);
    }

    @Deprecated
    public Integer getHttpPort() {
        return this.getEntity().getPort();
    }

    public Integer getPort() {
        return this.getEntity().getPort();
    }

    public void rebind() {
        this.customizationCompleted = true;
    }

    public void postLaunch() {
        this.entity.sensors().set(NginxController.PID_FILE, (Object)(this.getRunDir() + "/" + "pid.txt"));
        if (((AbstractController)this.entity).isSsl()) {
            this.entity.sensors().set((AttributeSensor)Attributes.HTTPS_PORT, (Object)this.getPort());
            ((EntityInternal)this.entity).sensors().remove((AttributeSensor)Attributes.HTTP_PORT);
        } else {
            this.entity.sensors().set((AttributeSensor)Attributes.HTTP_PORT, (Object)this.getPort());
            ((EntityInternal)this.entity).sensors().remove((AttributeSensor)Attributes.HTTPS_PORT);
        }
        super.postLaunch();
    }

    public void install() {
        DynamicTasks.queueIfPossible((TaskFactory)SshTasks.dontRequireTtyForSudo((SshMachineLocation)this.getMachine(), (SshTasks.OnFailingTask)SshTasks.OnFailingTask.WARN_OR_IF_DYNAMIC_FAIL_MARKING_INESSENTIAL)).orSubmitAndBlock();
        List nginxUrls = this.resolver.getTargets();
        String nginxSaveAs = this.resolver.getFilename();
        boolean sticky = ((NginxController)this.entity).isSticky();
        boolean isMac = this.getMachine().getOsDetails().isMac();
        MutableMap installGccPackageFlags = MutableMap.of((Object)"onlyifmissing", (Object)"gcc", (Object)"yum", (Object)"gcc", (Object)"apt", (Object)"gcc", (Object)"zypper", (Object)"gcc", (Object)"port", null);
        MutableMap installMakePackageFlags = MutableMap.of((Object)"onlyifmissing", (Object)"make", (Object)"yum", (Object)"make", (Object)"apt", (Object)"make", (Object)"zypper", (Object)"make", (Object)"port", null);
        MutableMap installPackageFlags = MutableMap.of((Object)"yum", (Object)"openssl-devel pcre-devel", (Object)"apt", (Object)"libssl-dev zlib1g-dev libpcre3-dev", (Object)"zypper", (Object)"libopenssl-devel pcre-devel", (Object)"port", null);
        String stickyModuleVersion = (String)this.entity.getConfig(NginxController.STICKY_VERSION);
        DownloadResolver stickyModuleResolver = this.mgmt().getEntityDownloadsManager().newDownloader((EntityDriver)this, "stickymodule", (Map)ImmutableMap.of((Object)"addonversion", (Object)stickyModuleVersion));
        List stickyModuleUrls = stickyModuleResolver.getTargets();
        String stickyModuleSaveAs = stickyModuleResolver.getFilename();
        String stickyModuleExpandedInstallDir = String.format("%s/src/%s", this.getExpandedInstallDir(), stickyModuleResolver.getUnpackedDirectoryName("nginx-sticky-module-" + stickyModuleVersion));
        ArrayList cmds = Lists.newArrayList();
        cmds.add(BashCommands.ifExecutableElse0((String)"yum", (String)BashCommands.sudo((String)"yum -y install kernel-headers --disableexcludes=all")));
        cmds.add(BashCommands.INSTALL_TAR);
        cmds.add(BashCommands.alternatives((String[])new String[]{BashCommands.ifExecutableElse0((String)"apt-get", (String)BashCommands.installPackage((String)"build-essential")), BashCommands.ifExecutableElse0((String)"yum", (String)BashCommands.sudo((String)"yum -y --nogpgcheck groupinstall \"Development Tools\""))}));
        cmds.add(BashCommands.installPackage((Map)installGccPackageFlags, (String)"nginx-prerequisites-gcc"));
        cmds.add(BashCommands.installPackage((Map)installMakePackageFlags, (String)"nginx-prerequisites-make"));
        cmds.add(BashCommands.installPackage((Map)installPackageFlags, (String)"nginx-prerequisites"));
        cmds.addAll(BashCommands.commandsToDownloadUrlsAs((List)nginxUrls, (String)nginxSaveAs));
        String pcreExpandedInstallDirname = "";
        if (isMac) {
            String pcreVersion = (String)this.entity.getConfig(NginxController.PCRE_VERSION);
            DownloadResolver pcreResolver = this.mgmt().getEntityDownloadsManager().newDownloader((EntityDriver)this, "pcre", (Map)ImmutableMap.of((Object)"addonversion", (Object)pcreVersion));
            List pcreUrls = pcreResolver.getTargets();
            String pcreSaveAs = pcreResolver.getFilename();
            pcreExpandedInstallDirname = pcreResolver.getUnpackedDirectoryName("pcre-" + pcreVersion);
            cmds.addAll(BashCommands.commandsToDownloadUrlsAs((List)pcreUrls, (String)pcreSaveAs));
            cmds.add(String.format("mkdir -p %s/pcre-dist", this.getInstallDir()));
            cmds.add(String.format("tar xvzf %s", pcreSaveAs));
            cmds.add(String.format("cd %s", pcreExpandedInstallDirname));
            cmds.add(String.format("./configure --prefix=%s/pcre-dist", this.getInstallDir()));
            cmds.add("make");
            cmds.add("make install");
            cmds.add("cd ..");
        }
        cmds.add(String.format("tar xvzf %s", nginxSaveAs));
        cmds.add(String.format("cd %s", this.getExpandedInstallDir()));
        if (sticky) {
            cmds.add(String.format("mkdir -p %s", stickyModuleExpandedInstallDir));
            cmds.add(String.format("pushd %s", stickyModuleExpandedInstallDir));
            cmds.addAll(BashCommands.commandsToDownloadUrlsAs((List)stickyModuleUrls, (String)stickyModuleSaveAs));
            cmds.add(String.format("tar --strip-component=1 -xvzf %s", stickyModuleSaveAs));
            cmds.add("popd");
        }
        String withLdOpt = (String)this.entity.getConfig(NginxController.WITH_LD_OPT);
        if (isMac) {
            withLdOpt = String.format("-L%s/pcre-dist/lib", this.getInstallDir()) + (Strings.isBlank((CharSequence)withLdOpt) ? "" : " " + withLdOpt);
        }
        String withCcOpt = (String)this.entity.getConfig(NginxController.WITH_CC_OPT);
        if (isMac) {
            withCcOpt = (Strings.isBlank((CharSequence)withCcOpt) ? "" : withCcOpt + " ") + "-Wno-error";
        }
        StringBuilder configureCommand = new StringBuilder("./configure").append(String.format(" --prefix=%s/dist", this.getExpandedInstallDir())).append(" --with-http_ssl_module").append(sticky ? String.format(" --add-module=%s ", stickyModuleExpandedInstallDir) : "").append(!Strings.isBlank((CharSequence)withLdOpt) ? String.format(" --with-ld-opt=\"%s\"", withLdOpt) : "").append(!Strings.isBlank((CharSequence)withCcOpt) ? String.format(" --with-cc-opt=\"%s\"", withCcOpt) : "");
        if (isMac) {
            configureCommand.append(" --with-pcre=").append(this.getInstallDir()).append("/").append(pcreExpandedInstallDirname);
        }
        cmds.addAll(ImmutableList.of((Object)"mkdir -p dist", (Object)configureCommand.toString(), (Object)"make install"));
        ScriptHelper script = this.newScript((String)"installing").body.append((Collection)cmds).header.prepend((CharSequence)"set -x").gatherOutput().failOnNonZeroResultCode(false);
        int result = script.execute();
        if (result != 0) {
            String notes = "likely an error building nginx. consult the brooklyn log ssh output for further details.\nnote that this Brooklyn nginx driver compiles nginx from source. it attempts to install common prerequisites but this does not always succeed.\n";
            OsDetails os = this.getMachine().getOsDetails();
            if (os.isMac()) {
                notes = notes + "deploying to Mac OS X, you will require Xcode and Xcode command-line tools, and on some versions the pcre library (e.g. using macports, sudo port install pcre).\n";
            }
            if (os.isWindows()) {
                notes = notes + "this nginx driver is not designed for windows, unless cygwin is installed, and you are patient.\n";
            }
            if (this.getEntity().getApplication().getClass().getCanonicalName().startsWith("brooklyn.demo.")) {
                notes = notes + "if debugging this is all a bit much and you just want to run a demo, you have two fairly friendly options.\n1. you can use a well known cloud, like AWS or Rackspace, where this should run in a tried-and-tested Ubuntu or CentOS environment, without any problems (and if it does let us know and we'll fix it!).\n2. or you can just use the demo without nginx, instead access the appserver instances directly.\n";
            }
            if (!script.getResultStderr().isEmpty()) {
                notes = notes + "\nSTDERR\n" + script.getResultStderr() + "\n";
                Streams.logStreamTail((Logger)log, (String)("STDERR of problem in " + Tasks.current()), (ByteArrayOutputStream)Streams.byteArrayOfString((String)script.getResultStderr()), (int)1024);
            }
            if (!script.getResultStdout().isEmpty()) {
                notes = notes + "\nSTDOUT\n" + script.getResultStdout() + "\n";
                Streams.logStreamTail((Logger)log, (String)("STDOUT of problem in " + Tasks.current()), (ByteArrayOutputStream)Streams.byteArrayOfString((String)script.getResultStdout()), (int)1024);
            }
            Tasks.setExtraStatusDetails((String)notes.trim());
            throw new IllegalStateException("Installation of nginx failed (shell returned non-zero result " + result + ")");
        }
    }

    private ManagementContext mgmt() {
        return ((EntityInternal)this.entity).getManagementContext();
    }

    public void customize() {
        this.newScript((String)"customizing").body.append(new CharSequence[]{String.format("mkdir -p %s", this.getRunDir()), String.format("cp -R %s/dist/{conf,html,logs,sbin} %s", this.getExpandedInstallDir(), this.getRunDir())}).execute();
        String archiveUrl = (String)this.entity.getConfig(NginxController.STATIC_CONTENT_ARCHIVE_URL);
        if (Strings.isNonBlank((CharSequence)archiveUrl)) {
            this.getEntity().deploy(archiveUrl);
        }
        this.customizationCompleted = true;
    }

    @Override
    public boolean isCustomizationCompleted() {
        return this.customizationCompleted;
    }

    public void launch() {
        Networking.checkPortsValid((Map)MutableMap.of((Object)"port", (Object)this.getPort()));
        this.getEntity().doExtraConfigurationDuringStart();
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").body.append(new CharSequence[]{String.format("cd %s", this.getRunDir()), BashCommands.requireExecutable((String)"./sbin/nginx"), NginxSshDriver.sudoBashCIfPrivilegedPort(this.getPort(), String.format("nohup ./sbin/nginx -p %s/ -c conf/server.conf > %s 2>&1 &", this.getRunDir(), this.getLogFileLocation())), String.format("for i in {1..10}\ndo\n    test -f %1$s && ps -p `cat %1$s` && exit\n    sleep 1\ndone\necho \"No explicit error launching nginx but couldn't find process by pid; continuing but may subsequently fail\"\ncat %2$s | tee /dev/stderr", this.getPidFile(), this.getLogFileLocation())}).execute();
    }

    public static String sudoIfPrivilegedPort(int port, String command) {
        return port < 1024 ? BashCommands.sudo((String)command) : command;
    }

    public static String sudoBashCIfPrivilegedPort(int port, String command) {
        return port < 1024 ? BashCommands.sudo((String)("bash -c '" + command + "'")) : command;
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").body.append(new CharSequence[]{String.format("cd %s", this.getRunDir()), String.format("export PID=`cat %s`", this.getPidFile()), "test -n \"$PID\" || exit 0", NginxSshDriver.sudoIfPrivilegedPort(this.getPort(), "kill $PID")}).execute();
    }

    public void kill() {
        this.stop();
    }

    public void reload() {
        this.reloadExecutor.run();
    }

    private void reloadImpl() {
        Lifecycle lifecycle = (Lifecycle)this.entity.getAttribute(NginxController.SERVICE_STATE_ACTUAL);
        if (lifecycle == Lifecycle.STOPPING || lifecycle == Lifecycle.STOPPED || !this.isRunning()) {
            log.debug("Ignoring reload of nginx " + this.entity + ", because service is not running (state " + lifecycle + ")");
            return;
        }
        this.doReloadNow();
    }

    private void doReloadNow() {
        log.debug("reloading nginx by simularing restart (kill -HUP) - {}", (Object)this.entity);
        this.newScript((String)"restarting").body.append(new CharSequence[]{String.format("cd %s", this.getRunDir()), String.format("export PID=`cat %s`", this.getPidFile()), NginxSshDriver.sudoIfPrivilegedPort(this.getPort(), "kill -HUP $PID")}).execute();
    }

    private static class ExecController {
        private final String summary;
        private final Runnable task;
        private final AtomicLong counter = new AtomicLong();

        ExecController(String summary, Runnable task) {
            this.summary = summary;
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run() {
            long preCount = this.counter.get();
            ExecController execController = this;
            synchronized (execController) {
                if (this.counter.compareAndSet(preCount, preCount + 1L)) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("Executing {}; incremented count to {}", new Object[]{this.summary, this.counter});
                        }
                        this.task.run();
                    }
                    catch (Exception e) {
                        if (log.isDebugEnabled()) {
                            log.debug("Failed executing {}; reseting count to {} and propagating exception: {}", new Object[]{this.summary, preCount, e});
                        }
                        this.counter.set(preCount);
                        throw Exceptions.propagate((Throwable)e);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Not executing {} because executed by another thread subsequent to us attempting (preCount {}; count {})", new Object[]{this.summary, preCount, this.counter});
                }
            }
        }
    }
}

