/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.cassandra;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.Socket;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.management.ObjectName;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.java.JavaAppUtils;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.nosql.cassandra.CassandraNode;
import org.apache.brooklyn.entity.nosql.cassandra.CassandraNodeDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.apache.brooklyn.feed.jmx.JmxAttributePollConfig;
import org.apache.brooklyn.feed.jmx.JmxFeed;
import org.apache.brooklyn.feed.jmx.JmxHelper;
import org.apache.brooklyn.feed.jmx.JmxOperationPollConfig;
import org.apache.brooklyn.policy.enricher.RollingTimeWindowMeanEnricher;
import org.apache.brooklyn.policy.enricher.TimeWeightedDeltaEnricher;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CassandraNodeImpl
extends SoftwareProcessImpl
implements CassandraNode {
    private static final Logger log = LoggerFactory.getLogger(CassandraNodeImpl.class);
    private final AtomicReference<Boolean> detectedCloudSensors = new AtomicReference<Boolean>(false);
    private volatile JmxFeed jmxFeed;
    private volatile FunctionFeed functionFeed;
    private JmxFeed jmxMxBeanFeed;
    private JmxHelper jmxHelper;
    private ObjectName storageServiceMBean = JmxHelper.createObjectName((String)"org.apache.cassandra.db:type=StorageService");
    private ObjectName readStageMBean = JmxHelper.createObjectName((String)"org.apache.cassandra.request:type=ReadStage");
    private ObjectName mutationStageMBean = JmxHelper.createObjectName((String)"org.apache.cassandra.request:type=MutationStage");
    private ObjectName snitchMBean = JmxHelper.createObjectName((String)"org.apache.cassandra.db:type=EndpointSnitchInfo");

    public void init() {
        super.init();
        new EffectorBody<String>(){

            public String call(ConfigBag parameters) {
                return CassandraNodeImpl.this.executeScript((String)parameters.getStringKey("commands"));
            }
        };
        this.getMutableEntityType().addEffector(EXECUTE_SCRIPT, (EffectorBody)new ExecuteScriptEffectorBody(this));
        Entities.checkRequiredUrl((Entity)this, (String)this.getCassandraConfigTemplateUrl());
        Entities.getRequiredUrlConfig((Entity)this, (ConfigKey)CASSANDRA_RACKDC_CONFIG_TEMPLATE_URL);
        this.connectEnrichers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCloudPreferredSensorNames() {
        if (this.detectedCloudSensors.get().booleanValue()) {
            return;
        }
        AtomicReference<Boolean> atomicReference = this.detectedCloudSensors;
        synchronized (atomicReference) {
            if (this.detectedCloudSensors.get().booleanValue()) {
                return;
            }
            MachineProvisioningLocation loc = this.getProvisioningLocation();
            if (loc != null) {
                try {
                    Method method = loc.getClass().getMethod("getProvider", new Class[0]);
                    method.setAccessible(true);
                    String provider = (String)method.invoke((Object)loc, new Object[0]);
                    String result = "(nothing special)";
                    if (provider != null) {
                        if (provider.contains("rackspace") || provider.contains("cloudservers") || provider.contains("softlayer")) {
                            if (this.getConfig(LISTEN_ADDRESS_SENSOR) == null) {
                                this.config().set(LISTEN_ADDRESS_SENSOR, (Object)CassandraNode.ADDRESS.getName());
                            }
                            if (this.getConfig(BROADCAST_ADDRESS_SENSOR) == null) {
                                this.config().set(BROADCAST_ADDRESS_SENSOR, (Object)CassandraNode.ADDRESS.getName());
                            }
                            result = "public IP for both listen and broadcast";
                        } else if (provider.contains("google-compute")) {
                            if (this.getConfig(LISTEN_ADDRESS_SENSOR) == null) {
                                this.config().set(LISTEN_ADDRESS_SENSOR, (Object)CassandraNode.SUBNET_HOSTNAME.getName());
                            }
                            if (this.getConfig(BROADCAST_ADDRESS_SENSOR) == null) {
                                this.config().set(BROADCAST_ADDRESS_SENSOR, (Object)CassandraNode.SUBNET_HOSTNAME.getName());
                            }
                            result = "private IP for both listen and broadcast";
                        }
                    }
                    log.debug("Cassandra NICs inferred {} for {}; using location {}, based on provider {}", new Object[]{result, this, loc, provider});
                }
                catch (Exception e) {
                    log.debug("Cassandra NICs auto-detection failed for {} in location {}: {}", new Object[]{this, loc, e});
                }
            }
            this.detectedCloudSensors.set(true);
        }
    }

    protected void preStart() {
        super.preStart();
        this.setCloudPreferredSensorNames();
    }

    @Override
    public String getMajorMinorVersion() {
        String version = (String)this.getConfig(CassandraNode.SUGGESTED_VERSION);
        if (Strings.isBlank((CharSequence)version)) {
            return "";
        }
        ImmutableList versionParts = ImmutableList.copyOf((Iterable)Splitter.on((String)".").split((CharSequence)version));
        return (String)versionParts.get(0) + (versionParts.size() > 1 ? "." + (String)versionParts.get(1) : "");
    }

    public String getCassandraConfigTemplateUrl() {
        String templatedUrl = (String)this.getConfig(CassandraNode.CASSANDRA_CONFIG_TEMPLATE_URL);
        return TemplateProcessor.processTemplateContents((String)templatedUrl, (EntityInternal)this, (Map)ImmutableMap.of());
    }

    @Override
    public Integer getGossipPort() {
        return (Integer)this.getAttribute((AttributeSensor)CassandraNode.GOSSIP_PORT);
    }

    @Override
    public Integer getSslGossipPort() {
        return (Integer)this.getAttribute((AttributeSensor)CassandraNode.SSL_GOSSIP_PORT);
    }

    @Override
    public Integer getThriftPort() {
        return (Integer)this.getAttribute((AttributeSensor)CassandraNode.THRIFT_PORT);
    }

    @Override
    public Integer getNativeTransportPort() {
        return (Integer)this.getAttribute((AttributeSensor)CassandraNode.NATIVE_TRANSPORT_PORT);
    }

    @Override
    public String getClusterName() {
        return (String)this.getAttribute((AttributeSensor)CassandraNode.CLUSTER_NAME);
    }

    @Override
    public int getNumTokensPerNode() {
        return (Integer)this.getConfig(CassandraNode.NUM_TOKENS_PER_NODE);
    }

    @Override
    public Set<BigInteger> getTokens() {
        Set tokens = (Set)this.getAttribute((AttributeSensor)CassandraNode.TOKENS);
        if (tokens == null) {
            tokens = (Set)this.getConfig((ConfigKey.HasConfigKey)CassandraNode.TOKENS);
        }
        return tokens;
    }

    @Override
    public String getTokensAsString() {
        Set<BigInteger> tokens = this.getTokens();
        if (tokens == null) {
            return "";
        }
        return Joiner.on((String)",").join(tokens);
    }

    @Override
    public String getListenAddress() {
        String sensorName = (String)this.getConfig(LISTEN_ADDRESS_SENSOR);
        if (Strings.isNonBlank((CharSequence)sensorName)) {
            return (String)((Task)Entities.submit((Entity)this, (TaskAdaptable)DependentConfiguration.attributeWhenReady((Entity)this, (AttributeSensor)Sensors.newStringSensor((String)sensorName)))).getUnchecked();
        }
        String subnetAddress = (String)this.getAttribute(CassandraNode.SUBNET_ADDRESS);
        return Strings.isNonBlank((CharSequence)subnetAddress) ? subnetAddress : (String)this.getAttribute(CassandraNode.ADDRESS);
    }

    @Override
    public String getBroadcastAddress() {
        String sensorName = (String)this.getConfig(BROADCAST_ADDRESS_SENSOR);
        if (Strings.isNonBlank((CharSequence)sensorName)) {
            return (String)((Task)Entities.submit((Entity)this, (TaskAdaptable)DependentConfiguration.attributeWhenReady((Entity)this, (AttributeSensor)Sensors.newStringSensor((String)sensorName)))).getUnchecked();
        }
        String snitchName = (String)this.getConfig(CassandraNode.ENDPOINT_SNITCH_NAME);
        if (snitchName.equals("Ec2MultiRegionSnitch") || snitchName.contains("MultiCloudSnitch")) {
            return (String)this.getAttribute(CassandraNode.ADDRESS);
        }
        if (!this.getDriver().isClustered()) {
            return this.getListenAddress();
        }
        String hostname = (String)this.getAttribute(CassandraNode.HOSTNAME);
        try {
            String resolvedAddress = this.getDriver().getResolvedAddress(hostname);
            if (resolvedAddress == null) {
                log.debug("Cassandra using broadcast address " + this.getListenAddress() + " for " + this + " because hostname " + hostname + " could not be resolved at remote machine");
                return this.getListenAddress();
            }
            if (resolvedAddress.equals("127.0.0.1")) {
                log.debug("Cassandra using broadcast address " + this.getListenAddress() + " for " + this + " because hostname " + hostname + " resolves to 127.0.0.1");
                return this.getListenAddress();
            }
            return hostname;
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Error resolving hostname " + hostname + " for " + this + ": " + e, (Throwable)e);
            return hostname;
        }
    }

    @Override
    public String getPrivateIp() {
        String sensorName = (String)this.getConfig(BROADCAST_ADDRESS_SENSOR);
        if (Strings.isNonBlank((CharSequence)sensorName)) {
            return (String)this.getAttribute(Sensors.newStringSensor((String)sensorName));
        }
        String subnetAddress = (String)this.getAttribute(CassandraNode.SUBNET_ADDRESS);
        return Strings.isNonBlank((CharSequence)subnetAddress) ? subnetAddress : (String)this.getAttribute(CassandraNode.ADDRESS);
    }

    @Override
    public String getPublicIp() {
        return (String)this.getAttribute(CassandraNode.ADDRESS);
    }

    @Override
    public String getRpcAddress() {
        String sensorName = (String)this.getConfig(RPC_ADDRESS_SENSOR);
        if (Strings.isNonBlank((CharSequence)sensorName)) {
            return (String)((Task)Entities.submit((Entity)this, (TaskAdaptable)DependentConfiguration.attributeWhenReady((Entity)this, (AttributeSensor)Sensors.newStringSensor((String)sensorName)))).getUnchecked();
        }
        return "0.0.0.0";
    }

    @Override
    public String getSeeds() {
        Set seeds = (Set)this.getConfig(CassandraNode.INITIAL_SEEDS);
        if (seeds == null) {
            log.warn("No seeds available when requested for " + this, new Throwable("source of no Cassandra seeds when requested"));
            return null;
        }
        String snitchName = (String)this.getConfig(CassandraNode.ENDPOINT_SNITCH_NAME);
        MutableSet seedsHostnames = MutableSet.of();
        for (Entity entity : seeds) {
            if (snitchName.equals("Ec2MultiRegionSnitch") || snitchName.contains("MultiCloudSnitch")) {
                seedsHostnames.add(entity.getAttribute(CassandraNode.ADDRESS));
                continue;
            }
            String sensorName = (String)this.getConfig(BROADCAST_ADDRESS_SENSOR);
            if (Strings.isNonBlank((CharSequence)sensorName)) {
                seedsHostnames.add(entity.getAttribute(Sensors.newStringSensor((String)sensorName)));
                continue;
            }
            Maybe optionalSeedHostname = Machines.findSubnetOrPublicHostname((Entity)entity);
            if (optionalSeedHostname.isPresent()) {
                String seedHostname = (String)optionalSeedHostname.get();
                seedsHostnames.add((Object)seedHostname);
                continue;
            }
            log.warn("In node {}, seed hostname missing for {}; not including in seeds list", (Object)this, (Object)entity);
        }
        String result = Strings.join((Iterable)seedsHostnames, (String)",");
        log.info("Seeds for {}: {}", (Object)this, (Object)result);
        return result;
    }

    public String getDatacenterName() {
        String name = (String)this.getAttribute((AttributeSensor)CassandraNode.DATACENTER_NAME);
        if (name == null) {
            MachineLocation machine = this.getMachineOrNull();
            MachineProvisioningLocation provisioningLocation = this.getProvisioningLocation();
            if (machine != null) {
                name = (String)machine.getConfig(CloudLocationConfig.CLOUD_REGION_ID);
            }
            if (name == null && provisioningLocation != null) {
                name = (String)provisioningLocation.getConfig(CloudLocationConfig.CLOUD_REGION_ID);
            }
            if (name == null) {
                name = "UNKNOWN_DATACENTER";
            }
            this.sensors().set((AttributeSensor)DATACENTER_NAME, (Object)name);
        }
        return name;
    }

    public String getRackName() {
        String name = (String)this.getAttribute((AttributeSensor)CassandraNode.RACK_NAME);
        if (name == null) {
            MachineLocation machine = this.getMachineOrNull();
            MachineProvisioningLocation provisioningLocation = this.getProvisioningLocation();
            if (machine != null) {
                name = (String)machine.getConfig(CloudLocationConfig.CLOUD_AVAILABILITY_ZONE_ID);
            }
            if (name == null && provisioningLocation != null) {
                name = (String)provisioningLocation.getConfig(CloudLocationConfig.CLOUD_AVAILABILITY_ZONE_ID);
            }
            if (name == null) {
                name = "UNKNOWN_RACK";
            }
            this.sensors().set((AttributeSensor)RACK_NAME, (Object)name);
        }
        return name;
    }

    public Class<? extends CassandraNodeDriver> getDriverInterface() {
        return CassandraNodeDriver.class;
    }

    public CassandraNodeDriver getDriver() {
        return (CassandraNodeDriver)super.getDriver();
    }

    protected void connectSensors() {
        this.sensors().set(DATASTORE_URL, (Object)("cassandra://" + (String)this.getAttribute(HOSTNAME) + ":" + this.getAttribute((AttributeSensor)THRIFT_PORT)));
        super.connectSensors();
        this.jmxHelper = new JmxHelper((Entity)this);
        boolean retrieveUsageMetrics = (Boolean)this.getConfig(RETRIEVE_USAGE_METRICS);
        if (this.getDriver().isJmxEnabled()) {
            this.jmxFeed = JmxFeed.builder().entity((Entity)this).period(3000L, TimeUnit.MILLISECONDS).helper(this.jmxHelper).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(SERVICE_UP_JMX).objectName(this.storageServiceMBean).attributeName("Initialized").onSuccess(Functions.forPredicate((Predicate)Predicates.notNull()))).onException(Functions.constant((Object)false))).suppressDuplicates(true)).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig((AttributeSensor)TOKENS).objectName(this.storageServiceMBean).attributeName("TokenToEndpointMap").onSuccess((Function)new Function<Object, Set<BigInteger>>(){

                public Set<BigInteger> apply(@Nullable Object arg) {
                    Map input = (Map)arg;
                    if (input == null || input.isEmpty()) {
                        return null;
                    }
                    Predicate self = Predicates.in((Collection)ImmutableList.of((Object)CassandraNodeImpl.this.getAttribute(SoftwareProcess.HOSTNAME), (Object)CassandraNodeImpl.this.getAttribute(SoftwareProcess.ADDRESS), (Object)CassandraNodeImpl.this.getAttribute(SoftwareProcess.SUBNET_ADDRESS), (Object)CassandraNodeImpl.this.getAttribute(SoftwareProcess.SUBNET_HOSTNAME)));
                    Set tokens = Maps.filterValues((Map)input, (Predicate)self).keySet();
                    LinkedHashSet result = Sets.newLinkedHashSet();
                    for (String token : tokens) {
                        result.add(new BigInteger(token));
                    }
                    return result;
                }
            })).onException(Functions.constant(null))).suppressDuplicates(true)).pollOperation((JmxOperationPollConfig)((JmxOperationPollConfig)((JmxOperationPollConfig)new JmxOperationPollConfig((AttributeSensor)DATACENTER_NAME).period(60L, TimeUnit.SECONDS)).objectName(this.snitchMBean).operationName("getDatacenter").operationParams((List)ImmutableList.of((Object)this.getBroadcastAddress())).onException(Functions.constant(null))).suppressDuplicates(true)).pollOperation((JmxOperationPollConfig)((JmxOperationPollConfig)((JmxOperationPollConfig)new JmxOperationPollConfig((AttributeSensor)RACK_NAME).period(60L, TimeUnit.SECONDS)).objectName(this.snitchMBean).operationName("getRack").operationParams((List)ImmutableList.of((Object)this.getBroadcastAddress())).onException(Functions.constant(null))).suppressDuplicates(true)).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(PEERS).objectName(this.storageServiceMBean).attributeName("TokenToEndpointMap").onSuccess((Function)new Function<Object, Integer>(){

                public Integer apply(@Nullable Object arg) {
                    Map input = (Map)arg;
                    if (input == null || input.isEmpty()) {
                        return 0;
                    }
                    return input.size();
                }
            })).onException(Functions.constant((Object)-1))).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(LIVE_NODE_COUNT).objectName(this.storageServiceMBean).attributeName("LiveNodes").onSuccess((Function)new Function<Object, Integer>(){

                public Integer apply(@Nullable Object arg) {
                    List input = (List)arg;
                    if (input == null || input.isEmpty()) {
                        return 0;
                    }
                    return input.size();
                }
            })).onException(Functions.constant((Object)-1))).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(READ_ACTIVE).objectName(this.readStageMBean).attributeName("ActiveCount").onException(Functions.constant((Object)null))).enabled(retrieveUsageMetrics)).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(READ_PENDING).objectName(this.readStageMBean).attributeName("PendingTasks").onException(Functions.constant((Object)null))).enabled(retrieveUsageMetrics)).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(READ_COMPLETED).objectName(this.readStageMBean).attributeName("CompletedTasks").onException(Functions.constant((Object)null))).enabled(retrieveUsageMetrics)).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(WRITE_ACTIVE).objectName(this.mutationStageMBean).attributeName("ActiveCount").onException(Functions.constant((Object)null))).enabled(retrieveUsageMetrics)).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(WRITE_PENDING).objectName(this.mutationStageMBean).attributeName("PendingTasks").onException(Functions.constant((Object)null))).enabled(retrieveUsageMetrics)).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(WRITE_COMPLETED).objectName(this.mutationStageMBean).attributeName("CompletedTasks").onException(Functions.constant((Object)null))).enabled(retrieveUsageMetrics)).build();
            this.jmxMxBeanFeed = JavaAppUtils.connectMXBeanSensors((Entity)this);
        }
        if (Boolean.TRUE.equals(this.getConfig(USE_THRIFT_MONITORING))) {
            this.functionFeed = FunctionFeed.builder().entity((Entity)this).period(3000L, TimeUnit.MILLISECONDS).poll((FunctionPollConfig)((FunctionPollConfig)new FunctionPollConfig(THRIFT_PORT_LATENCY).onException(Functions.constant((Object)-1L))).callable((Callable)new ThriftLatencyChecker(this)).enabled(retrieveUsageMetrics)).build();
        }
        this.connectServiceUpIsRunning();
    }

    protected void connectEnrichers() {
        this.connectEnrichers(Duration.TEN_SECONDS);
    }

    protected void connectEnrichers(Duration windowPeriod) {
        JavaAppUtils.connectJavaAppServerPolicies((Entity)this);
        this.enrichers().add((EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)EnricherSpec.create(TimeWeightedDeltaEnricher.class).configure((CharSequence)"producer", (Object)this)).configure((CharSequence)"source", (Object)READ_COMPLETED)).configure((CharSequence)"target", (Object)READS_PER_SECOND_LAST)).configure((CharSequence)"unitMillis", (Object)1000));
        if (windowPeriod != null) {
            this.enrichers().add((EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)EnricherSpec.create(RollingTimeWindowMeanEnricher.class).configure((CharSequence)"producer", (Object)this)).configure((CharSequence)"source", (Object)THRIFT_PORT_LATENCY)).configure((CharSequence)"target", (Object)THRIFT_PORT_LATENCY_IN_WINDOW)).configure((CharSequence)"timePeriod", (Object)windowPeriod));
            this.enrichers().add((EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)EnricherSpec.create(RollingTimeWindowMeanEnricher.class).configure((CharSequence)"producer", (Object)this)).configure((CharSequence)"source", (Object)READS_PER_SECOND_LAST)).configure((CharSequence)"target", (Object)READS_PER_SECOND_IN_WINDOW)).configure((CharSequence)"timePeriod", (Object)windowPeriod));
            this.enrichers().add((EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)EnricherSpec.create(RollingTimeWindowMeanEnricher.class).configure((CharSequence)"producer", (Object)this)).configure((CharSequence)"source", (Object)WRITES_PER_SECOND_LAST)).configure((CharSequence)"target", (Object)WRITES_PER_SECOND_IN_WINDOW)).configure((CharSequence)"timePeriod", (Object)windowPeriod));
        }
        if (Boolean.TRUE.equals(this.getConfig(USE_THRIFT_MONITORING))) {
            this.enrichers().add(((Enrichers.UpdatingMapBuilder)Enrichers.builder().updatingMap(Attributes.SERVICE_NOT_UP_INDICATORS).from(THRIFT_PORT_LATENCY).computing((Function)Functionals.ifEquals((Object)-1L).value((Object)"Thrift latency polling failed"))).build());
        }
        if (Boolean.TRUE.equals(this.getConfig(UsesJmx.USE_JMX))) {
            this.enrichers().add(((Enrichers.UpdatingMapBuilder)Enrichers.builder().updatingMap(Attributes.SERVICE_NOT_UP_INDICATORS).from(SERVICE_UP_JMX).computing((Function)Functionals.ifEquals((Object)false).value((Object)"JMX reports not up"))).build());
        }
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
        if (this.jmxMxBeanFeed != null) {
            this.jmxMxBeanFeed.stop();
        }
        if (this.jmxHelper != null) {
            this.jmxHelper.terminate();
        }
        if (this.functionFeed != null) {
            this.functionFeed.stop();
        }
    }

    @Override
    public void setToken(String token) {
        try {
            if (!this.jmxHelper.isConnected()) {
                this.jmxHelper.connect();
            }
            this.jmxHelper.operation(this.storageServiceMBean, "move", new Object[]{token});
            log.info("Moved server {} to token {}", (Object)this.getId(), (Object)token);
        }
        catch (IOException ioe) {
            Throwables.propagate((Throwable)ioe);
        }
    }

    @Override
    public String executeScript(String commands) {
        return this.getDriver().executeScriptAsync(commands).block().getStdout();
    }

    private static class ThriftLatencyChecker
    implements Callable<Long> {
        private final CassandraNode entity;

        public ThriftLatencyChecker(CassandraNode entity) {
            this.entity = entity;
        }

        @Override
        public Long call() {
            Integer privatePort = this.entity.getThriftPort();
            if (privatePort == null) {
                return -1L;
            }
            HostAndPort hp = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this.entity, (int)privatePort);
            try {
                long start = System.currentTimeMillis();
                Socket s = new Socket(hp.getHostText(), hp.getPort());
                s.close();
                long latency = System.currentTimeMillis() - start;
                return latency;
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                if (log.isDebugEnabled()) {
                    log.debug("Cassandra thrift port poll failure: " + e);
                }
                return -1L;
            }
        }
    }

    private static class ExecuteScriptEffectorBody
    extends EffectorBody<String> {
        private final CassandraNode entity;

        public ExecuteScriptEffectorBody(CassandraNode entity) {
            this.entity = entity;
        }

        public String call(ConfigBag parameters) {
            return this.entity.executeScript((String)parameters.getStringKey("commands"));
        }
    }
}

