/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.hazelcast;

import com.google.common.reflect.TypeToken;
import java.util.List;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.nosql.hazelcast.HazelcastClusterImpl;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@Catalog(name="Hazelcast Cluster", description="Hazelcast is a clustering and highly scalable data distribution platform for Java.")
@ImplementedBy(value=HazelcastClusterImpl.class)
public interface HazelcastCluster
extends DynamicCluster {
    @SetFromFlag(value="clusterName")
    public static final BasicAttributeSensorAndConfigKey<String> CLUSTER_NAME = new BasicAttributeSensorAndConfigKey(String.class, "hazelcast.cluster.name", "Name of the Hazelcast cluster", (Object)"HazelcastCluster");
    @SetFromFlag(value="clusterPassword")
    public static final ConfigKey<String> CLUSTER_PASSWORD = ConfigKeys.newStringConfigKey((String)"hazelcast.cluster.password", (String)"Hazelcast cluster password.");
    public static final AttributeSensor<List<String>> PUBLIC_CLUSTER_NODES = Sensors.newSensor((TypeToken)new TypeToken<List<String>>(){}, (String)"hazelcast.cluster.public.nodes", (String)"List of public addresses of all nodes in the cluster");

    public String getClusterName();

    public String getClusterPassword();
}

