/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.javalang;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.guava.TypeTokens;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.javalang.FieldOrderings;
import org.apache.brooklyn.util.javalang.MethodAccessibleReflections;
import org.apache.brooklyn.util.javalang.coerce.TypeCoercer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reflections {
    private static final Logger LOG = LoggerFactory.getLogger(Reflections.class);
    private final ClassLoader classLoader;
    private final Map<String, String> classRenameMap = MutableMap.of();

    public Reflections(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : this.getClass().getClassLoader();
    }

    public Reflections applyClassRenames(Map<String, String> newClassRenames) {
        this.classRenameMap.putAll(newClassRenames);
        return this;
    }

    public Object loadInstance(String classname, Object ... argValues) throws ReflectionNotFoundException, ReflectionAccessException {
        Class<?> clazz = this.loadClass(classname);
        Maybe<?> v = null;
        try {
            v = Reflections.invokeConstructorFromArgs(clazz, argValues);
            if (v.isPresent()) {
                return v.get();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error invoking constructor for " + clazz + Arrays.toString(argValues) + ": " + Exceptions.collapseText(e));
        }
        throw new IllegalStateException("No suitable constructor for " + clazz + Arrays.toString(argValues));
    }

    public Object loadInstance(String classname, Class<?>[] argTypes, Object[] argValues) throws ReflectionNotFoundException, ReflectionAccessException {
        Class<?> clazz = this.loadClass(classname);
        Constructor<?> constructor = this.loadConstructor(clazz, argTypes);
        return this.loadInstance(constructor, argValues);
    }

    public Object loadInstance(String classname) throws ReflectionNotFoundException, ReflectionAccessException {
        Class<?> clazz = this.loadClass(classname);
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new ReflectionAccessException("Failed to create instance of class '" + classname + "' using class loader " + this.classLoader + ": " + Exceptions.collapseText(e), e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionAccessException("Failed to create instance of class '" + classname + "' using class loader " + this.classLoader + ": " + Exceptions.collapseText(e), e);
        }
    }

    public Class<?> loadClass(String classname) throws ReflectionNotFoundException {
        try {
            classname = Reflections.findMappedNameAndLog(this.classRenameMap, classname);
            return this.classLoader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionNotFoundException("Failed to load class '" + classname + "' using class loader " + this.classLoader + ": " + Exceptions.collapseText(e), e);
        }
        catch (NoClassDefFoundError e) {
            throw new ReflectionNotFoundException("Failed to load class '" + classname + "' using class loader " + this.classLoader + ": " + Exceptions.collapseText(e), e);
        }
        catch (UnsupportedClassVersionError e) {
            throw new ReflectionNotFoundException("Failed to load class '" + classname + "' using class loader " + this.classLoader + ": " + Exceptions.collapseText(e), e);
        }
    }

    public <T> Class<? extends T> loadClass(String classname, Class<T> superType) throws ReflectionNotFoundException {
        return this.loadClass(classname);
    }

    public static Class<?> loadInnerClassPossiblyInheritted(Class<?> clazz, String nestedPart) throws ReflectionNotFoundException {
        HashSet<String> visited = new HashSet<String>();
        Class<?> result = Reflections.loadInnerClassPossiblyInheritted(visited, clazz, nestedPart);
        if (result != null) {
            return result;
        }
        throw new ReflectionNotFoundException("Inner class " + nestedPart + " could not be found in " + clazz + " or any of its super-types");
    }

    private static Class<?> loadInnerClassPossiblyInheritted(Set<String> visited, Class<?> clazz, String nestedPart) throws ReflectionNotFoundException {
        if (clazz == null) {
            return null;
        }
        if (nestedPart == null || nestedPart.length() == 0) {
            return clazz;
        }
        int i1 = nestedPart.indexOf(36);
        int i2 = nestedPart.indexOf(46);
        int idx = i2 > -1 && (i2 < i1 || i1 == -1) ? i2 : i1;
        String thisClassToFind = nestedPart;
        String nextClassesToFind = "";
        if (idx >= 0) {
            thisClassToFind = nestedPart.substring(0, idx);
            nextClassesToFind = nestedPart.substring(idx + 1);
        }
        if (!visited.add(clazz.getCanonicalName() + "!" + nestedPart)) {
            return null;
        }
        Class<?>[] members = clazz.getClasses();
        for (int i = 0; i < members.length; ++i) {
            Class<?> clazzI;
            if (!members[i].getSimpleName().equals(thisClassToFind) || (clazzI = Reflections.loadInnerClassPossiblyInheritted(visited, members[i], nextClassesToFind)) == null) continue;
            return clazzI;
        }
        Class<?> result = Reflections.loadInnerClassPossiblyInheritted(visited, clazz.getSuperclass(), nestedPart);
        if (result != null) {
            return result;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            result = Reflections.loadInnerClassPossiblyInheritted(visited, iface, nestedPart);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Class<?> loadInnerClassNotInheritted(String outerClassname, String innerClassname) throws ReflectionNotFoundException {
        return this.loadClass(outerClassname + "$" + innerClassname);
    }

    public Class<?> loadInnerClassNotInheritted(Class<?> outerClazz, String innerClassname) throws ReflectionNotFoundException {
        return this.loadClass(outerClazz.getName() + "$" + innerClassname);
    }

    public Constructor<?> loadConstructor(Class<?> clazz, Class<?>[] argTypes) throws ReflectionAccessException {
        try {
            return clazz.getConstructor(argTypes);
        }
        catch (SecurityException e) {
            throw new ReflectionAccessException("Failed to load constructor of class '" + clazz + " with argument types " + Arrays.asList(argTypes) + ": " + Exceptions.collapseText(e), e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionAccessException("Failed to load constructor of class '" + clazz + " with argument types " + Arrays.asList(argTypes) + ": " + Exceptions.collapseText(e), e);
        }
    }

    @Deprecated
    public static <T> Optional<T> invokeConstructorWithArgs(ClassLoader classLoader, String className, Object ... argsArray) {
        return Reflections.invokeConstructorFromArgsUntyped(classLoader, className, argsArray).toOptional();
    }

    @Deprecated
    public static <T> Optional<T> invokeConstructorWithArgs(ClassLoader classLoader, Class<T> clazz, Object[] argsArray, boolean setAccessible) {
        return Reflections.invokeConstructorFromArgs(classLoader, clazz, argsArray, setAccessible).toOptional();
    }

    @Deprecated
    public static <T> Optional<T> invokeConstructorWithArgs(Class<? extends T> clazz, Object ... argsArray) {
        return Reflections.invokeConstructorFromArgs(clazz, argsArray).toOptional();
    }

    @Deprecated
    public static <T> Optional<T> invokeConstructorWithArgs(Class<? extends T> clazz, Object[] argsArray, boolean setAccessible) {
        return Reflections.invokeConstructorFromArgs(clazz, argsArray, setAccessible).toOptional();
    }

    @Deprecated
    public static <T> Optional<T> invokeConstructorWithArgs(Reflections reflections, Class<? extends T> clazz, Object[] argsArray, boolean setAccessible) {
        return Reflections.invokeConstructorFromArgs(reflections, clazz, argsArray, setAccessible).toOptional();
    }

    public static <T> Maybe<T> invokeConstructorFromArgs(Class<? extends T> clazz, Object ... argsArray) {
        return Reflections.invokeConstructorFromArgs(clazz, argsArray, false);
    }

    public static Maybe<Object> invokeConstructorFromArgs(ClassLoader classLoader, String className, Object ... argsArray) {
        return Reflections.invokeConstructorFromArgs(classLoader, null, className, argsArray);
    }

    public static <T> Maybe<T> invokeConstructorFromArgs(ClassLoader classLoader, Class<T> optionalSupertype, String className, Object ... argsArray) {
        Reflections reflections = new Reflections(classLoader);
        Class<?> clazz = reflections.loadClass(className);
        if (optionalSupertype != null && !optionalSupertype.isAssignableFrom(clazz)) {
            return Maybe.absent("The type requested '" + className + "' is not assignable to " + optionalSupertype);
        }
        return Reflections.invokeConstructorFromArgs(reflections, clazz, argsArray, false);
    }

    public static <T> Maybe<T> invokeConstructorFromArgsUntyped(ClassLoader classLoader, String className, Object ... argsArray) {
        Reflections reflections = new Reflections(classLoader);
        Class<?> clazz = reflections.loadClass(className);
        return Reflections.invokeConstructorFromArgs(reflections, clazz, argsArray, false);
    }

    public static <T> Maybe<T> invokeConstructorFromArgs(ClassLoader classLoader, Class<T> clazz, Object[] argsArray, boolean setAccessible) {
        Reflections reflections = new Reflections(classLoader);
        return Reflections.invokeConstructorFromArgs(reflections, clazz, argsArray, setAccessible);
    }

    public static <T> Maybe<T> invokeConstructorFromArgs(Class<? extends T> clazz, Object[] argsArray, boolean setAccessible) {
        Reflections reflections = new Reflections(clazz.getClassLoader());
        return Reflections.invokeConstructorFromArgs(reflections, clazz, argsArray, setAccessible);
    }

    public static <T> Maybe<T> invokeConstructorFromArgsIncludingPrivate(Class<? extends T> clazz, Object ... argsArray) {
        return Reflections.invokeConstructorFromArgs(new Reflections(clazz.getClassLoader()), clazz, argsArray, true);
    }

    public static <T> Maybe<T> invokeConstructorFromArgs(Reflections reflections, Class<? extends T> clazz, Object[] argsArray, boolean setAccessible) {
        for (Constructor constructor : MutableList.of().appendAll(Arrays.asList(clazz.getConstructors())).appendAll(Arrays.asList(clazz.getDeclaredConstructors()))) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (constructor.isVarArgs() && Reflections.typesMatchUpTo(argsArray, parameterTypes, parameterTypes.length - 1)) {
                Class<?> varargType = parameterTypes[parameterTypes.length - 1].getComponentType();
                boolean varargsMatch = true;
                for (int i = parameterTypes.length - 1; i < argsArray.length; ++i) {
                    if (Boxing.boxedType(varargType).isInstance(argsArray[i]) && (!varargType.isPrimitive() || argsArray[i] != null)) continue;
                    varargsMatch = false;
                    break;
                }
                if (varargsMatch) {
                    Object varargs = Array.newInstance(varargType, argsArray.length + 1 - parameterTypes.length);
                    for (int i = parameterTypes.length - 1; i < argsArray.length; ++i) {
                        Boxing.setInArray(varargs, i + 1 - parameterTypes.length, argsArray[i], varargType);
                    }
                    Object[] newArgsArray = new Object[parameterTypes.length];
                    System.arraycopy(argsArray, 0, newArgsArray, 0, parameterTypes.length - 1);
                    newArgsArray[parameterTypes.length - 1] = varargs;
                    if (setAccessible) {
                        constructor.setAccessible(true);
                    }
                    return Maybe.of(reflections.loadInstance(constructor, newArgsArray));
                }
            }
            if (!Reflections.typesMatch(argsArray, parameterTypes)) continue;
            if (setAccessible) {
                constructor.setAccessible(true);
            }
            return Maybe.of(reflections.loadInstance(constructor, argsArray));
        }
        return Maybe.absent("Constructor not found");
    }

    public Constructor<?> loadSingleConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 1) {
            return constructors[0];
        }
        throw new IllegalArgumentException("Class " + clazz + " has more than one constructor");
    }

    public <T> T loadInstance(Constructor<T> constructor, Object ... argValues) throws IllegalArgumentException, ReflectionAccessException {
        try {
            try {
                return constructor.newInstance(argValues);
            }
            catch (IllegalArgumentException e) {
                try {
                    try {
                        LOG.warn("Failure passing provided arguments (" + Reflections.getIllegalArgumentsErrorMessage(constructor, argValues) + "; " + e + "); attempting to reconstitute");
                        argValues = (Object[])this.updateFromNewClassLoader(argValues);
                        return constructor.newInstance(argValues);
                    }
                    catch (Throwable e2) {
                        LOG.warn("Reconstitution attempt failed (will rethrow original excaption): " + e2, e2);
                        throw e;
                    }
                }
                catch (IllegalArgumentException e2) {
                    throw new IllegalArgumentException(Reflections.getIllegalArgumentsErrorMessage(constructor, argValues) + ": " + Exceptions.collapseText(e2), e2);
                }
            }
        }
        catch (InstantiationException e) {
            throw new ReflectionAccessException("Failed to create instance of " + constructor.getDeclaringClass() + ": " + Exceptions.collapseText(e), e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionAccessException("Failed to create instance of " + constructor.getDeclaringClass() + ": " + Exceptions.collapseText(e), e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionAccessException("Failed to create instance of " + constructor.getDeclaringClass() + ": " + Exceptions.collapseText(e), e);
        }
    }

    public Method loadMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) throws ReflectionNotFoundException, ReflectionAccessException {
        try {
            return clazz.getMethod(methodName, argTypes);
        }
        catch (NoClassDefFoundError e) {
            throw new ReflectionNotFoundException("Failed to invoke method " + methodName + " on class " + clazz + " with argument types " + Arrays.asList(argTypes) + ", using class loader " + clazz.getClassLoader() + ": " + Exceptions.collapseText(e), e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionNotFoundException("Failed to invoke method " + methodName + " on class " + clazz + " with argument types " + Arrays.asList(argTypes) + ": " + Exceptions.collapseText(e), e);
        }
        catch (SecurityException e) {
            throw new ReflectionAccessException("Failed to invoke method " + methodName + " on class " + clazz + " with argument types " + Arrays.asList(argTypes) + ": " + Exceptions.collapseText(e), e);
        }
    }

    public Method loadMethod(Class<?> clazz, String methodName) throws ReflectionNotFoundException, ReflectionAccessException {
        try {
            Method[] allmethods = clazz.getMethods();
            for (int i = 0; i < allmethods.length; ++i) {
                if (!allmethods[i].getName().equals(methodName)) continue;
                return allmethods[i];
            }
            throw new ReflectionNotFoundException("Cannot find method " + methodName + " on class " + clazz);
        }
        catch (SecurityException e) {
            throw new ReflectionAccessException("Failed to invoke method '" + methodName + " on class " + clazz + ": " + Exceptions.collapseText(e), e);
        }
    }

    public Object invokeMethod(Method method, Object obj, Object ... argValues) throws ReflectionAccessException {
        try {
            return method.invoke(obj, argValues);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Reflections.getIllegalArgumentsErrorMessage(method, argValues), e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionAccessException("Failed to invoke method '" + method.toGenericString() + " on class " + method.getDeclaringClass() + " with argument values " + Arrays.asList(argValues) + ": " + Exceptions.collapseText(e), e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionAccessException("Failed to invoke method '" + method.toGenericString() + " on class " + method.getDeclaringClass() + " with argument values " + Arrays.asList(argValues) + ": " + Exceptions.collapseText(e), e);
        }
    }

    public Object invokeStaticMethod(Method method, Object ... argValues) throws IllegalArgumentException, ReflectionAccessException {
        try {
            return method.invoke(null, argValues);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Reflections.getIllegalArgumentsErrorMessage(method, argValues), e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionAccessException("Failed to invoke method '" + method.toGenericString() + " on class " + method.getDeclaringClass() + " with argument values " + Arrays.asList(argValues) + ": " + Exceptions.collapseText(e), e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionAccessException("Failed to invoke method '" + method.toGenericString() + " on class " + method.getDeclaringClass() + " with argument values " + Arrays.asList(argValues) + ": " + Exceptions.collapseText(e), e);
        }
    }

    public Object loadStaticField(Class<?> clazz, String fieldname) throws ReflectionAccessException {
        return this.loadStaticFields(clazz, new String[]{fieldname}, null)[0];
    }

    public Object[] loadStaticFields(Class<?> clazz, String[] fieldnamesArray, Object[] defaults) throws ReflectionAccessException {
        Object[] result = new Object[fieldnamesArray.length];
        if (defaults != null) {
            for (int i = 0; i < defaults.length; ++i) {
                result[i] = defaults[i];
            }
        }
        List<String> fieldnames = Arrays.asList(fieldnamesArray);
        Field[] classFields = clazz.getDeclaredFields();
        for (int i = 0; i < classFields.length; ++i) {
            Field field = classFields[i];
            int index = fieldnames.indexOf(field.getName());
            if (index < 0) continue;
            try {
                result[index] = field.get(null);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionAccessException("Failed to load field '" + field.getName() + " from class " + clazz + ": " + Exceptions.collapseText(e), e);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionAccessException("Failed to load field '" + field.getName() + " from class " + clazz + ": " + Exceptions.collapseText(e), e);
            }
        }
        return result;
    }

    private static String getIllegalArgumentsErrorMessage(Method method, Object[] argValues) {
        return method.toGenericString() + " not applicable for the parameters of type " + Reflections.argumentTypesToString(argValues);
    }

    private static String getIllegalArgumentsErrorMessage(Constructor<?> constructor, Object[] argValues) {
        return constructor.toGenericString() + " not applicable for the parameters of type " + Reflections.argumentTypesToString(argValues);
    }

    private static String argumentTypesToString(Object[] argValues) {
        StringBuffer msg = new StringBuffer("(");
        for (int i = 0; i < argValues.length; ++i) {
            if (i != 0) {
                msg.append(", ");
            }
            msg.append(argValues[i] != null ? argValues[i].getClass().getName() : "null");
        }
        msg.append(")");
        return msg.toString();
    }

    public static <T> void copyFields(T source, T target) throws IllegalArgumentException, IllegalAccessException {
        for (Class<?> clazz = source.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field f : fields = clazz.getDeclaredFields()) {
                f.setAccessible(true);
                Object vs = f.get(source);
                Object vt = f.get(target);
                if ((vs != null || vt == null) && (vs == null || vs.equals(vt))) continue;
                f.set(target, vs);
            }
        }
    }

    public Class<?> loadClassFromCanonicalName(String canonicalName) throws ClassNotFoundException, ReflectionNotFoundException {
        ClassNotFoundException err = null;
        String name = canonicalName;
        while (true) {
            try {
                return this.classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                int lastIndexOf;
                if (err == null) {
                    err = e;
                }
                if ((lastIndexOf = name.lastIndexOf(".")) < 0) continue;
                name = name.substring(0, lastIndexOf) + "$" + name.substring(lastIndexOf + 1);
                if (name.contains(".")) continue;
                throw err;
            }
            break;
        }
    }

    @Nullable
    public URL getResource(String r) {
        URL u = null;
        u = this.classLoader.getResource(r);
        if (u != null) {
            return u;
        }
        r = r.startsWith("/") ? r.substring(1) : "/" + r;
        return this.classLoader.getResource(r);
    }

    public final Object updateFromNewClassLoader(Object data) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        new ObjectOutputStream(bytes).writeObject(data);
        Object reconstituted = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray())).readObject();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reconstituted data: " + reconstituted + ", class loader: " + this.classLoader);
        }
        return reconstituted;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static <T> Class<? super T> findSuperType(T impl, String typeName) {
        LinkedHashSet toinspect = new LinkedHashSet();
        HashSet<Class> inspected = new HashSet<Class>();
        toinspect.add(impl.getClass());
        while (toinspect.size() > 0) {
            Class clazz = (Class)toinspect.iterator().next();
            if (clazz.getName().equals(typeName)) {
                return clazz;
            }
            inspected.add(clazz);
            List<Class<?>> toAdd = Arrays.asList(clazz.getInterfaces());
            toinspect.addAll(toAdd);
            if (clazz.getSuperclass() != null) {
                toinspect.add(clazz.getSuperclass());
            }
            toinspect.removeAll(inspected);
        }
        return null;
    }

    public static Set<Class<?>> getInterfacesIncludingClassAncestors(Class<?> clazz) {
        LinkedHashSet result = new LinkedHashSet();
        while (clazz != null) {
            for (Class<?> iface : clazz.getInterfaces()) {
                result.add(iface);
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static Maybe<Method> findMethodMaybe(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        if (clazz == null || name == null) {
            return Maybe.absentNoTrace("class or name is null");
        }
        Iterable<Method> result = Reflections.findMethods(false, clazz, name, parameterTypes);
        if (!result.iterator().hasNext()) {
            return Maybe.absentNoTrace("no methods matching " + clazz.getName() + "." + name + "(" + Arrays.asList(parameterTypes) + ")");
        }
        return Maybe.of(result.iterator().next());
    }

    public static Iterable<Method> findMethodsCompatible(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        return Reflections.findMethods(true, clazz, name, parameterTypes);
    }

    private static Iterable<Method> findMethods(boolean allowCovariantParameterClasses, Class<?> clazz, String name, Class<?> ... parameterTypes) {
        if (clazz == null || name == null) {
            return Collections.emptySet();
        }
        MutableList<Method> result = MutableList.of();
        for (Class<?> clazzToInspect = clazz; clazzToInspect != null; clazzToInspect = clazzToInspect.getSuperclass()) {
            block1: for (Method m : clazzToInspect.getDeclaredMethods()) {
                if (!name.equals(m.getName()) || m.getParameterTypes().length != parameterTypes.length) continue;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (!m.getParameterTypes()[i].equals(parameterTypes[i]) && (!allowCovariantParameterClasses || !m.getParameterTypes()[i].isAssignableFrom(parameterTypes[i]))) continue block1;
                }
                result.add(m);
            }
        }
        return result;
    }

    @Deprecated
    public static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        if (clazz == null || name == null) {
            throw new NullPointerException("Must not be null: clazz=" + clazz + "; name=" + name);
        }
        NoSuchMethodException toThrowIfFails = null;
        for (Class<?> clazzToInspect = clazz; clazzToInspect != null; clazzToInspect = clazzToInspect.getSuperclass()) {
            try {
                return clazzToInspect.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                if (toThrowIfFails != null) continue;
                toThrowIfFails = e;
                continue;
            }
        }
        throw toThrowIfFails;
    }

    public static Field findField(Class<?> clazz, String name) throws NoSuchFieldException {
        return Reflections.findFieldMaybe(clazz, name).orThrowUnwrapped();
    }

    public static Maybe<Field> findFieldMaybe(Class<?> clazz, String originalName) {
        String name = originalName;
        if (clazz == null || name == null) {
            throw new NullPointerException("Must not be null: clazz=" + clazz + "; name=" + name);
        }
        Class<?> clazzToInspect = clazz;
        NoSuchFieldException toThrowIfFails = null;
        String clazzRequired = null;
        if (name.indexOf(46) >= 0) {
            int lastDotIndex = name.lastIndexOf(46);
            clazzRequired = name.substring(0, lastDotIndex);
            name = name.substring(lastDotIndex + 1);
        }
        while (clazzToInspect != null) {
            block7: {
                try {
                    if (clazzRequired == null || clazzRequired.equals(clazzToInspect.getCanonicalName())) {
                        return Maybe.of(clazzToInspect.getDeclaredField(name));
                    }
                }
                catch (NoSuchFieldException e) {
                    if (toThrowIfFails != null) break block7;
                    toThrowIfFails = e;
                }
            }
            clazzToInspect = clazzToInspect.getSuperclass();
        }
        if (toThrowIfFails == null) {
            return Maybe.absent("Field '" + originalName + "' not found");
        }
        return Maybe.absent(toThrowIfFails);
    }

    public static Maybe<Object> getFieldValueMaybe(Object instance, String fieldName) {
        try {
            if (instance == null) {
                return null;
            }
            Field f = Reflections.findField(instance.getClass(), fieldName);
            return Reflections.getFieldValueMaybe(instance, f);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal(e);
            return Maybe.absent(e);
        }
    }

    @Nonnull
    public static Maybe<Object> getFieldValueMaybe(Object instance, Field field) {
        try {
            if (instance == null) {
                return null;
            }
            if (field == null) {
                return null;
            }
            field.setAccessible(true);
            return Maybe.of(field.get(instance));
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal(e);
            return Maybe.absent(e);
        }
    }

    public static List<Field> findPublicFieldsOrderedBySuper(Class<?> clazz) {
        return Reflections.findFields(clazz, new Predicate<Field>(){

            public boolean apply(Field input) {
                return Modifier.isPublic(input.getModifiers());
            }
        }, FieldOrderings.SUB_BEST_FIELD_LAST_THEN_DEFAULT);
    }

    public static List<Field> findFields(Class<?> clazz, Predicate<Field> filter, Comparator<Field> fieldOrdering) {
        Preconditions.checkNotNull(clazz, (Object)"clazz");
        MutableList.Builder result = MutableList.builder();
        Stack tovisit = new Stack();
        LinkedHashSet visited = Sets.newLinkedHashSet();
        tovisit.push(clazz);
        while (!tovisit.isEmpty()) {
            Class nextclazz = (Class)tovisit.pop();
            if (!visited.add(nextclazz)) continue;
            if (nextclazz.getSuperclass() != null) {
                tovisit.add(nextclazz.getSuperclass());
            }
            tovisit.addAll(Arrays.asList(nextclazz.getInterfaces()));
            result.addAll(Iterables.filter(Arrays.asList(nextclazz.getDeclaredFields()), (Predicate)(filter != null ? filter : Predicates.alwaysTrue())));
        }
        MutableList<Field> resultList = result.build();
        Collections.sort(resultList, fieldOrdering != null ? fieldOrdering : FieldOrderings.SUB_BEST_FIELD_LAST_THEN_ALPHABETICAL);
        return resultList;
    }

    public static List<Method> findPublicMethodsOrderedBySuper(Class<?> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"clazz");
        MutableList.Builder result = MutableList.builder();
        Stack tovisit = new Stack();
        LinkedHashSet visited = Sets.newLinkedHashSet();
        tovisit.push(clazz);
        while (!tovisit.isEmpty()) {
            Class nextclazz = (Class)tovisit.pop();
            if (!visited.add(nextclazz)) continue;
            if (nextclazz.getSuperclass() != null) {
                tovisit.add(nextclazz.getSuperclass());
            }
            tovisit.addAll(Arrays.asList(nextclazz.getInterfaces()));
            result.addAll(Iterables.filter(Arrays.asList(nextclazz.getDeclaredMethods()), (Predicate)new Predicate<Method>(){

                public boolean apply(Method input) {
                    return Modifier.isPublic(input.getModifiers());
                }
            }));
        }
        MutableList<Method> resultList = result.build();
        Collections.sort(resultList, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                Method msubbest = Reflections.inferSubbestMethod(m1, m2);
                return msubbest == null ? 0 : (msubbest == m1 ? 1 : -1);
            }
        });
        return resultList;
    }

    public static Field inferSubbestField(Field f1, Field f2) {
        Class<?> c1 = f1.getDeclaringClass();
        Class<?> c2 = f2.getDeclaringClass();
        boolean isSuper1 = c1.isAssignableFrom(c2);
        boolean isSuper2 = c2.isAssignableFrom(c1);
        return isSuper1 ? (isSuper2 ? null : f2) : (isSuper2 ? f1 : null);
    }

    public static Method inferSubbestMethod(Method m1, Method m2) {
        Class<?> c1 = m1.getDeclaringClass();
        Class<?> c2 = m2.getDeclaringClass();
        boolean isSuper1 = c1.isAssignableFrom(c2);
        boolean isSuper2 = c2.isAssignableFrom(c1);
        return isSuper1 ? (isSuper2 ? null : m2) : (isSuper2 ? m1 : null);
    }

    public static Class<?> inferSubbest(Class<?> c1, Class<?> c2) {
        boolean isSuper1 = c1.isAssignableFrom(c2);
        boolean isSuper2 = c2.isAssignableFrom(c1);
        return isSuper1 ? (isSuper2 ? null : c2) : (isSuper2 ? c1 : null);
    }

    public static <T> T cast(Object candidate, Class<? extends T> type) {
        if (candidate == null) {
            return null;
        }
        if (!type.isAssignableFrom(candidate.getClass())) {
            throw new IllegalArgumentException("Requires a " + type + ", but had a " + candidate.getClass() + " (" + candidate + ")");
        }
        return (T)candidate;
    }

    @Deprecated
    public static Optional<Object> invokeMethodWithArgs(Object clazzOrInstance, String method, List<?> args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return Reflections.invokeMethodWithArgs(clazzOrInstance, method, args, false);
    }

    @Deprecated
    public static Optional<Object> invokeMethodWithArgs(Object clazzOrInstance, String method, List<?> args, boolean setAccessible) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return Reflections.invokeMethodFromArgs(clazzOrInstance, method, args, setAccessible).toOptional();
    }

    public static Maybe<Object> invokeMethodFromArgs(Object clazzOrInstance, String method, List<?> args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return Reflections.invokeMethodFromArgs(clazzOrInstance, method, args, false);
    }

    public static Maybe<Object> invokeMethodFromArgs(Object clazzOrInstance, String method, List<?> args, boolean setAccessible) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return Reflections.invokeMethodFromArgs(clazzOrInstance, method, args, setAccessible, (Optional<? extends TypeCoercer>)Optional.absent());
    }

    public static Maybe<Object> invokeMethodFromArgs(Object clazzOrInstance, String method, List<?> args, boolean setAccessible, Optional<? extends TypeCoercer> coercer) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Maybe<Method> maybeMethod = Reflections.getMethodFromArgs(clazzOrInstance, method, args);
        if (coercer.isPresent() && maybeMethod.isAbsent()) {
            maybeMethod = Reflections.getMethodFromArgs(clazzOrInstance, method, args, coercer);
        }
        if (maybeMethod.isAbsent()) {
            return Maybe.absent(Maybe.getException(maybeMethod));
        }
        Method m = maybeMethod.get();
        return Maybe.of(Reflections.invokeMethodFromArgs(clazzOrInstance, m, args, setAccessible, coercer));
    }

    public static Maybe<Method> getMethodFromArgs(Object clazzOrInstance, String method, List<?> args) {
        return Reflections.getMethodFromArgs(clazzOrInstance, method, args, (Optional<? extends TypeCoercer>)Optional.absent());
    }

    public static Maybe<Method> getMethodFromArgs(Object clazzOrInstance, String method, List<?> args, Optional<? extends TypeCoercer> coercer) {
        Preconditions.checkNotNull((Object)clazzOrInstance, (Object)"clazz or instance");
        Preconditions.checkNotNull((Object)method, (Object)"method");
        Preconditions.checkNotNull(args, (Object)("args to " + method));
        Class<?> clazz = clazzOrInstance instanceof Class ? (Class<?>)clazzOrInstance : clazzOrInstance.getClass();
        Object[] argsArray = args.toArray();
        for (Method m : clazz.getMethods()) {
            if (!method.equals(m.getName())) continue;
            Class<?>[] parameterTypes = m.getParameterTypes();
            if (m.isVarArgs() && Reflections.typesMatchUpTo(argsArray, parameterTypes, parameterTypes.length - 1, coercer)) {
                Class<?> varargType = parameterTypes[parameterTypes.length - 1].getComponentType();
                boolean varargsMatch = true;
                for (int i = parameterTypes.length - 1; i < argsArray.length; ++i) {
                    if (Reflections.typeMatches(argsArray[i], varargType, coercer)) continue;
                    varargsMatch = false;
                    break;
                }
                if (varargsMatch) {
                    return Maybe.of(m);
                }
            }
            if (!Reflections.typesMatch(argsArray, parameterTypes, coercer)) continue;
            return Maybe.of(m);
        }
        ArrayList argTypes = Lists.newArrayList();
        for (Object arg : args) {
            argTypes.add(arg == null ? "<null>" : arg.getClass().getSimpleName());
        }
        return Maybe.absent("Method '" + method + "' not found matching given args of type " + argTypes);
    }

    public static Object invokeMethodFromArgs(Object clazzOrInstance, Method m, List<?> args) throws IllegalAccessException, InvocationTargetException {
        return Reflections.invokeMethodFromArgs(clazzOrInstance, m, args, false);
    }

    public static Object invokeMethodFromArgs(Object clazzOrInstance, Method m, List<?> args, boolean setAccessible) throws IllegalAccessException, InvocationTargetException {
        return Reflections.invokeMethodFromArgs(clazzOrInstance, m, args, setAccessible, (Optional<? extends TypeCoercer>)Optional.absent());
    }

    public static Object invokeMethodFromArgs(Object clazzOrInstance, Method m, List<?> args, boolean setAccessible, Optional<? extends TypeCoercer> coercer) throws IllegalAccessException, InvocationTargetException {
        Object[] newArgsArray;
        Preconditions.checkNotNull((Object)clazzOrInstance, (Object)"clazz or instance");
        Preconditions.checkNotNull((Object)m, (Object)"method");
        Preconditions.checkNotNull(args, (Object)("args to " + m));
        Object instance = clazzOrInstance instanceof Class ? null : clazzOrInstance;
        Object[] argsArray = args.toArray();
        Class<?>[] parameterTypes = m.getParameterTypes();
        if (m.isVarArgs()) {
            Class<?> varargType = parameterTypes[parameterTypes.length - 1].getComponentType();
            Object varargs = Array.newInstance(varargType, argsArray.length + 1 - parameterTypes.length);
            for (int i = parameterTypes.length - 1; i < argsArray.length; ++i) {
                Object arg = coercer.isPresent() ? ((TypeCoercer)coercer.get()).coerce(argsArray[i], varargType) : argsArray[i];
                Boxing.setInArray(varargs, i + 1 - parameterTypes.length, arg, varargType);
            }
            Object[] newArgsArray2 = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length - 1; ++i) {
                Object arg;
                newArgsArray2[i] = arg = coercer.isPresent() ? ((TypeCoercer)coercer.get()).coerce(argsArray[i], parameterTypes[i]) : argsArray[i];
            }
            newArgsArray2[parameterTypes.length - 1] = varargs;
            if (setAccessible) {
                m.setAccessible(true);
            }
            return m.invoke(instance, newArgsArray2);
        }
        if (coercer.isPresent()) {
            newArgsArray = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                Object arg = ((TypeCoercer)coercer.get()).coerce(argsArray[i], parameterTypes[i]);
                newArgsArray[i] = arg;
            }
        } else {
            newArgsArray = argsArray;
        }
        if (setAccessible) {
            m.setAccessible(true);
        }
        return m.invoke(instance, newArgsArray);
    }

    public static boolean typesMatch(Object[] argsArray, Class<?>[] parameterTypes) {
        return Reflections.typesMatch(argsArray, parameterTypes, (Optional<? extends TypeCoercer>)Optional.absent());
    }

    public static boolean typesMatch(Object[] argsArray, Class<?>[] parameterTypes, Optional<? extends TypeCoercer> coercer) {
        if (argsArray.length != parameterTypes.length) {
            return false;
        }
        return Reflections.typesMatchUpTo(argsArray, parameterTypes, argsArray.length, coercer);
    }

    public static boolean typesMatchUpTo(Object[] argsArray, Class<?>[] parameterTypes, int lengthRequired) {
        return Reflections.typesMatchUpTo(argsArray, parameterTypes, lengthRequired, (Optional<? extends TypeCoercer>)Optional.absent());
    }

    public static boolean typesMatchUpTo(Object[] argsArray, Class<?>[] parameterTypes, int lengthRequired, Optional<? extends TypeCoercer> coercer) {
        if (argsArray.length < lengthRequired || parameterTypes.length < lengthRequired) {
            return false;
        }
        for (int i = 0; i < lengthRequired; ++i) {
            if (Reflections.typeMatches(argsArray[i], parameterTypes[i], coercer)) continue;
            return false;
        }
        return true;
    }

    public static boolean typeMatches(Object arg, Class<?> parameterType, Optional<? extends TypeCoercer> coercer) {
        if (parameterType.isPrimitive() && arg == null) {
            return false;
        }
        if (arg == null) {
            return true;
        }
        if (Boxing.boxedType(parameterType).isInstance(arg)) {
            return true;
        }
        return coercer.isPresent() && ((TypeCoercer)coercer.get()).tryCoerce(arg, parameterType).isPresent();
    }

    public static List<Class<?>> getAllInterfaces(@Nullable Class<?> type) {
        LinkedHashSet found = Sets.newLinkedHashSet();
        Reflections.findAllInterfaces(type, found);
        return ImmutableList.copyOf((Collection)found);
    }

    private static void findAllInterfaces(@Nullable Class<?> type, Set<Class<?>> found) {
        if (type == null) {
            return;
        }
        for (Class<?> i : type.getInterfaces()) {
            if (!found.add(i)) continue;
            Reflections.findAllInterfaces(i, found);
        }
        Reflections.findAllInterfaces(type.getSuperclass(), found);
    }

    public static boolean hasNoArgConstructor(Class<?> clazz) {
        try {
            clazz.getConstructor(new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static boolean hasNoNonObjectFields(Class<? extends Object> clazz) {
        if (Object.class.equals(clazz)) {
            return true;
        }
        if (clazz.getDeclaredFields().length > 0) {
            return false;
        }
        return Reflections.hasNoNonObjectFields(clazz.getSuperclass());
    }

    @Deprecated
    public static Optional<String> tryFindMappedName(Map<String, String> renames, String name) {
        return Reflections.findMappedNameMaybe(renames, name).toOptional();
    }

    public static Maybe<String> findMappedNameMaybe(Map<String, String> renames, String name) {
        String outerClassName;
        if (renames == null) {
            return Maybe.absent("no renames supplied");
        }
        String mappedName = renames.get(name);
        if (mappedName != null) {
            return Maybe.of(mappedName);
        }
        if (name.contains("$") && (mappedName = renames.get(outerClassName = name.substring(0, name.indexOf(36)))) != null) {
            return Maybe.of(mappedName + name.substring(name.indexOf(36)));
        }
        return Maybe.absent("mapped name not present");
    }

    public static String findMappedNameAndLog(Map<String, String> renames, String name) {
        Maybe<String> rename = Reflections.findMappedNameMaybe(renames, name);
        if (rename.isPresent()) {
            LOG.debug("Mapping class '" + name + "' to '" + rename.get() + "'");
            return rename.get();
        }
        return name;
    }

    public static boolean hasSpecialSerializationMethods(Class<? extends Object> type) {
        if (type == null) {
            return false;
        }
        if (Reflections.findMethodMaybe(type, "writeObject", ObjectOutputStream.class).isPresent()) {
            return true;
        }
        return Reflections.hasSpecialSerializationMethods(type.getSuperclass());
    }

    public static List<?> arrayToList(Object input) {
        ArrayList<Object> result = new ArrayList<Object>();
        int length = Array.getLength(input);
        for (int i = 0; i < length; ++i) {
            result.add(Array.get(input, i));
        }
        return result;
    }

    public static Maybe<Method> findAccessibleMethod(Method method) {
        return MethodAccessibleReflections.findAccessibleMethod(method);
    }

    public static boolean trySetAccessible(Method method) {
        return MethodAccessibleReflections.trySetAccessible(method);
    }

    public static TypeToken<?>[] getGenericParameterTypeTokens(TypeToken<?> t) {
        return TypeTokens.getGenericParameterTypeTokens(t);
    }

    public static class ReflectionAccessException
    extends RuntimeException {
        private static final long serialVersionUID = 6569605861192432009L;

        public ReflectionAccessException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ReflectionNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 9032835250796708037L;

        public ReflectionNotFoundException(String message, Throwable cause) {
            super(message, cause);
        }

        public ReflectionNotFoundException(String message) {
            super(message);
        }
    }
}

