/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class NumberMath<T extends Number> {
    static final BigDecimal DEFAULT_TOLERANCE = new BigDecimal(1.0E-8);
    final T number;
    final Class<T> desiredType;
    final Function<Number, T> handlerForUncastableType;
    final BigDecimal tolerance;

    public NumberMath(T number) {
        this(number, number.getClass(), null);
    }

    public NumberMath(T number, Class<T> desiredType) {
        this(number, desiredType, null);
    }

    public NumberMath(T number, Class<T> desiredType, Function<Number, T> handlerForUncastableType) {
        this(number, desiredType, handlerForUncastableType, null);
    }

    public NumberMath(T number, Class<T> desiredType, Function<Number, T> handlerForUncastableType, BigDecimal tolerance) {
        this.number = number;
        this.desiredType = desiredType;
        this.handlerForUncastableType = handlerForUncastableType == null ? x -> {
            throw new IllegalArgumentException("Cannot cast " + x + " to " + number.getClass());
        } : handlerForUncastableType;
        this.tolerance = tolerance == null ? DEFAULT_TOLERANCE : null;
    }

    public BigDecimal asBigDecimal() {
        return NumberMath.asBigDecimal(this.number);
    }

    public Optional<BigInteger> asBigIntegerWithinTolerance() {
        return this.asBigIntegerWithinTolerance((Number)this.number);
    }

    public <T extends Number> T asTypeForced(Class<T> desiredType) {
        return (T)NumberMath.asTypeFirstMatching(this.number, desiredType, y -> this.withinTolerance((Number)y));
    }

    public <T extends Number> Optional<T> asTypeWithinTolerance(Class<T> desiredType, Number tolerance) {
        return Optional.ofNullable(NumberMath.asTypeFirstMatching(this.number, desiredType, y -> NumberMath.withinTolerance(this.number, y, tolerance)));
    }

    public static boolean isPrimitiveWholeNumberType(Number number) {
        return number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte;
    }

    public static boolean isPrimitiveFloatingPointType(Number number) {
        return number instanceof Double || number instanceof Float;
    }

    public static boolean isPrimitiveNumberType(Number number) {
        return NumberMath.isPrimitiveFloatingPointType(number) || NumberMath.isPrimitiveWholeNumberType(number);
    }

    public static BigDecimal asBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (NumberMath.isPrimitiveFloatingPointType(number)) {
            return new BigDecimal(number.doubleValue());
        }
        if (NumberMath.isPrimitiveWholeNumberType(number)) {
            return new BigDecimal(number.longValue());
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return new BigDecimal("" + number);
    }

    public Optional<BigInteger> asBigIntegerWithinTolerance(Number number) {
        BigInteger candidate = NumberMath.asBigIntegerForced(number);
        if (this.withinTolerance(candidate)) {
            return Optional.of(candidate);
        }
        return Optional.empty();
    }

    public static BigInteger asBigIntegerForced(Number number) {
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (NumberMath.isPrimitiveWholeNumberType(number)) {
            return BigInteger.valueOf(number.longValue());
        }
        return NumberMath.asBigDecimal(number).toBigInteger();
    }

    public static <T extends Number> T asTypeForced(Number x, Class<T> desiredType) {
        return (T)NumberMath.asTypeFirstMatching(x, desiredType, y -> NumberMath.withinTolerance(x, y, DEFAULT_TOLERANCE));
    }

    public static <T extends Number> Optional<T> asTypeWithinTolerance(Number x, Class<T> desiredType, Number tolerance) {
        return Optional.ofNullable(NumberMath.asTypeFirstMatching(x, desiredType, y -> NumberMath.withinTolerance(x, y, tolerance)));
    }

    protected static <T extends Number> T asTypeFirstMatching(Number x, Class<T> desiredType, Predicate<T> check) {
        Number candidate;
        if (desiredType.isAssignableFrom(Integer.class)) {
            candidate = x.intValue();
            if (check != null && check.test(candidate)) {
                return (T)candidate;
            }
        }
        if (desiredType.isAssignableFrom(Long.class)) {
            candidate = x.longValue();
            if (check != null && check.test(candidate)) {
                return (T)candidate;
            }
        }
        if (desiredType.isAssignableFrom(Double.class)) {
            candidate = x.doubleValue();
            if (check != null && check.test(candidate)) {
                return (T)candidate;
            }
        }
        if (desiredType.isAssignableFrom(Float.class)) {
            candidate = Float.valueOf(x.floatValue());
            if (check != null && check.test(candidate)) {
                return (T)candidate;
            }
        }
        if (desiredType.isAssignableFrom(Short.class)) {
            candidate = x.shortValue();
            if (check != null && check.test(candidate)) {
                return (T)candidate;
            }
        }
        if (desiredType.isAssignableFrom(Byte.class)) {
            candidate = x.byteValue();
            if (check != null && check.test(candidate)) {
                return (T)candidate;
            }
        }
        if (desiredType.isAssignableFrom(BigInteger.class)) {
            candidate = NumberMath.asBigIntegerForced(x);
            if (check != null && check.test(candidate)) {
                return (T)candidate;
            }
        }
        if (desiredType.isAssignableFrom(BigDecimal.class)) {
            candidate = NumberMath.asBigDecimal(x);
            if (check != null && check.test(candidate)) {
                return (T)candidate;
            }
        }
        return null;
    }

    public boolean withinTolerance(Number b) {
        return NumberMath.withinTolerance(this.number, b, this.tolerance);
    }

    public static boolean withinTolerance(Number a, Number b, Number tolerance) {
        return NumberMath.asBigDecimal(a).subtract(NumberMath.asBigDecimal(b)).abs().compareTo(NumberMath.asBigDecimal(tolerance)) <= 0;
    }

    protected T attemptCast(Number candidate) {
        Optional<T> result = NumberMath.asTypeWithinTolerance(candidate, this.desiredType, this.tolerance);
        if (result.isPresent()) {
            return (T)((Number)result.get());
        }
        return (T)((Number)this.handlerForUncastableType.apply(candidate));
    }

    protected T attemptUnary(Function<Long, Long> intFn, Function<Double, Double> doubleFn, Function<BigInteger, BigInteger> bigIntegerFn, Function<BigDecimal, BigDecimal> bigDecimalFn) {
        if (NumberMath.isPrimitiveWholeNumberType(this.number)) {
            return this.attemptCast(intFn.apply(((Number)this.number).longValue()));
        }
        if (NumberMath.isPrimitiveNumberType(this.number)) {
            return this.attemptCast(doubleFn.apply(((Number)this.number).doubleValue()));
        }
        if (this.number instanceof BigInteger) {
            return this.attemptCast(bigIntegerFn.apply((BigInteger)this.number));
        }
        if (this.number instanceof BigDecimal) {
            return this.attemptCast(bigDecimalFn.apply((BigDecimal)this.number));
        }
        return this.attemptCast(bigDecimalFn.apply(this.asBigDecimal()));
    }

    protected T attemptBinary(T rhs, @Nullable BiFunction<Long, Long, Long> intFn, BiFunction<Double, Double, Double> doubleFn, @Nullable BiFunction<BigInteger, BigInteger, BigInteger> bigIntegerFn, BiFunction<BigDecimal, BigDecimal, BigDecimal> bigDecimalFn) {
        BigInteger rhsI;
        if (NumberMath.isPrimitiveWholeNumberType(this.number) && NumberMath.isPrimitiveWholeNumberType(rhs) && intFn != null) {
            return this.attemptCast(intFn.apply(((Number)this.number).longValue(), ((Number)rhs).longValue()));
        }
        if (NumberMath.isPrimitiveNumberType(this.number) && NumberMath.isPrimitiveNumberType(rhs)) {
            return this.attemptCast(doubleFn.apply(((Number)this.number).doubleValue(), ((Number)rhs).doubleValue()));
        }
        if (this.number instanceof BigInteger && bigIntegerFn != null && (rhsI = (BigInteger)this.asBigIntegerWithinTolerance((Number)rhs).orElse(null)) != null) {
            return this.attemptCast(bigIntegerFn.apply((BigInteger)this.number, rhsI));
        }
        if (this.number instanceof BigDecimal) {
            return this.attemptCast(bigDecimalFn.apply((BigDecimal)this.number, NumberMath.asBigDecimal(rhs)));
        }
        return this.attemptCast(bigDecimalFn.apply(this.asBigDecimal(), NumberMath.asBigDecimal(rhs)));
    }

    protected T attemptBinaryWithDecimalPrecision(T rhs, BiFunction<Double, Double, Double> doubleFn, BiFunction<BigDecimal, BigDecimal, BigDecimal> bigDecimalFn) {
        return this.attemptBinary(rhs, null, doubleFn, null, bigDecimalFn);
    }

    public static <T extends Number> T pairwise(BiFunction<NumberMath<T>, T, T> fn, T ... rhsAll) {
        Object result = rhsAll[0];
        for (T rhs : rhsAll) {
            result = (Number)fn.apply((NumberMath<NumberMath<T>>)new NumberMath<T>(result), (NumberMath<T>)rhs);
        }
        return result;
    }

    public T abs() {
        return this.attemptUnary(x -> x < 0L ? -x.longValue() : x, x -> x < 0.0 ? -x.doubleValue() : x, BigInteger::abs, BigDecimal::abs);
    }

    public T negate() {
        return this.attemptUnary(x -> -x.longValue(), x -> -x.doubleValue(), BigInteger::negate, BigDecimal::negate);
    }

    public T add(T rhs) {
        return this.attemptBinary(rhs, (x, y) -> x + y, (x, y) -> x + y, BigInteger::add, BigDecimal::add);
    }

    public T subtract(T rhs) {
        return this.attemptBinary(rhs, (x, y) -> x - y, (x, y) -> x - y, BigInteger::subtract, BigDecimal::subtract);
    }

    public T multiply(T rhs) {
        return this.attemptBinary(rhs, (x, y) -> x * y, (x, y) -> x * y, BigInteger::multiply, BigDecimal::multiply);
    }

    public T divide(T rhs) {
        return this.attemptBinaryWithDecimalPrecision(rhs, (x, y) -> x / y, BigDecimal::divide);
    }

    public T max(T rhs) {
        return this.attemptBinary(rhs, (x, y) -> x > y ? x : y, (x, y) -> x > y ? x : y, BigInteger::max, BigDecimal::max);
    }

    public T min(T rhs) {
        return this.attemptBinary(rhs, (x, y) -> x < y ? x : y, (x, y) -> x < y ? x : y, BigInteger::min, BigDecimal::min);
    }
}

