/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.container.location.kubernetes;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import com.google.common.net.HostAndPort;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.apps.DeploymentStatus;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.container.entity.docker.DockerContainer;
import org.apache.brooklyn.container.entity.kubernetes.KubernetesPod;
import org.apache.brooklyn.container.entity.kubernetes.KubernetesResource;
import org.apache.brooklyn.container.location.kubernetes.ImageChooser;
import org.apache.brooklyn.container.location.kubernetes.KubernetesClientRegistry;
import org.apache.brooklyn.container.location.kubernetes.KubernetesLocationConfig;
import org.apache.brooklyn.container.location.kubernetes.machine.KubernetesEmptyMachineLocation;
import org.apache.brooklyn.container.location.kubernetes.machine.KubernetesMachineLocation;
import org.apache.brooklyn.container.location.kubernetes.machine.KubernetesSshMachineLocation;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.location.access.PortForwardManager;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.network.AbstractOnNetworkEnricher;
import org.apache.brooklyn.core.network.OnPublicNetworkEnricher;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.config.ResolvingConfigBag;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesLocation
extends AbstractLocation
implements MachineProvisioningLocation<KubernetesMachineLocation>,
KubernetesLocationConfig {
    public static final String NODE_PORT = "NodePort";
    public static final String IMMUTABLE_CONTAINER_KEY = "immutable-container";
    public static final String SSHABLE_CONTAINER = "sshable-container";
    public static final String BROOKLYN_ENTITY_ID = "brooklyn.apache.org/entity-id";
    public static final String BROOKLYN_APPLICATION_ID = "brooklyn.apache.org/application-id";
    public static final String KUBERNETES_DOCKERCFG = "kubernetes.io/dockercfg";
    public static final String PHASE_AVAILABLE = "Available";
    public static final String PHASE_TERMINATING = "Terminating";
    public static final String PHASE_ACTIVE = "Active";
    public static final List<String> IMAGE_DESCRIPTION_REGEXES_REQUIRING_INJECTED_LOGIN_CREDS = ImmutableList.of((Object)"brooklyncentral/centos.*", (Object)"brooklyncentral/ubuntu.*");
    public static final String BROOKLYN_ROOT_PASSWORD = "BROOKLYN_ROOT_PASSWORD";
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesLocation.class);
    public static final String ADDRESS_KEY = "address";
    private ConfigBag currentConfig;

    public KubernetesLocation() {
    }

    public KubernetesLocation(Map<?, ?> properties) {
        super(properties);
    }

    public KubernetesClient getClient() {
        if (this.currentConfig != null) {
            return this.getClient(this.currentConfig);
        }
        return this.getClient((Map<?, ?>)MutableMap.of());
    }

    public KubernetesClient getClient(Map<?, ?> flags) {
        ConfigBag conf = flags == null || flags.isEmpty() ? this.config().getBag() : ConfigBag.newInstanceExtending((ConfigBag)this.config().getBag(), flags);
        return this.getClient(conf);
    }

    public KubernetesClient getClient(ConfigBag config) {
        this.currentConfig = config;
        KubernetesClientRegistry registry = (KubernetesClientRegistry)this.getConfig(KUBERNETES_CLIENT_REGISTRY);
        KubernetesClient client = registry.getKubernetesClient(ResolvingConfigBag.newInstanceExtending((ManagementContext)this.getManagementContext(), (ConfigBag)config));
        return client;
    }

    public KubernetesMachineLocation obtain(Map<?, ?> flags) {
        ConfigBag setupRaw = ConfigBag.newInstanceExtending((ConfigBag)this.config().getBag(), flags);
        ConfigBag setup = ResolvingConfigBag.newInstanceExtending((ManagementContext)this.getManagementContext(), (ConfigBag)setupRaw);
        Entity entity = this.validateCallerContext(setup);
        if (this.isKubernetesResource(entity)) {
            return this.createKubernetesResourceLocation(entity, setup);
        }
        return this.createKubernetesContainerLocation(entity, setup);
    }

    public void release(KubernetesMachineLocation machine) {
        Entity entity = this.validateCallerContext(machine);
        if (this.isKubernetesResource(entity)) {
            this.deleteKubernetesResourceLocation(entity);
        } else {
            this.deleteKubernetesContainerLocation(entity, machine);
        }
        this.getPortForwardManager().forgetPortMappings((Location)machine);
        this.removeChild((Location)machine);
    }

    protected void deleteKubernetesContainerLocation(Entity entity, MachineLocation machine) {
        final String namespace = (String)entity.sensors().get(KubernetesPod.KUBERNETES_NAMESPACE);
        String deployment = (String)entity.sensors().get(KubernetesPod.KUBERNETES_DEPLOYMENT);
        final String service = (String)entity.sensors().get(KubernetesPod.KUBERNETES_SERVICE);
        this.undeploy(namespace, deployment);
        try (final KubernetesClient client = this.getClient();){
            ((ServiceResource)((NonNamespaceOperation)client.services().inNamespace(namespace)).withName(service)).delete();
            ExitCondition exitCondition = new ExitCondition(){

                @Override
                public Boolean call() {
                    return ((ServiceResource)((NonNamespaceOperation)client.services().inNamespace(namespace)).withName(service)).get() == null;
                }

                @Override
                public String getFailureMessage() {
                    return "No service with namespace=" + namespace + ", serviceName=" + service;
                }
            };
            this.waitForExitCondition(exitCondition);
            Boolean delete = (Boolean)machine.config().get(DELETE_EMPTY_NAMESPACE);
            if (Boolean.TRUE.equals(delete)) {
                this.deleteEmptyNamespace(namespace);
            }
        }
    }

    protected void deleteKubernetesResourceLocation(Entity entity) {
        String resourceName;
        String namespace = (String)entity.sensors().get(KubernetesPod.KUBERNETES_NAMESPACE);
        String resourceType = (String)entity.sensors().get(KubernetesResource.RESOURCE_TYPE);
        if (this.handleResourceDelete(resourceType, resourceName = (String)entity.sensors().get(KubernetesResource.RESOURCE_NAME), namespace).isEmpty()) {
            LOG.warn("Resource {}: {} not deleted", (Object)resourceName, (Object)resourceType);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<StatusDetails> handleResourceDelete(String resourceType, String resourceName, String namespace) {
        try (KubernetesClient client = this.getClient();){
            switch (resourceType) {
                case "Deployment": {
                    List list = ((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(namespace)).withName(resourceName)).delete();
                    return list;
                }
                case "ReplicaSet": {
                    List list = ((RollableScalableResource)((NonNamespaceOperation)client.apps().replicaSets().inNamespace(namespace)).withName(resourceName)).delete();
                    return list;
                }
                case "ConfigMap": {
                    List list = ((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).withName(resourceName)).delete();
                    return list;
                }
                case "PersistentVolume": {
                    List list = ((Resource)client.persistentVolumes().withName(resourceName)).delete();
                    return list;
                }
                case "Secret": {
                    List list = ((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withName(resourceName)).delete();
                    return list;
                }
                case "Service": {
                    List list = ((ServiceResource)((NonNamespaceOperation)client.services().inNamespace(namespace)).withName(resourceName)).delete();
                    return list;
                }
                case "ReplicationController": {
                    List list = ((RollableScalableResource)((NonNamespaceOperation)client.replicationControllers().inNamespace(namespace)).withName(resourceName)).delete();
                    return list;
                }
                case "Namespace": {
                    List list = ((Resource)client.namespaces().withName(resourceName)).delete();
                    return list;
                }
            }
            return Collections.emptyList();
        }
        catch (KubernetesClientException kce) {
            LOG.warn("Error deleting resource {}: {}", (Object)resourceName, (Object)kce);
        }
        return Collections.emptyList();
    }

    protected void undeploy(final String namespace, final String deployment) {
        try (final KubernetesClient client = this.getClient();){
            ((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(namespace)).withName(deployment)).delete();
            ExitCondition exitCondition = new ExitCondition(){

                @Override
                public Boolean call() {
                    return ((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(namespace)).withName(deployment)).get() == null;
                }

                @Override
                public String getFailureMessage() {
                    return "No deployment with namespace=" + namespace + ", deployment=" + deployment;
                }
            };
            this.waitForExitCondition(exitCondition);
        }
    }

    protected synchronized void deleteEmptyNamespace(final String name) {
        if (!name.equals("default") && this.isNamespaceEmpty(name)) {
            try (final KubernetesClient client = this.getClient();){
                if (((Resource)client.namespaces().withName(name)).get() != null && !((Namespace)((Resource)client.namespaces().withName(name)).get()).getStatus().getPhase().equals(PHASE_TERMINATING)) {
                    ((Resource)client.namespaces().withName(name)).delete();
                    ExitCondition exitCondition = new ExitCondition(){

                        @Override
                        public Boolean call() {
                            return ((Resource)client.namespaces().withName(name)).get() == null;
                        }

                        @Override
                        public String getFailureMessage() {
                            return "Namespace " + name + " still present";
                        }
                    };
                    this.waitForExitCondition(exitCondition);
                }
            }
        }
    }

    protected boolean isNamespaceEmpty(String name) {
        try (KubernetesClient client = this.getClient();){
            boolean bl = ((DeploymentList)((NonNamespaceOperation)client.apps().deployments().inNamespace(name)).list()).getItems().isEmpty() && ((ServiceList)((NonNamespaceOperation)client.services().inNamespace(name)).list()).getItems().isEmpty() && ((SecretList)((NonNamespaceOperation)client.secrets().inNamespace(name)).list()).getItems().isEmpty();
            return bl;
        }
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        return null;
    }

    protected KubernetesMachineLocation createKubernetesResourceLocation(Entity entity, ConfigBag setup) {
        String resourceUri = (String)entity.config().get(KubernetesResource.RESOURCE_FILE);
        InputStream resource = ResourceUtils.create((Object)entity).getResourceFromUrl(resourceUri);
        String templateContents = Streams.readFullyString((InputStream)resource);
        String processedContents = TemplateProcessor.processTemplateContents((String)"k8s location template", (String)templateContents, (EntityInternal)((EntityInternal)entity), (Map)setup.getAllConfig());
        InputStream processedResource = Streams.newInputStreamWithContents((String)processedContents);
        try (KubernetesClient clientUnnamespaced = this.getClient();){
            Namespace namespaceFromConfig = null;
            Boolean shouldCreate = (Boolean)setup.get(CREATE_NAMESPACE);
            try {
                namespaceFromConfig = this.createOrGetNamespace((String)this.lookup(NAMESPACE, entity, setup), shouldCreate);
            }
            catch (Exception e) {
                if (Boolean.TRUE.equals(shouldCreate)) {
                    throw Exceptions.propagate((Throwable)e);
                }
                LOG.debug("Unable to create/get namespace; ignoring, but may fail subsequently: " + e, (Throwable)e);
            }
            final KubernetesClient client = namespaceFromConfig != null ? (KubernetesClient)((DefaultKubernetesClient)clientUnnamespaced).inNamespace(namespaceFromConfig.getMetadata().getName()) : clientUnnamespaced;
            final List result = (List)client.load(processedResource).createOrReplace();
            ExitCondition exitCondition = new ExitCondition(){

                @Override
                public Boolean call() {
                    if (result.isEmpty()) {
                        return false;
                    }
                    HasMetadata check = (HasMetadata)client.resource((HasMetadata)result.get(0)).inNamespace(((HasMetadata)result.get(0)).getMetadata().getNamespace()).get();
                    return check != null;
                }

                @Override
                public String getFailureMessage() {
                    return "Cannot find created resources";
                }
            };
            this.waitForExitCondition(exitCondition);
            HasMetadata metadata = (HasMetadata)result.get(0);
            String resourceType = metadata.getKind();
            String resourceName = metadata.getMetadata().getName();
            String namespace = metadata.getMetadata().getNamespace();
            LOG.debug("Resource {} (type {}) deployed to {}", new Object[]{resourceName, resourceType, namespace});
            entity.sensors().set(KubernetesPod.KUBERNETES_NAMESPACE, (Object)namespace);
            entity.sensors().set(KubernetesResource.RESOURCE_NAME, (Object)resourceName);
            entity.sensors().set(KubernetesResource.RESOURCE_TYPE, (Object)resourceType);
            LocationSpec locationSpec = LocationSpec.create(KubernetesSshMachineLocation.class);
            if (!this.findResourceAddress((LocationSpec<? extends KubernetesMachineLocation>)locationSpec, entity, metadata, resourceType, resourceName, namespace)) {
                LOG.info("Resource {} with type {} has no associated address", (Object)resourceName, (Object)resourceType);
                locationSpec = LocationSpec.create(KubernetesEmptyMachineLocation.class);
            }
            ((LocationSpec)((LocationSpec)((LocationSpec)locationSpec.configure(CALLER_CONTEXT, setup.get(CALLER_CONTEXT))).configure(KubernetesMachineLocation.KUBERNETES_NAMESPACE, (Object)namespace)).configure(KubernetesMachineLocation.KUBERNETES_RESOURCE_NAME, (Object)resourceName)).configure(KubernetesMachineLocation.KUBERNETES_RESOURCE_TYPE, (Object)resourceType);
            KubernetesMachineLocation machine = (KubernetesMachineLocation)this.getManagementContext().getLocationManager().createLocation(locationSpec);
            this.addChild((Location)machine);
            if (resourceType.equals("Service") && machine instanceof KubernetesSshMachineLocation) {
                Service service = this.getService(namespace, resourceName, client);
                this.registerPortMappings((KubernetesSshMachineLocation)machine, entity, service);
            }
            KubernetesMachineLocation kubernetesMachineLocation = machine;
            return kubernetesMachineLocation;
        }
    }

    protected boolean findResourceAddress(LocationSpec<? extends KubernetesMachineLocation> locationSpec, Entity entity, HasMetadata metadata, String resourceType, String resourceName, String namespace) {
        if (resourceType.equals("Deployment") || resourceType.equals("ReplicationController") || resourceType.equals("Pod")) {
            Object labels = MutableMap.of();
            if (resourceType.equals("Deployment")) {
                Deployment deployment = (Deployment)metadata;
                labels = deployment.getSpec().getTemplate().getMetadata().getLabels();
            } else if (resourceType.equals("ReplicationController")) {
                ReplicationController replicationController = (ReplicationController)metadata;
                labels = replicationController.getSpec().getTemplate().getMetadata().getLabels();
            }
            Pod pod = resourceType.equals("Pod") ? this.getPod(namespace, resourceName) : this.getPod(namespace, (Map<String, String>)labels);
            entity.sensors().set(KubernetesPod.KUBERNETES_POD, (Object)pod.getMetadata().getName());
            InetAddress node = Networking.getInetAddressWithFixedName((String)pod.getSpec().getNodeName());
            String podAddress = pod.getStatus().getPodIP();
            locationSpec.configure((CharSequence)ADDRESS_KEY, (Object)node);
            locationSpec.configure(SshMachineLocation.PRIVATE_ADDRESSES, (Object)ImmutableSet.of((Object)podAddress));
            return true;
        }
        if (resourceType.equals("Service")) {
            Endpoints endpoints;
            try (KubernetesClient client = this.getClient();){
                this.getService(namespace, resourceName, client);
                endpoints = (Endpoints)((Resource)((NonNamespaceOperation)client.endpoints().inNamespace(namespace)).withName(resourceName)).get();
            }
            LinkedHashSet privateIps = Sets.newLinkedHashSet();
            LinkedHashSet podNames = Sets.newLinkedHashSet();
            for (EndpointSubset subset : endpoints.getSubsets()) {
                for (EndpointAddress address : subset.getAddresses()) {
                    String podName = address.getTargetRef().getName();
                    podNames.add(podName);
                    String privateIp = address.getIp();
                    privateIps.add(privateIp);
                }
            }
            locationSpec.configure(SshMachineLocation.PRIVATE_ADDRESSES, (Object)ImmutableSet.copyOf((Collection)privateIps));
            if (!podNames.isEmpty()) {
                String podName = (String)Iterables.get((Iterable)podNames, (int)0);
                if (podNames.size() > 1) {
                    LOG.warn("Multiple pods referenced by service {} in namespace {}, using {}: {}", new Object[]{resourceName, namespace, podName, Iterables.toString((Iterable)podNames)});
                }
                try {
                    Pod pod = this.getPod(namespace, podName);
                    entity.sensors().set(KubernetesPod.KUBERNETES_POD, (Object)podName);
                    InetAddress node = Networking.getInetAddressWithFixedName((String)pod.getSpec().getNodeName());
                    locationSpec.configure((CharSequence)ADDRESS_KEY, (Object)node);
                }
                catch (KubernetesClientException kce) {
                    LOG.warn("Cannot find pod {} in namespace {} for service {}", new Object[]{podName, namespace, resourceName});
                }
            }
            return true;
        }
        return false;
    }

    protected KubernetesMachineLocation createKubernetesContainerLocation(Entity entity, ConfigBag setup) {
        String deploymentName = this.lookup(KubernetesPod.DEPLOYMENT, entity, setup, entity.getId());
        Integer replicas = this.lookup(KubernetesPod.REPLICAS, entity, setup);
        List<String> volumes = this.lookup(KubernetesPod.PERSISTENT_VOLUMES, entity, setup);
        Map<String, String> secrets = this.lookup(KubernetesPod.SECRETS, entity, setup);
        Map<String, String> limits = this.lookup(KubernetesPod.LIMITS, entity, setup);
        Boolean privileged = this.lookup(KubernetesPod.PRIVILEGED, entity, setup);
        String imageName = this.findImageName(entity, setup);
        Iterable<Integer> inboundPorts = this.findInboundPorts(entity, setup);
        Map<String, String> env = this.findEnvironmentVariables(entity, setup, imageName);
        Map<String, String> metadata = this.findMetadata(entity, setup, deploymentName);
        if (volumes != null) {
            this.createPersistentVolumes(volumes);
        }
        Namespace namespace = this.createOrGetNamespace((String)this.lookup(NAMESPACE, entity, setup), (Boolean)setup.get(CREATE_NAMESPACE));
        if (secrets != null) {
            this.createSecrets(namespace.getMetadata().getName(), secrets);
        }
        Container container = this.buildContainer(namespace.getMetadata().getName(), metadata, deploymentName, imageName, inboundPorts, env, limits, privileged);
        this.deploy(namespace.getMetadata().getName(), entity, metadata, deploymentName, container, replicas, secrets);
        Service service = this.exposeService(namespace.getMetadata().getName(), metadata, deploymentName, inboundPorts);
        Pod pod = this.getPod(namespace.getMetadata().getName(), metadata);
        entity.sensors().set(KubernetesPod.KUBERNETES_NAMESPACE, (Object)namespace.getMetadata().getName());
        entity.sensors().set(KubernetesPod.KUBERNETES_DEPLOYMENT, (Object)deploymentName);
        entity.sensors().set(KubernetesPod.KUBERNETES_POD, (Object)pod.getMetadata().getName());
        entity.sensors().set(KubernetesPod.KUBERNETES_SERVICE, (Object)service.getMetadata().getName());
        LocationSpec locationSpec = (LocationSpec)((LocationSpec)((LocationSpec)this.prepareSshableLocationSpec(entity, setup, service, pod).configure(KubernetesMachineLocation.KUBERNETES_NAMESPACE, (Object)namespace.getMetadata().getName())).configure(KubernetesMachineLocation.KUBERNETES_RESOURCE_NAME, (Object)deploymentName)).configure(KubernetesMachineLocation.KUBERNETES_RESOURCE_TYPE, (Object)this.getContainerResourceType());
        KubernetesSshMachineLocation machine = (KubernetesSshMachineLocation)this.getManagementContext().getLocationManager().createLocation(locationSpec);
        this.addChild((Location)machine);
        this.registerPortMappings(machine, entity, service);
        if (!this.isDockerContainer(entity)) {
            this.waitForSshable(machine, Duration.FIVE_MINUTES);
        }
        return machine;
    }

    protected String getContainerResourceType() {
        return "Deployment";
    }

    protected void waitForSshable(SshMachineLocation machine, Duration timeout) {
        Callable<Boolean> checker = () -> {
            int exitstatus = machine.execScript((Map)ImmutableMap.of((Object)SshTool.PROP_CONNECT_TIMEOUT.getName(), (Object)Duration.TEN_SECONDS.toMilliseconds(), (Object)SshTool.PROP_SESSION_TIMEOUT.getName(), (Object)Duration.TEN_SECONDS.toMilliseconds(), (Object)SshTool.PROP_SSH_TRIES_TIMEOUT.getName(), (Object)Duration.TEN_SECONDS.toMilliseconds(), (Object)SshTool.PROP_SSH_TRIES.getName(), (Object)1), "check-sshable", (List)ImmutableList.of((Object)"true"));
            return exitstatus == 0;
        };
        Stopwatch stopwatch = Stopwatch.createStarted();
        ReferenceWithError reachable = Repeater.create((String)"reachable").threaded().backoff(Duration.FIVE_SECONDS, 2.0, Duration.TEN_SECONDS).until(checker).limitTimeTo(timeout).runKeepingError();
        if (!((Boolean)reachable.getWithoutError()).booleanValue()) {
            throw new IllegalStateException("Connection failed for " + machine.getSshHostAndPort() + " after waiting " + stopwatch.elapsed(TimeUnit.SECONDS), reachable.getError());
        }
        LOG.debug("Connection succeeded for {} after {}", (Object)machine.getSshHostAndPort(), (Object)stopwatch.elapsed(TimeUnit.SECONDS));
    }

    protected void registerPortMappings(KubernetesSshMachineLocation machine, Entity entity, Service service) {
        PortForwardManager portForwardManager = this.getPortForwardManager();
        List ports = service.getSpec().getPorts();
        String publicHostText = machine.getSshHostAndPort().getHost();
        LOG.debug("Recording port-mappings for container {} of {}: {}", new Object[]{machine, this, ports});
        for (ServicePort port : ports) {
            String protocol = port.getProtocol();
            Integer targetPort = port.getTargetPort().getIntVal();
            if (!"TCP".equalsIgnoreCase(protocol)) {
                LOG.debug("Ignoring port mapping {} for {} because only TCP is currently supported", (Object)port, (Object)machine);
                continue;
            }
            if (targetPort == null) {
                LOG.debug("Ignoring port mapping {} for {} because targetPort.intValue is null", (Object)port, (Object)machine);
                continue;
            }
            if (port.getNodePort() == null) {
                LOG.debug("Ignoring port mapping {} to {} because port.getNodePort() is null", (Object)targetPort, (Object)machine);
                continue;
            }
            portForwardManager.associate(publicHostText, HostAndPort.fromParts((String)publicHostText, (int)port.getNodePort()), (Location)machine, targetPort.intValue());
            AttributeSensor sensor = Sensors.newIntegerSensor((String)("kubernetes." + (String)Strings.maybeNonBlank((CharSequence)port.getName()).or((Object)targetPort.toString()) + ".port"));
            entity.sensors().set(sensor, (Object)targetPort);
        }
        entity.enrichers().add((EnricherSpec)EnricherSpec.create(OnPublicNetworkEnricher.class).configure(AbstractOnNetworkEnricher.MAP_MATCHING, (Object)"kubernetes.[a-zA-Z0-9][a-zA-Z0-9-_]*.port"));
    }

    private PortForwardManager getPortForwardManager() {
        return (PortForwardManager)this.getManagementContext().getLocationRegistry().getLocationManaged("portForwardManager(scope=global)");
    }

    protected synchronized Namespace createOrGetNamespace(final String name, Boolean create) {
        try (final KubernetesClient client = this.getClient();){
            Namespace namespace = (Namespace)((Resource)client.namespaces().withName(name)).get();
            ExitCondition namespaceReady = new ExitCondition(){

                @Override
                public Boolean call() {
                    Namespace actualNamespace = (Namespace)((Resource)client.namespaces().withName(name)).get();
                    return actualNamespace != null && actualNamespace.getStatus().getPhase().equals(KubernetesLocation.PHASE_ACTIVE);
                }

                @Override
                public String getFailureMessage() {
                    Namespace actualNamespace = (Namespace)((Resource)client.namespaces().withName(name)).get();
                    return "Namespace for " + name + " " + (actualNamespace == null ? "absent" : " status " + actualNamespace.getStatus());
                }
            };
            if (namespace != null) {
                LOG.debug("Found namespace {}, returning it.", (Object)namespace);
            } else if (create.booleanValue()) {
                namespace = (Namespace)client.namespaces().create((Object)((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(name)).addToLabels("name", name)).endMetadata()).build());
                LOG.debug("Created namespace {}.", (Object)namespace);
            } else {
                throw new IllegalStateException("Namespace " + name + " does not exist and namespace.create is not set");
            }
            this.waitForExitCondition(namespaceReady);
            Namespace namespace2 = (Namespace)((Resource)client.namespaces().withName(name)).get();
            return namespace2;
        }
    }

    protected Pod getPod(final String namespace, final String name) {
        try (final KubernetesClient client = this.getClient();){
            ExitCondition exitCondition = new ExitCondition(){

                @Override
                public Boolean call() {
                    Pod result = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(name)).get();
                    return result != null && result.getStatus().getPodIP() != null;
                }

                @Override
                public String getFailureMessage() {
                    return "Cannot find pod with name: " + name;
                }
            };
            this.waitForExitCondition(exitCondition);
            Pod pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(name)).get();
            return pod;
        }
    }

    protected Pod getPod(final String namespace, final Map<String, String> metadata) {
        try (final KubernetesClient client = this.getClient();){
            ExitCondition exitCondition = new ExitCondition(){

                @Override
                public Boolean call() {
                    PodList result = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withLabels(metadata)).list();
                    return !result.getItems().isEmpty() && ((Pod)result.getItems().get(0)).getStatus().getPodIP() != null;
                }

                @Override
                public String getFailureMessage() {
                    return "Cannot find pod with metadata: " + Joiner.on((String)" ").withKeyValueSeparator("=").join(metadata);
                }
            };
            this.waitForExitCondition(exitCondition);
            PodList result = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withLabels(metadata)).list();
            Pod pod = (Pod)result.getItems().get(0);
            return pod;
        }
    }

    protected void createSecrets(String namespace, Map<String, String> secrets) {
        for (Map.Entry<String, String> nameAuthEntry : secrets.entrySet()) {
            this.createSecret(namespace, nameAuthEntry.getKey(), nameAuthEntry.getValue());
        }
    }

    protected Secret createSecret(final String namespace, final String secretName, String auth) {
        try (final KubernetesClient client = this.getClient();){
            block18: {
                Secret secret = (Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withName(secretName)).get();
                if (secret != null) {
                    Secret secret2 = secret;
                    return secret2;
                }
                String json = String.format("{\"https://index.docker.io/v1/\":{\"auth\":\"%s\"}}", auth);
                String base64encoded = BaseEncoding.base64().encode(json.getBytes(Charset.defaultCharset()));
                secret = ((SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(secretName)).endMetadata()).withType(KUBERNETES_DOCKERCFG)).withData((Map)ImmutableMap.of((Object)".dockercfg", (Object)base64encoded))).build();
                try {
                    ((NonNamespaceOperation)client.secrets().inNamespace(namespace)).create((Object)secret);
                }
                catch (KubernetesClientException e) {
                    if (e.getCode() == 500 && e.getMessage().contains("Message: resourceVersion may not be set on objects to be created")) break block18;
                    throw Throwables.propagate((Throwable)e);
                }
            }
            ExitCondition exitCondition = new ExitCondition(){

                @Override
                public Boolean call() {
                    return ((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withName(secretName)).get() != null;
                }

                @Override
                public String getFailureMessage() {
                    return "Absent namespace=" + namespace + ", secretName=" + secretName;
                }
            };
            this.waitForExitCondition(exitCondition);
            Secret secret = (Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withName(secretName)).get();
            return secret;
        }
    }

    protected Container buildContainer(String namespace, Map<String, String> metadata, String deploymentName, String imageName, Iterable<Integer> inboundPorts, Map<String, ?> env, Map<String, String> limits, boolean privileged) {
        ArrayList containerPorts = Lists.newArrayList();
        inboundPorts.forEach(inboundPort -> containerPorts.add(((ContainerPortBuilder)new ContainerPortBuilder().withContainerPort(inboundPort)).build()));
        ArrayList envVars = Lists.newArrayList();
        env.forEach((key, value) -> envVars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(key)).withValue(value.toString())).build()));
        ContainerBuilder containerBuilder = (ContainerBuilder)((ContainerFluent.SecurityContextNested)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(deploymentName)).withImage(imageName)).addToPorts((ContainerPort[])Iterables.toArray((Iterable)containerPorts, ContainerPort.class))).addToEnv((EnvVar[])Iterables.toArray((Iterable)envVars, EnvVar.class))).withNewSecurityContext().withPrivileged(Boolean.valueOf(privileged))).endSecurityContext();
        if (limits != null) {
            for (Map.Entry<String, String> nameValueEntry : limits.entrySet()) {
                ResourceRequirements resourceRequirements = ((ResourceRequirementsBuilder)new ResourceRequirementsBuilder().addToLimits(nameValueEntry.getKey(), ((QuantityBuilder)new QuantityBuilder().withAmount(nameValueEntry.getValue())).build())).build();
                containerBuilder.withResources(resourceRequirements);
            }
        }
        LOG.debug("Built container {} to be deployed in namespace {} with metadata {}.", new Object[]{containerBuilder.build(), namespace, metadata});
        return containerBuilder.build();
    }

    protected void deploy(final String namespace, Entity entity, Map<String, String> metadata, final String deploymentName, Container container, Integer replicas, Map<String, String> secrets) {
        PodTemplateSpecBuilder podTemplateSpecBuilder = (PodTemplateSpecBuilder)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecBuilder)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)new PodTemplateSpecBuilder().withNewMetadata().addToLabels("name", deploymentName)).addToLabels(metadata)).endMetadata()).withNewSpec().addToContainers(new Container[]{container})).endSpec();
        if (secrets != null) {
            for (String secretName : secrets.keySet()) {
                ((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)podTemplateSpecBuilder.withNewSpec().addToContainers(new Container[]{container})).addNewImagePullSecret(secretName)).endSpec();
            }
        }
        PodTemplateSpec template = podTemplateSpecBuilder.build();
        LabelSelectorBuilder labelSelectorBuilder = new LabelSelectorBuilder();
        labelSelectorBuilder.addToMatchLabels(metadata);
        LabelSelector labelSelector = labelSelectorBuilder.build();
        Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(deploymentName)).addToAnnotations(BROOKLYN_ENTITY_ID, entity.getId())).addToAnnotations(BROOKLYN_APPLICATION_ID, entity.getApplicationId())).endMetadata()).withNewSpec().withSelector(labelSelector)).withReplicas(replicas)).withTemplate(template)).endSpec()).build();
        try (final KubernetesClient client = this.getClient();){
            ((NonNamespaceOperation)client.apps().deployments().inNamespace(namespace)).create((Object)deployment);
            ExitCondition exitCondition = new ExitCondition(){

                @Override
                public Boolean call() {
                    Deployment dep = (Deployment)((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).get();
                    DeploymentStatus status = dep == null ? null : dep.getStatus();
                    Integer replicas = status == null ? null : status.getAvailableReplicas();
                    return replicas != null;
                }

                @Override
                public String getFailureMessage() {
                    Deployment dep = (Deployment)((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).get();
                    DeploymentStatus status = dep == null ? null : dep.getStatus();
                    return "Namespace=" + namespace + "; deploymentName= " + deploymentName + "; Deployment=" + dep + "; status=" + status + "; availableReplicas=" + (status == null ? "null" : status.getAvailableReplicas());
                }
            };
            this.waitForExitCondition(exitCondition);
        }
        LOG.debug("Deployed deployment {} in namespace {}.", (Object)deployment, (Object)namespace);
    }

    protected Service exposeService(String namespace, Map<String, String> metadata, String serviceName, Iterable<Integer> inboundPorts) {
        ArrayList servicePorts = Lists.newArrayList();
        for (Integer inboundPort : inboundPorts) {
            servicePorts.add(((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName(Integer.toString(inboundPort))).withPort(inboundPort)).build());
        }
        Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(serviceName)).endMetadata()).withNewSpec().addToSelector(metadata)).addToPorts((ServicePort[])Iterables.toArray((Iterable)servicePorts, ServicePort.class))).withType(NODE_PORT)).endSpec()).build();
        try (KubernetesClient client = this.getClient();){
            ((NonNamespaceOperation)client.services().inNamespace(namespace)).create((Object)service);
            service = this.getService(namespace, serviceName, client);
            LOG.debug("Exposed service {} in namespace {}.", (Object)service, (Object)namespace);
            Service service2 = service;
            return service2;
        }
    }

    protected Service getService(final String namespace, final String serviceName, final KubernetesClient client) {
        ExitCondition exitCondition = new ExitCondition(){

            @Override
            public Boolean call() {
                Service svc = (Service)((ServiceResource)((NonNamespaceOperation)client.services().inNamespace(namespace)).withName(serviceName)).get();
                if (svc == null || svc.getStatus() == null) {
                    return false;
                }
                Endpoints endpoints = (Endpoints)((Resource)((NonNamespaceOperation)client.endpoints().inNamespace(namespace)).withName(serviceName)).get();
                if (endpoints == null || endpoints.getSubsets().isEmpty()) {
                    return false;
                }
                for (EndpointSubset subset : endpoints.getSubsets()) {
                    if (subset.getNotReadyAddresses().isEmpty()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String getFailureMessage() {
                Endpoints endpoints = (Endpoints)((Resource)((NonNamespaceOperation)client.endpoints().inNamespace(namespace)).withName(serviceName)).get();
                return "Service endpoints in " + namespace + " for serviceName= " + serviceName + " not ready: " + endpoints;
            }
        };
        this.waitForExitCondition(exitCondition);
        return (Service)((ServiceResource)((NonNamespaceOperation)client.services().inNamespace(namespace)).withName(serviceName)).get();
    }

    protected LocationSpec<KubernetesSshMachineLocation> prepareSshableLocationSpec(Entity entity, ConfigBag setup, Service service, Pod pod) {
        InetAddress node = Networking.getInetAddressWithFixedName((String)pod.getSpec().getNodeName());
        String podAddress = pod.getStatus().getPodIP();
        LocationSpec locationSpec = (LocationSpec)((LocationSpec)((LocationSpec)LocationSpec.create(KubernetesSshMachineLocation.class).configure((CharSequence)ADDRESS_KEY, (Object)node)).configure(SshMachineLocation.PRIVATE_ADDRESSES, (Object)ImmutableSet.of((Object)podAddress))).configure(CALLER_CONTEXT, setup.get(CALLER_CONTEXT));
        if (!this.isDockerContainer(entity)) {
            Optional sshPortNumber;
            Optional sshPort = Iterables.tryFind((Iterable)service.getSpec().getPorts(), input -> "TCP".equalsIgnoreCase(input.getProtocol()) && input.getPort() == 22);
            if (sshPort.isPresent()) {
                sshPortNumber = Optional.of((Object)((ServicePort)sshPort.get()).getNodePort());
            } else {
                LOG.warn("No port-mapping found to ssh port 22, for container {}", (Object)service);
                sshPortNumber = Optional.absent();
            }
            ((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)locationSpec.configure(CloudLocationConfig.USER, setup.get(KubernetesLocationConfig.LOGIN_USER))).configure(SshMachineLocation.PASSWORD, setup.get(KubernetesLocationConfig.LOGIN_USER_PASSWORD))).configureIfNotNull(SshMachineLocation.SSH_PORT, sshPortNumber.orNull())).configure(BrooklynConfigKeys.SKIP_ON_BOX_BASE_DIR_RESOLUTION, (Object)true)).configure(BrooklynConfigKeys.ONBOX_BASE_DIR, (Object)"/tmp");
        }
        return locationSpec;
    }

    protected void createPersistentVolumes(List<String> volumes) {
        for (final String persistentVolume : volumes) {
            PersistentVolume volume = ((PersistentVolumeBuilder)((PersistentVolumeFluent.SpecNested)((PersistentVolumeSpecFluent.HostPathNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeBuilder)((PersistentVolumeFluent.MetadataNested)((PersistentVolumeFluent.MetadataNested)new PersistentVolumeBuilder().withNewMetadata().withName(persistentVolume)).withLabels((Map)ImmutableMap.of((Object)"type", (Object)"local"))).endMetadata()).withNewSpec().addToCapacity("storage", ((QuantityBuilder)new QuantityBuilder().withAmount("20")).build())).addToAccessModes(new String[]{"ReadWriteOnce"})).withNewHostPath().withPath("/tmp/pv-1")).endHostPath()).endSpec()).build();
            final KubernetesClient client = this.getClient();
            Throwable throwable = null;
            try {
                client.persistentVolumes().create((Object)volume);
                ExitCondition exitCondition = new ExitCondition(){

                    @Override
                    public Boolean call() {
                        PersistentVolume pv = (PersistentVolume)((Resource)client.persistentVolumes().withName(persistentVolume)).get();
                        return pv != null && pv.getStatus() != null && pv.getStatus().getPhase().equals(KubernetesLocation.PHASE_AVAILABLE);
                    }

                    @Override
                    public String getFailureMessage() {
                        PersistentVolume pv = (PersistentVolume)((Resource)client.persistentVolumes().withName(persistentVolume)).get();
                        return "PersistentVolume for " + persistentVolume + " " + (pv == null ? "absent" : "pv=" + pv);
                    }
                };
                this.waitForExitCondition(exitCondition);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (client == null) continue;
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                client.close();
            }
        }
    }

    protected Entity validateCallerContext(ConfigBag setup) {
        Object callerContext = setup.get(LocationConfigKeys.CALLER_CONTEXT);
        if (callerContext instanceof Entity) {
            return (Entity)callerContext;
        }
        throw new IllegalStateException("Invalid caller context: " + callerContext);
    }

    protected Entity validateCallerContext(MachineLocation machine) {
        Object callerContext = machine.config().get(LocationConfigKeys.CALLER_CONTEXT);
        if (callerContext instanceof Entity) {
            return (Entity)callerContext;
        }
        throw new IllegalStateException("Invalid caller context: " + callerContext);
    }

    protected Map<String, String> findMetadata(Entity entity, ConfigBag setup, String value) {
        LinkedHashMap podMetadata = Maps.newLinkedHashMap();
        podMetadata.put(this.isDockerContainer(entity) ? IMMUTABLE_CONTAINER_KEY : SSHABLE_CONTAINER, value);
        MutableMap metadata = MutableMap.builder().putAll((Map)MutableMap.copyOf((Map)((Map)setup.get(KubernetesPod.METADATA)))).putAll((Map)MutableMap.copyOf((Map)((Map)entity.config().get(KubernetesPod.METADATA)))).putAll((Map)podMetadata).build();
        return Maps.transformValues((Map)metadata, (Function)Functions.toStringFunction());
    }

    protected Map<String, String> findEnvironmentVariables(Entity entity, ConfigBag setup, String imageName) {
        String loginUser = (String)setup.get(LOGIN_USER);
        String loginPassword = (String)setup.get(LOGIN_USER_PASSWORD);
        LinkedHashMap injections = Maps.newLinkedHashMap();
        Boolean injectLoginCredentials = (Boolean)setup.get(INJECT_LOGIN_CREDENTIAL);
        if (injectLoginCredentials == null) {
            for (String regex : IMAGE_DESCRIPTION_REGEXES_REQUIRING_INJECTED_LOGIN_CREDS) {
                if (imageName == null || !imageName.matches(regex)) continue;
                injectLoginCredentials = true;
                break;
            }
        }
        if (Boolean.TRUE.equals(injectLoginCredentials) && (Strings.isBlank((CharSequence)loginUser) || "root".equals(loginUser))) {
            loginUser = "root";
            setup.configure(LOGIN_USER, (Object)loginUser);
            if (Strings.isBlank((CharSequence)loginPassword)) {
                loginPassword = Identifiers.makeRandomPassword((int)12);
                setup.configure(LOGIN_USER_PASSWORD, (Object)loginPassword);
            }
            injections.put(BROOKLYN_ROOT_PASSWORD, loginPassword);
        }
        MutableMap rawEnv = MutableMap.builder().putAll((Map)MutableMap.copyOf((Map)((Map)setup.get(ENV)))).putAll((Map)MutableMap.copyOf((Map)((Map)entity.config().get(DockerContainer.CONTAINER_ENVIRONMENT)))).putAll((Map)injections).build();
        return Maps.transformValues((Map)rawEnv, (Function)Functions.toStringFunction());
    }

    protected Iterable<Integer> findInboundPorts(Entity entity, ConfigBag setup) {
        Iterable inboundTcpPorts = (Iterable)entity.config().get(DockerContainer.INBOUND_TCP_PORTS);
        if (inboundTcpPorts == null) {
            return setup.containsKey(INBOUND_PORTS) ? this.toIntPortList(setup.get(INBOUND_PORTS)) : ImmutableList.of((Object)22);
        }
        ArrayList inboundPorts = Lists.newArrayList();
        MutableList portRanges = MutableList.copyOf((Iterable)((Iterable)entity.config().get(DockerContainer.INBOUND_TCP_PORTS)));
        for (String portRange : portRanges) {
            for (Integer port : PortRanges.fromString((String)portRange)) {
                inboundPorts.add(port);
            }
        }
        return inboundPorts;
    }

    protected List<Integer> toIntPortList(Object v) {
        if (v == null) {
            return ImmutableList.of();
        }
        PortRange portRange = PortRanges.fromIterable((Iterable)ImmutableList.of((Object)v));
        return ImmutableList.copyOf((Iterable)portRange);
    }

    protected String findImageName(Entity entity, ConfigBag setup) {
        String osVersion;
        String result = (String)entity.config().get(DockerContainer.IMAGE_NAME);
        if (Strings.isNonBlank((CharSequence)result)) {
            return result;
        }
        result = (String)setup.get(IMAGE);
        if (Strings.isNonBlank((CharSequence)result)) {
            return result;
        }
        String osFamily = (String)setup.get(OS_FAMILY);
        Optional<String> imageName = new ImageChooser().chooseImage(osFamily, osVersion = (String)setup.get(OS_VERSION_REGEX));
        if (imageName.isPresent()) {
            return (String)imageName.get();
        }
        throw new IllegalStateException("No matching image found for " + entity + " (no explicit image name, osFamily=" + osFamily + "; osVersion=" + osVersion + ")");
    }

    protected boolean isDockerContainer(Entity entity) {
        return this.implementsInterface(entity, DockerContainer.class);
    }

    protected boolean isKubernetesPod(Entity entity) {
        return this.implementsInterface(entity, KubernetesPod.class);
    }

    protected boolean isKubernetesResource(Entity entity) {
        return this.implementsInterface(entity, KubernetesResource.class);
    }

    public boolean implementsInterface(Entity entity, Class<?> type) {
        return Iterables.tryFind(Arrays.asList(entity.getClass().getInterfaces()), iface -> iface.isAssignableFrom(type)).isPresent();
    }

    public MachineProvisioningLocation<KubernetesMachineLocation> newSubLocation(Map<?, ?> newFlags) {
        throw new UnsupportedOperationException();
    }

    public <T> T lookup(ConfigKey<T> config, Entity entity, ConfigBag setup) {
        return (T)this.lookup(config, entity, setup, config.getDefaultValue());
    }

    public <T> T lookup(ConfigKey<T> config, Entity entity, ConfigBag setup, T defaultValue) {
        boolean entityConfigPresent = !entity.config().findKeysPresent(config::equals).isEmpty();
        boolean setupBagConfigPresent = setup.containsKey(config);
        if (entityConfigPresent) {
            return (T)entity.config().get(config);
        }
        if (setupBagConfigPresent) {
            return (T)setup.get(config);
        }
        return defaultValue;
    }

    public void waitForExitCondition(ExitCondition exitCondition) {
        this.waitForExitCondition(exitCondition, Duration.ONE_SECOND, Duration.FIVE_MINUTES);
    }

    public void waitForExitCondition(ExitCondition exitCondition, Duration initial, Duration duration) {
        ReferenceWithError result = Repeater.create().backoff(initial, 1.2, duration).limitTimeTo(duration).until((Callable)exitCondition).runKeepingError();
        if (!Boolean.TRUE.equals(result.get())) {
            String err = String.format("Exit condition unsatisfied after %s: %s", duration, exitCondition.getFailureMessage());
            LOG.info("{} (rethrowing)", (Object)err);
            throw new IllegalStateException(err);
        }
    }

    public static interface ExitCondition
    extends Callable<Boolean> {
        public String getFailureMessage();
    }
}

