/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.StartableApplication;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.StartableMethods;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApplication
extends AbstractEntity
implements StartableApplication {
    private static final Logger log = LoggerFactory.getLogger(AbstractApplication.class);
    private volatile Application application;

    public AbstractApplication() {
    }

    @Override
    public void init() {
        super.init();
        this.initApp();
    }

    protected void initApp() {
    }

    @Deprecated
    public AbstractApplication(Map properties) {
        super(properties);
    }

    @Deprecated
    public AbstractApplication(Map properties, Entity parent) {
        super(properties, parent);
    }

    @Override
    public Application getApplication() {
        Entity proxy = null;
        if (this.application != null) {
            if (this.application.getId().equals(this.getId())) {
                proxy = this.getProxyIfAvailable();
            }
            if (proxy == null || !(proxy instanceof Application)) {
                return this.application;
            }
        }
        if (this.getParent() != null) {
            return this.getParent().getApplication();
        }
        if (proxy == null) {
            proxy = this.getProxyIfAvailable();
        }
        if (proxy instanceof Application) {
            return (Application)this.getProxyIfAvailable();
        }
        if (this instanceof Application) {
            return this;
        }
        return null;
    }

    @Override
    protected synchronized void setApplication(Application app) {
        if (app.getId().equals(this.getId())) {
            this.application = this.getProxy() != null ? (Application)this.getProxy() : app;
        } else {
            this.application = app;
            if (this.getParent() == null) {
                log.warn("Setting application of " + this + " to " + app + ", but " + this + " is not parented");
            } else if (this.getParent().getApplicationId().equals(app.getParent())) {
                log.warn("Setting application of " + this + " to " + app + ", but parent " + this.getParent() + " has different app " + this.getParent().getApplication());
            }
        }
        super.setApplication(app);
    }

    @Override
    public AbstractApplication setParent(Entity parent) {
        super.setParent(parent);
        return this;
    }

    @Override
    protected void initEnrichers() {
        super.initEnrichers();
        ((ServiceStateLogic.ComputeServiceIndicatorsFromChildrenAndMembersSpec)((ServiceStateLogic.ComputeServiceIndicatorsFromChildrenAndMembersSpec)ServiceStateLogic.newEnricherFromChildren().checkChildrenAndMembers().configure(ServiceStateLogic.ComputeServiceIndicatorsFromChildrenAndMembers.UP_QUORUM_CHECK, this.config().get(UP_QUORUM_CHECK))).configure(ServiceStateLogic.ComputeServiceIndicatorsFromChildrenAndMembers.RUNNING_QUORUM_CHECK, this.config().get(RUNNING_QUORUM_CHECK))).addTo((Entity)this);
        ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this, Attributes.SERVICE_STATE_ACTUAL, (Object)("Application created but not yet started, at " + Time.makeDateString()));
    }

    @Override
    public void onManagementStarted() {
        super.onManagementStarted();
        if (!this.isRebinding()) {
            this.recordApplicationEvent(Lifecycle.CREATED);
        }
    }

    @Override
    public void start(Collection<? extends Location> locations) {
        this.addLocations(locations);
        Object locationsToUse = locations == null ? ImmutableSet.of() : locations;
        ServiceStateLogic.ServiceProblemsLogic.clearProblemsIndicator((Entity)this, START);
        ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this, Attributes.SERVICE_STATE_ACTUAL, (Object)"Application starting");
        ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((Entity)this, START.getName());
        this.setExpectedStateAndRecordLifecycleEvent(Lifecycle.STARTING);
        try {
            try {
                this.preStart((Collection<? extends Location>)locationsToUse);
                Object val = this.config().get(START_LATCH);
                if (val != null) {
                    log.debug("{} finished waiting for start-latch; continuing...", (Object)this);
                }
                this.doStart((Collection<? extends Location>)locationsToUse);
                this.postStart((Collection<? extends Location>)locationsToUse);
            }
            catch (ProblemStartingChildrenException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            catch (Exception e) {
                ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this, START.getName(), (Object)Exceptions.collapseText((Throwable)e));
                throw Exceptions.propagate((Throwable)e);
            }
        }
        catch (Exception e) {
            this.recordApplicationEvent(Lifecycle.ON_FIRE);
            ServiceStateLogic.setExpectedStateRunningWithErrors((Entity)this);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((Entity)this, Attributes.SERVICE_STATE_ACTUAL);
        }
        ServiceStateLogic.setExpectedState((Entity)this, Lifecycle.RUNNING);
        this.setExpectedStateAndRecordLifecycleEvent(Lifecycle.RUNNING);
        this.logApplicationLifecycle("Started");
    }

    @Override
    public void logApplicationLifecycle(String message) {
        if (this.getParent() == null) {
            log.info(message + " application " + this);
        } else {
            log.debug(message + " nested application " + this);
        }
    }

    protected void doStart(Collection<? extends Location> locations) {
        this.doStartChildren(locations);
    }

    protected void doStartChildren(Collection<? extends Location> locations) {
        try {
            StartableMethods.start((Entity)this, locations);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new ProblemStartingChildrenException(e);
        }
    }

    public void preStart(Collection<? extends Location> locations) {
    }

    public void postStart(Collection<? extends Location> locations) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.logApplicationLifecycle("Stopping");
        this.setExpectedStateAndRecordLifecycleEvent(Lifecycle.STOPPING);
        ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this, Attributes.SERVICE_STATE_ACTUAL, (Object)"Application stopping");
        this.sensors().set(SERVICE_UP, false);
        try {
            this.doStop();
        }
        catch (Exception e) {
            this.setExpectedStateAndRecordLifecycleEvent(Lifecycle.ON_FIRE);
            log.warn("Error stopping application " + this + " (rethrowing): " + e);
            throw Exceptions.propagate((Throwable)e);
        }
        ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this, Attributes.SERVICE_STATE_ACTUAL, (Object)"Application stopped");
        this.setExpectedStateAndRecordLifecycleEvent(Lifecycle.STOPPED);
        this.logApplicationLifecycle("Stopped");
        if (this.getParent() == null && Boolean.TRUE.equals(this.getConfig(DESTROY_ON_STOP))) {
            AbstractApplication abstractApplication = this;
            synchronized (abstractApplication) {
                this.getEntityManager().unmanage((Entity)this);
            }
        }
    }

    protected void doStop() {
        StartableMethods.stop((Entity)this);
    }

    @Override
    public void restart() {
        StartableMethods.restart((Entity)this);
    }

    @Override
    public void onManagementStopped() {
        super.onManagementStopped();
        if (this.getManagementContext().isRunning()) {
            this.recordApplicationEvent(Lifecycle.DESTROYED);
        }
    }

    @Override
    public void setExpectedStateAndRecordLifecycleEvent(Lifecycle state) {
        ServiceStateLogic.setExpectedState((Entity)this, state);
        this.recordApplicationEvent(state);
    }

    protected void recordApplicationEvent(Lifecycle state) {
        block3: {
            try {
                ((ManagementContextInternal)this.getManagementContext()).getUsageManager().recordApplicationEvent(this, state);
            }
            catch (RuntimeInterruptedException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (!this.getManagementContext().isRunning()) break block3;
                log.warn("Problem recording application event '" + (Object)((Object)state) + "' for " + this, (Throwable)e);
            }
        }
    }

    protected static class ProblemStartingChildrenException
    extends RuntimeException {
        private static final long serialVersionUID = 7710856289284536803L;

        private ProblemStartingChildrenException(Exception cause) {
            super(cause);
        }
    }
}

