/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.feed;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.feed.PollConfig;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;

public class FeedConfig<V, T, F extends FeedConfig<V, T, F>> {
    public static final Object UNCHANGED = Entities.UNCHANGED;
    public static final Object REMOVE = Entities.REMOVE;
    public static final AttributeSensor<Void> NO_SENSOR = Sensors.newSensor(Void.class, "brooklyn.no.sensor");
    private final AttributeSensor<T> sensor;
    private Function<? super V, T> onsuccess;
    private Function<? super V, T> onfailure;
    private Function<? super Exception, T> onexception;
    private Predicate<? super V> checkSuccess;
    private boolean suppressDuplicates;
    private boolean enabled = true;
    private Duration logWarningGraceTimeOnStartup = Duration.THIRTY_SECONDS;
    private Duration logWarningGraceTime = Duration.millis((Number)0);

    public FeedConfig(AttributeSensor<T> sensor) {
        this.sensor = sensor;
    }

    public FeedConfig(FeedConfig<V, T, F> other) {
        this.sensor = other.sensor;
        this.onsuccess = other.onsuccess;
        this.onfailure = other.onfailure;
        this.onexception = other.onexception;
        this.checkSuccess = other.checkSuccess;
        this.suppressDuplicates = other.suppressDuplicates;
        this.logWarningGraceTimeOnStartup = other.logWarningGraceTimeOnStartup;
        this.logWarningGraceTime = other.logWarningGraceTime;
        this.enabled = other.enabled;
    }

    protected F self() {
        return (F)this;
    }

    public AttributeSensor<T> getSensor() {
        return this.sensor;
    }

    public Predicate<? super V> getCheckSuccess() {
        return this.checkSuccess;
    }

    public Function<? super V, T> getOnSuccess() {
        return this.onsuccess;
    }

    public Function<? super V, T> getOnFailure() {
        return this.onfailure;
    }

    public Function<? super Exception, T> getOnException() {
        return this.onexception;
    }

    public boolean getSupressDuplicates() {
        return this.suppressDuplicates;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public F checkSuccess(Predicate<? super V> val) {
        this.checkSuccess = (Predicate)Preconditions.checkNotNull(val, (Object)"checkSuccess");
        return this.self();
    }

    public F checkSuccess(Function<? super V, Boolean> val) {
        return this.checkSuccess(Functionals.predicate(val));
    }

    @Deprecated
    private F checkSuccessLegacy(final Function<? super V, Boolean> val) {
        return this.checkSuccess(new Predicate<V>(){

            public boolean apply(V input) {
                return (Boolean)val.apply(input);
            }
        });
    }

    public F onSuccess(Function<? super V, T> val) {
        this.onsuccess = (Function)Preconditions.checkNotNull(val, (Object)"onSuccess");
        return this.self();
    }

    public F setOnSuccess(T val) {
        return this.onSuccess(Functions.constant(val));
    }

    public F onFailure(Function<? super V, T> val) {
        this.onfailure = (Function)Preconditions.checkNotNull(val, (Object)"onFailure");
        return this.self();
    }

    public F setOnFailure(T val) {
        return this.onFailure(Functions.constant(val));
    }

    public F onResult(Function<? super V, T> val) {
        this.onSuccess(val);
        return this.onFailure(val);
    }

    public F setOnResult(T val) {
        return this.onResult(Functions.constant(val));
    }

    public F onException(Function<? super Exception, T> val) {
        this.onexception = (Function)Preconditions.checkNotNull(val, (Object)"onException");
        return this.self();
    }

    public F setOnException(T val) {
        return this.onException(Functions.constant(val));
    }

    public F onFailureOrException(Function<Object, T> val) {
        this.onFailure(val);
        return this.onException(val);
    }

    public F setOnFailureOrException(T val) {
        return this.onFailureOrException(Functions.constant(val));
    }

    public F suppressDuplicates(boolean val) {
        this.suppressDuplicates = val;
        return this.self();
    }

    public F logWarningGraceTimeOnStartup(Duration val) {
        this.logWarningGraceTimeOnStartup = (Duration)Preconditions.checkNotNull((Object)val);
        return this.self();
    }

    public F logWarningGraceTime(Duration val) {
        this.logWarningGraceTime = (Duration)Preconditions.checkNotNull((Object)val);
        return this.self();
    }

    public Duration getLogWarningGraceTimeOnStartup() {
        return this.logWarningGraceTimeOnStartup;
    }

    public Duration getLogWarningGraceTime() {
        return this.logWarningGraceTime;
    }

    public F enabled(boolean val) {
        this.enabled = val;
        return this.self();
    }

    public boolean hasSuccessHandler() {
        return this.onsuccess != null;
    }

    public boolean hasFailureHandler() {
        return this.onfailure != null;
    }

    public boolean hasExceptionHandler() {
        return this.onexception != null;
    }

    public boolean hasCheckSuccessHandler() {
        return this.checkSuccess != null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.toStringBaseName());
        result.append("[");
        boolean contents = false;
        Object source = this.toStringPollSource();
        AttributeSensor<T> s = this.getSensor();
        if (Strings.isNonBlank((CharSequence)Strings.toString((Object)source))) {
            if (s != null) {
                result.append(s.getName());
                result.append(" <- ");
            }
            result.append(Strings.toUniqueString((Object)source, (int)40));
            contents = true;
        } else if (s != null) {
            result.append(s.getName());
            contents = true;
        }
        MutableList<Object> fields = this.toStringOtherFields();
        if (fields != null) {
            for (Object field : fields) {
                if (!Strings.isNonBlank((CharSequence)Strings.toString(field))) continue;
                if (contents) {
                    result.append("; ");
                }
                contents = true;
                result.append(field);
            }
        }
        result.append("]");
        return result.toString();
    }

    protected String toStringBaseName() {
        return JavaClassNames.simpleClassName((Object)this);
    }

    protected MutableList<Object> toStringOtherFields() {
        return MutableList.of();
    }

    protected Object toStringPollSource() {
        return null;
    }

    protected String getUniqueTag() {
        return this.toString();
    }

    protected MutableList<Object> equalsFields() {
        MutableList result = MutableList.of().appendIfNotNull(this.getSensor()).appendIfNotNull(this.toStringPollSource());
        for (Object field : this.toStringOtherFields()) {
            result.appendIfNotNull(field);
        }
        return result;
    }

    public int hashCode() {
        int hc = super.hashCode();
        for (Object f : this.equalsFields()) {
            hc = Objects.hashCode((Object[])new Object[]{hc, f});
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        PollConfig other = (PollConfig)obj;
        if (!Objects.equal((Object)this.getUniqueTag(), (Object)other.getUniqueTag())) {
            return false;
        }
        return Objects.equal(this.equalsFields(), other.equalsFields());
    }
}

