/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.validation;

import com.google.common.annotations.VisibleForTesting;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.apache.brooklyn.util.exceptions.Exceptions;

public class BrooklynValidation {
    protected static final BrooklynValidation INSTANCE = new BrooklynValidation();
    protected WeakHashMap<Object, Consumer<Object>> record = new WeakHashMap();
    protected ThreadLocal<Boolean> validationSuppressed = new ThreadLocal();

    public static BrooklynValidation getInstance() {
        return INSTANCE;
    }

    public <T> Consumer<? super T> setValidatorForInstance(T object, Consumer<? super T> validator) {
        return this.record.put(object, validator);
    }

    public boolean validateIfPresent(Object target) {
        if (Boolean.TRUE.equals(this.validationSuppressed.get())) {
            return false;
        }
        Consumer<Object> v = null;
        if (v == null) {
            v = this.record.get(new SameInstanceEqualsHashWrapper(target));
        }
        if (v == null) {
            return false;
        }
        v.accept(target);
        return true;
    }

    public <T> T ensureValid(T t) {
        this.validateIfPresent(t);
        return t;
    }

    @VisibleForTesting
    public int size() {
        return this.record.size();
    }

    public <T> T withValidationSuppressed(Callable<T> target) {
        Boolean old = this.validationSuppressed.get();
        try {
            this.validationSuppressed.set(true);
            T t = target.call();
            return t;
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
        finally {
            if (old != null) {
                this.validationSuppressed.set(old);
            } else {
                this.validationSuppressed.remove();
            }
        }
    }

    static class SameInstanceEqualsHashWrapper {
        final Object target;

        SameInstanceEqualsHashWrapper(Object target) {
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (this.target == o) {
                return true;
            }
            if (o instanceof SameInstanceEqualsHashWrapper) {
                return this.target == ((SameInstanceEqualsHashWrapper)o).target;
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this.target);
        }
    }
}

