/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.xml;

import javax.inject.Inject;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;

public class SessionCredentialsHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<SessionCredentials> {
    private final DateService dateService;
    private StringBuilder currentText = new StringBuilder();
    private SessionCredentials.Builder builder = SessionCredentials.builder();

    @Inject
    protected SessionCredentialsHandler(DateService dateService) {
        this.dateService = dateService;
    }

    public SessionCredentials getResult() {
        try {
            SessionCredentials sessionCredentials = this.builder.build();
            return sessionCredentials;
        }
        finally {
            this.builder = SessionCredentials.builder();
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("AccessKeyId")) {
            this.builder.accessKeyId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("SecretAccessKey")) {
            this.builder.secretAccessKey(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("SessionToken")) {
            this.builder.sessionToken(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("Expiration")) {
            try {
                this.builder.expiration(this.dateService.iso8601SecondsDateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText)));
            }
            catch (IllegalArgumentException e) {
                this.builder.expiration(this.dateService.iso8601DateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText)));
            }
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

