/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector;

import com.google.common.annotations.Beta;
import java.util.List;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.AddEffectorInitializerAbstract;
import org.apache.brooklyn.core.effector.AddEffectorInitializerAbstractProto;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.util.core.BrooklynEntityUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class AddChildrenEffector
extends AddEffectorInitializerAbstract {
    private static final Logger log = LoggerFactory.getLogger(AddChildrenEffector.class);
    public static final ConfigKey<Object> BLUEPRINT_YAML = ConfigKeys.newConfigKey(Object.class, "blueprint_yaml");
    public static final ConfigKey<String> BLUEPRINT_TYPE = ConfigKeys.newStringConfigKey("blueprint_type");
    public static final ConfigKey<Boolean> AUTO_START = ConfigKeys.newBooleanConfigKey("auto_start");

    private AddChildrenEffector() {
    }

    public AddChildrenEffector(ConfigBag params) {
        super(params);
    }

    public Effectors.EffectorBuilder<List<String>> newEffectorBuilder() {
        Effectors.EffectorBuilder<List<String>> eff = this.newAbstractEffectorBuilder(List.class);
        eff.impl(new Body(eff.buildAbstract(), this.initParams()));
        return eff;
    }

    protected static class Body
    extends EffectorBody<List<String>> {
        private final Effector<?> effector;
        private final String blueprintBase;
        private final Boolean autostart;

        public Body(Effector<?> eff, ConfigBag params) {
            this.effector = eff;
            Object yaml = params.get(BLUEPRINT_YAML);
            String blueprintType = params.get(BLUEPRINT_TYPE);
            this.blueprintBase = BrooklynEntityUtils.parseBlueprintYaml(yaml, blueprintType);
            this.autostart = params.get(AUTO_START);
        }

        @Override
        public List<String> call(ConfigBag params) {
            ConfigBag paramsMerged = AddEffectorInitializerAbstractProto.getMergedParams(this.effector, params);
            return BrooklynEntityUtils.addChildrenToEntity((Entity)this.entity(), paramsMerged, this.blueprintBase, this.autostart);
        }
    }
}

