/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.ha;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityManager;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeSyncRecord;
import org.apache.brooklyn.api.mgmt.ha.ManagementPlaneSyncRecord;
import org.apache.brooklyn.api.mgmt.ha.ManagementPlaneSyncRecordPersister;
import org.apache.brooklyn.api.mgmt.ha.MementoCopyMode;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.BrooklynFeatureEnablement;
import org.apache.brooklyn.core.BrooklynVersion;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.catalog.internal.CatalogDto;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.ha.BasicMasterChooser;
import org.apache.brooklyn.core.mgmt.ha.ManagementPlaneSyncRecordDeltaImpl;
import org.apache.brooklyn.core.mgmt.ha.MasterChooser;
import org.apache.brooklyn.core.mgmt.ha.dto.BasicManagementNodeSyncRecord;
import org.apache.brooklyn.core.mgmt.ha.dto.ManagementPlaneSyncRecordImpl;
import org.apache.brooklyn.core.mgmt.internal.BrooklynObjectManagementMode;
import org.apache.brooklyn.core.mgmt.internal.LocalEntityManager;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.mgmt.internal.LocationManagerInternal;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.internal.ManagementTransitionMode;
import org.apache.brooklyn.core.mgmt.persist.BrooklynPersistenceUtils;
import org.apache.brooklyn.core.mgmt.persist.PersistenceActivityMetrics;
import org.apache.brooklyn.core.mgmt.rebind.RebindManagerImpl;
import org.apache.brooklyn.core.mgmt.usage.ManagementNodeStateListener;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.core.typereg.BasicBrooklynTypeRegistry;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.BasicExecutionManager;
import org.apache.brooklyn.util.core.task.ScheduledTask;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class HighAvailabilityManagerImpl
implements HighAvailabilityManager {
    public static final String TASK_NAME = "HA poller task";
    public final ConfigKey<Duration> POLL_PERIOD = ConfigKeys.newConfigKey(Duration.class, "brooklyn.ha.pollPeriod", "How often nodes should poll to detect whether master is healthy", Duration.seconds((Number)1));
    public final ConfigKey<Duration> HEARTBEAT_TIMEOUT = ConfigKeys.newConfigKey(Duration.class, "brooklyn.ha.heartbeatTimeout", "Maximum allowable time for detection of a peer's heartbeat; if no sign of master after this time, another node may promote itself", Duration.THIRTY_SECONDS);
    public final ConfigKey<Duration> TIMEOUT_FOR_INACTIVE_NODE_REMOVAL_ON_STARTUP = ConfigKeys.newConfigKey(Duration.class, "brooklyn.ha.timeoutForInactiveNodeRemovalOnStartup", "Duration threshold for terminated node deletion from persistence (on startup of a server)", Duration.ZERO);
    private static final Logger LOG = LoggerFactory.getLogger(HighAvailabilityManagerImpl.class);
    private final ManagementContextInternal managementContext;
    private final ManagementNodeStateListener stateListener;
    private final String ownNodeId;
    private volatile ManagementPlaneSyncRecordPersister persister;
    private volatile PromotionListener promotionListener;
    private volatile MasterChooser masterChooser = new BasicMasterChooser.AlphabeticMasterChooser();
    private volatile Ticker localTickerUtc = new Ticker(){

        public long read() {
            return System.currentTimeMillis();
        }
    };
    private volatile Ticker optionalRemoteTickerUtc = null;
    private volatile Task<?> pollingTask;
    private volatile boolean persistenceEnabled;
    private volatile boolean disabled;
    private volatile boolean running;
    private volatile ManagementNodeState nodeState = ManagementNodeState.INITIALIZING;
    private volatile boolean nodeStateTransitionComplete = false;
    private volatile long priority = 0L;
    private String nodeIdToRemove = "";
    private static final int MAX_NODE_STATE_HISTORY = 200;
    private final List<Map<String, Object>> nodeStateHistory = MutableList.of();
    private volatile transient Duration pollPeriodLocalOverride;
    private volatile transient Duration heartbeatTimeoutOverride;
    private volatile ManagementPlaneSyncRecord lastSyncRecord;
    private volatile PersistenceActivityMetrics managementStateWritePersistenceMetrics = new PersistenceActivityMetrics();
    private volatile PersistenceActivityMetrics managementStateReadPersistenceMetrics = new PersistenceActivityMetrics();
    private final long startTimeUtc;

    public HighAvailabilityManagerImpl(ManagementContextInternal managementContext, ManagementNodeStateListener stateListener) {
        BasicExecutionManager.registerUninterestingTaskName(TASK_NAME, true);
        this.managementContext = managementContext;
        this.stateListener = stateListener;
        this.ownNodeId = managementContext.getManagementNodeId();
        this.startTimeUtc = this.localTickerUtc.read();
    }

    public HighAvailabilityManagerImpl setPersister(ManagementPlaneSyncRecordPersister persister) {
        this.persister = (ManagementPlaneSyncRecordPersister)Preconditions.checkNotNull((Object)persister, (Object)"persister");
        return this;
    }

    public ManagementPlaneSyncRecordPersister getPersister() {
        return this.persister;
    }

    protected synchronized Duration getPollPeriod() {
        if (this.pollPeriodLocalOverride != null) {
            return this.pollPeriodLocalOverride;
        }
        return this.managementContext.getBrooklynProperties().getConfig(this.POLL_PERIOD);
    }

    public HighAvailabilityManagerImpl setPollPeriod(Duration val) {
        this.pollPeriodLocalOverride = val;
        if (this.running) {
            this.registerPollTask();
        }
        return this;
    }

    public HighAvailabilityManagerImpl setMasterChooser(MasterChooser val) {
        this.masterChooser = (MasterChooser)Preconditions.checkNotNull((Object)val, (Object)"masterChooser");
        return this;
    }

    public synchronized Duration getHeartbeatTimeout() {
        if (this.heartbeatTimeoutOverride != null) {
            return this.heartbeatTimeoutOverride;
        }
        return this.managementContext.getBrooklynProperties().getConfig(this.HEARTBEAT_TIMEOUT);
    }

    public HighAvailabilityManagerImpl setHeartbeatTimeout(Duration val) {
        this.heartbeatTimeoutOverride = val;
        return this;
    }

    public HighAvailabilityManagerImpl setLocalTicker(Ticker val) {
        this.localTickerUtc = (Ticker)Preconditions.checkNotNull((Object)val);
        return this;
    }

    @VisibleForTesting
    public HighAvailabilityManagerImpl setRemoteTicker(Ticker val) {
        this.optionalRemoteTickerUtc = val;
        return this;
    }

    public HighAvailabilityManagerImpl setPromotionListener(PromotionListener val) {
        this.promotionListener = (PromotionListener)Preconditions.checkNotNull((Object)val, (Object)"promotionListener");
        return this;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void disabled(boolean persistenceEnabled) {
        this.persistenceEnabled = persistenceEnabled;
        this.disabled = true;
        this.setNodeStateTransitionComplete(true);
        this.stop(ManagementNodeState.MASTER);
    }

    public void start(HighAvailabilityMode startMode) {
        this.setNodeStateTransitionComplete(true);
        this.persistenceEnabled = true;
        this.disabled = false;
        this.running = true;
        if (this.persister != null) {
            this.persister.setIsStartup(true);
        }
        this.changeMode(startMode, true, true);
    }

    public void changeMode(HighAvailabilityMode startMode) {
        this.changeMode(startMode, false, false);
    }

    @VisibleForTesting
    @Beta
    public void changeMode(HighAvailabilityMode startMode, boolean preventElectionOnExplicitStandbyMode, boolean failOnExplicitModesIfUnusual) {
        ManagementPlaneSyncRecord planeRec;
        ManagementNodeSyncRecord existingMaster;
        LOG.debug("Changing HA mode to " + startMode + ", election prevention " + preventElectionOnExplicitStandbyMode + ", fail on unusual " + failOnExplicitModesIfUnusual);
        if (!this.running) {
            LOG.info("HA changing mode to " + startMode + " from " + this.getInternalNodeState() + " when not running, forcing an intermediate start as DISABLED then will convert to " + startMode);
            this.start(HighAvailabilityMode.DISABLED);
        }
        if ((this.getNodeState() == ManagementNodeState.FAILED || this.getNodeState() == ManagementNodeState.INITIALIZING) && startMode != HighAvailabilityMode.DISABLED) {
            this.setInternalNodeState(ManagementNodeState.INITIALIZING);
        }
        boolean weAreRecognisedAsMaster = (existingMaster = this.hasHealthyMaster(planeRec = this.loadManagementPlaneSyncRecord(false))) != null && this.ownNodeId.equals(existingMaster.getNodeId());
        boolean weAreMasterLocally = this.getInternalNodeState() == ManagementNodeState.MASTER;
        this.updateLocalPlaneId(planeRec);
        if (this.managementContext.getHighAvailabilityManager() != this) {
            throw new IllegalStateException("Cannot start an HA manager on a management context with a different HA manager!");
        }
        boolean newModeApplied = false;
        if (weAreMasterLocally) {
            switch (startMode) {
                case MASTER: 
                case AUTO: 
                case DISABLED: {
                    break;
                }
                case HOT_STANDBY: 
                case HOT_BACKUP: 
                case STANDBY: {
                    this.demoteTo((ManagementNodeState)ManagementNodeState.of((HighAvailabilityMode)startMode).get());
                    newModeApplied = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected high availability mode " + startMode + " requested for " + this);
                }
            }
        }
        ManagementNodeState oldState = this.getInternalNodeState();
        if (newModeApplied && Objects.equal((Object)oldState, (Object)startMode)) {
            return;
        }
        block5 : switch (startMode) {
            case AUTO: {
                if (this.getInternalNodeState() == ManagementNodeState.INITIALIZING) {
                    this.setInternalNodeState(ManagementNodeState.STANDBY);
                }
                this.publishAndCheck(true);
                switch (this.getInternalNodeState()) {
                    case HOT_BACKUP: {
                        if (!this.nodeStateTransitionComplete) {
                            throw new IllegalStateException("Cannot switch to AUTO when in the middle of a transition to " + this.getInternalNodeState());
                        }
                        this.setInternalNodeState(ManagementNodeState.STANDBY);
                        startMode = HighAvailabilityMode.HOT_BACKUP;
                    }
                    case HOT_STANDBY: 
                    case STANDBY: {
                        if (this.getInternalNodeState() == ManagementNodeState.STANDBY && oldState == ManagementNodeState.INITIALIZING && startMode != HighAvailabilityMode.HOT_BACKUP && BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.defaultStandbyIsHot")) {
                            startMode = HighAvailabilityMode.HOT_STANDBY;
                        }
                        ManagementPlaneSyncRecord newState = this.loadManagementPlaneSyncRecord(true);
                        String masterNodeId = newState.getMasterNodeId();
                        ManagementNodeSyncRecord masterNodeDetails = (ManagementNodeSyncRecord)newState.getManagementNodes().get(masterNodeId);
                        LOG.info("Management node " + this.ownNodeId + " in " + (String)this.managementContext.getManagementPlaneIdMaybe().or((Object)"<new-plane>") + " running as HA " + this.getInternalNodeState() + " autodetected" + (startMode == HighAvailabilityMode.HOT_STANDBY || startMode == HighAvailabilityMode.HOT_BACKUP ? " (will change to " + startMode + ")" : "") + ", " + (Strings.isBlank((CharSequence)masterNodeId) ? "no master currently (other node should promote itself soon)" : "master " + (existingMaster == null ? "(new) " : "") + "is " + masterNodeId + (masterNodeDetails == null || masterNodeDetails.getUri() == null ? " (no url)" : " at " + masterNodeDetails.getUri())));
                        break block5;
                    }
                    case MASTER: {
                        LOG.info("Management node " + this.ownNodeId + " in " + (String)this.managementContext.getManagementPlaneIdMaybe().or((Object)"<new-plane>") + " running as HA MASTER autodetected");
                        break block5;
                    }
                }
                throw new IllegalStateException("Management node " + this.ownNodeId + " in " + (String)this.managementContext.getManagementPlaneIdMaybe().or((Object)"<new-plane>") + " set to HA AUTO, encountered unexpected mode " + this.getInternalNodeState());
            }
            case MASTER: {
                if (!failOnExplicitModesIfUnusual || existingMaster == null) {
                    this.promoteToMaster();
                    if (existingMaster != null) {
                        LOG.info("Management node " + this.ownNodeId + " in " + (String)this.managementContext.getManagementPlaneIdMaybe().or((Object)"<new-plane>") + " running as HA MASTER explicitly");
                        break;
                    }
                    LOG.info("Management node " + this.ownNodeId + " in " + (String)this.managementContext.getManagementPlaneIdMaybe().or((Object)"<new-plane>") + " running as HA MASTER explicitly, stealing from " + existingMaster);
                    break;
                }
                if (!weAreRecognisedAsMaster) {
                    throw new IllegalStateException("Master already exists; cannot run as master (master " + existingMaster.toVerboseString() + "); to trigger a promotion, set a priority and demote the current master");
                }
                LOG.info("Management node " + this.ownNodeId + " in " + (String)this.managementContext.getManagementPlaneIdMaybe().or((Object)"<new-plane>") + " already running as HA MASTER, when set explicitly");
                break;
            }
            case HOT_BACKUP: {
                this.setInternalNodeState(ManagementNodeState.HOT_BACKUP);
            }
            case HOT_STANDBY: 
            case STANDBY: {
                if (startMode != HighAvailabilityMode.HOT_BACKUP) {
                    if (ManagementNodeState.isHotProxy((ManagementNodeState)this.getInternalNodeState()) && startMode == HighAvailabilityMode.HOT_STANDBY) {
                        this.setInternalNodeState(ManagementNodeState.HOT_STANDBY);
                    } else {
                        this.setInternalNodeState(ManagementNodeState.STANDBY);
                    }
                }
                if (ManagementNodeState.isStandby((ManagementNodeState)this.getInternalNodeState())) {
                    if (!preventElectionOnExplicitStandbyMode) {
                        this.publishAndCheck(true);
                    }
                    if (failOnExplicitModesIfUnusual && existingMaster == null) {
                        LOG.error("Management node " + this.ownNodeId + " in " + (String)this.managementContext.getManagementPlaneIdMaybe().or((Object)"<new-plane>") + " detected no master when " + startMode + " requested and existing master required; failing.");
                        throw new IllegalStateException("No existing master; cannot start as " + startMode);
                    }
                }
                String message = "Management node " + this.ownNodeId + " in " + (String)this.managementContext.getManagementPlaneIdMaybe().or((Object)"<new-plane>") + " running as HA " + this.getNodeState() + " (";
                message = this.getNodeState().toString().equals(startMode.toString()) ? message + "explicitly requested" : (startMode == HighAvailabilityMode.HOT_STANDBY && this.getNodeState() == ManagementNodeState.STANDBY ? message + "caller requested " + startMode + ", will attempt rebind for HOT_STANDBY next" : message + "caller requested " + startMode);
                if (this.getNodeState() == ManagementNodeState.MASTER) {
                    message = message + " but election re-promoted this node)";
                } else {
                    ManagementPlaneSyncRecord newState = this.loadManagementPlaneSyncRecord(true);
                    if (Strings.isBlank((CharSequence)newState.getMasterNodeId())) {
                        message = message + "); no master currently";
                        if (startMode != HighAvailabilityMode.HOT_BACKUP) {
                            message = message + " (subsequent election may repair)";
                        }
                    } else {
                        message = message + "); master " + newState.getMasterNodeId();
                    }
                }
                LOG.info(message);
                break;
            }
            case DISABLED: {
                LOG.info("Management node " + this.ownNodeId + " in " + (String)this.managementContext.getManagementPlaneIdMaybe().or((Object)"<new-plane>") + " HA DISABLED (was " + this.getInternalNodeState() + ")");
                this.demoteTo(ManagementNodeState.FAILED);
                if (this.pollingTask == null) break;
                this.pollingTask.cancel(true);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected high availability mode " + startMode + " requested for " + this);
            }
        }
        if (startMode == HighAvailabilityMode.HOT_STANDBY || startMode == HighAvailabilityMode.HOT_BACKUP) {
            if (!ManagementNodeState.isHotProxy((ManagementNodeState)oldState)) {
                this.setNodeStateTransitionComplete(false);
                if (startMode == HighAvailabilityMode.HOT_STANDBY) {
                    this.publishHealth();
                }
                try {
                    this.activateHotProxy((ManagementNodeState)ManagementNodeState.of((HighAvailabilityMode)startMode).get()).get();
                    this.setNodeStateTransitionComplete(true);
                    this.publishHealth();
                    if (this.getNodeState() == ManagementNodeState.HOT_STANDBY || this.getNodeState() == ManagementNodeState.HOT_BACKUP) {
                        LOG.info("Management node " + this.ownNodeId + " in " + (String)this.managementContext.getManagementPlaneIdMaybe().or((Object)"<new-plane>") + " now running as HA " + this.getNodeState() + "; " + this.managementContext.getApplications().size() + " application" + Strings.s((int)this.managementContext.getApplications().size()) + " loaded");
                    }
                    LOG.warn("Management node " + this.ownNodeId + " in " + (String)this.managementContext.getManagementPlaneIdMaybe().or((Object)"<new-plane>") + " unable to promote to " + startMode + " (currently " + this.getNodeState() + "); (see log for further details)");
                }
                catch (Exception e) {
                    LOG.warn("Management node " + this.ownNodeId + " in " + (String)this.managementContext.getManagementPlaneIdMaybe().or((Object)"<new-plane>") + " unable to promote to " + startMode + " (currently " + this.getNodeState() + "); rethrowing: " + Exceptions.collapseText((Throwable)e));
                    this.setNodeStateTransitionComplete(true);
                    throw Exceptions.propagate((Throwable)e);
                }
            } else {
                LOG.debug("Management node " + this.ownNodeId + " in " + (String)this.managementContext.getManagementPlaneIdMaybe().or((Object)"<new-plane>") + " restarting read only on transition to " + startMode + " (from " + oldState + " / " + this.getNodeState() + ")");
                this.managementContext.getRebindManager().stopReadOnly();
                this.managementContext.getRebindManager().startReadOnly((ManagementNodeState)ManagementNodeState.of((HighAvailabilityMode)startMode).get());
                this.setNodeStateTransitionComplete(true);
            }
        } else {
            this.setNodeStateTransitionComplete(true);
        }
        this.updateLastManagementPlaneSyncRecordWithLocalKnowledge();
        if (startMode != HighAvailabilityMode.DISABLED) {
            this.registerPollTask();
        }
    }

    protected void updateLocalPlaneId(ManagementPlaneSyncRecord existingMaster) {
        if (existingMaster.getPlaneId() != null) {
            ((LocalManagementContext)this.managementContext).setManagementPlaneId(existingMaster.getPlaneId());
        }
    }

    public void setPriority(long priority) {
        this.priority = priority;
        if (this.persister != null) {
            this.publishHealth();
        }
    }

    public long getPriority() {
        return this.priority;
    }

    public void stop() {
        LOG.debug("Stopping " + this);
        this.stop(ManagementNodeState.TERMINATED);
    }

    private void stop(ManagementNodeState newState) {
        boolean wasRunning = this.running;
        this.running = false;
        this.setInternalNodeState(newState);
        if (this.pollingTask != null) {
            this.pollingTask.cancel(true);
        }
        if (wasRunning) {
            try {
                this.publishHealth();
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                LOG.error("Problem publishing manager-node health on termination (continuing)", (Throwable)e);
            }
        }
    }

    public ManagementNodeState getTransitionTargetNodeState() {
        return this.getInternalNodeState();
    }

    protected ManagementNodeState getInternalNodeState() {
        return this.nodeState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInternalNodeState(ManagementNodeState newState) {
        LOG.debug("HA state internal " + this.nodeState + " -> " + newState);
        ManagementNodeState oldState = this.getInternalNodeState();
        List<Map<String, Object>> list = this.nodeStateHistory;
        synchronized (list) {
            if (this.nodeState != newState) {
                this.nodeStateHistory.add(0, (Map<String, Object>)MutableMap.of((Object)"state", (Object)newState, (Object)"timestamp", (Object)this.currentTimeMillis()));
                while (this.nodeStateHistory.size() > 200) {
                    this.nodeStateHistory.remove(this.nodeStateHistory.size() - 1);
                }
            }
            boolean awaitingInitialRebind = (this.running || this.disabled && this.persistenceEnabled) && (ManagementNodeState.isHotProxy((ManagementNodeState)newState) || newState == ManagementNodeState.MASTER);
            ((RebindManagerImpl)this.managementContext.getRebindManager()).setAwaitingInitialRebind(awaitingInitialRebind);
            this.nodeState = newState;
        }
        if (ManagementNodeState.isHotProxy((ManagementNodeState)oldState) && !ManagementNodeState.isHotProxy((ManagementNodeState)newState)) {
            LOG.debug("Resetting rebind on transition from hot proxy (" + oldState + ") to " + newState);
            this.managementContext.getRebindManager().stopReadOnly();
            this.clearManagedItems(ManagementTransitionMode.transitioning(BrooklynObjectManagementMode.LOADED_READ_ONLY, BrooklynObjectManagementMode.UNMANAGED_PERSISTED));
            this.managementContext.getRebindManager().reset();
        }
        this.stateListener.onStateChange(this.getNodeState());
    }

    private void setNodeStateTransitionComplete(boolean val) {
        this.nodeStateTransitionComplete = val;
        LOG.debug("HA state transition complete now " + val + " (" + this.nodeState + " / " + this.getNodeState() + ")");
        this.stateListener.onStateChange(this.getNodeState());
    }

    public ManagementNodeState getNodeState() {
        ManagementNodeState myNodeState = this.getInternalNodeState();
        if (myNodeState == ManagementNodeState.FAILED) {
            return this.getInternalNodeState();
        }
        if (myNodeState == ManagementNodeState.MASTER) {
            return myNodeState;
        }
        if (!this.nodeStateTransitionComplete) {
            return ManagementNodeState.INITIALIZING;
        }
        return myNodeState;
    }

    protected void registerPollTask() {
        final Runnable job = new Runnable(){
            private boolean lastFailed;

            @Override
            public void run() {
                try {
                    HighAvailabilityManagerImpl.this.publishAndCheck(false);
                    this.lastFailed = false;
                }
                catch (Exception e) {
                    if (HighAvailabilityManagerImpl.this.running) {
                        if (this.lastFailed) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Recurring problem in HA-poller: " + e, (Throwable)e);
                            }
                        } else {
                            LOG.error("Problem in HA-poller: " + e, (Throwable)e);
                            this.lastFailed = true;
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Problem in HA-poller, but no longer running: " + e, (Throwable)e);
                    }
                }
                catch (Throwable t) {
                    LOG.error("Problem in HA-poller: " + t, t);
                    throw Exceptions.propagate((Throwable)t);
                }
            }
        };
        Callable taskFactory = new Callable<Task<?>>(){

            @Override
            public Task<?> call() {
                return Tasks.builder().dynamic(false).body(job).displayName(HighAvailabilityManagerImpl.TASK_NAME).tag("TRANSIENT").description("polls HA status to see whether this node should promote").build();
            }
        };
        Duration pollPeriod = this.getPollPeriod();
        LOG.debug("Registering poll task for " + this + ", period " + pollPeriod);
        if (!pollPeriod.equals((Object)Duration.PRACTICALLY_FOREVER)) {
            if (this.pollingTask != null) {
                this.pollingTask.cancel(true);
            }
            ScheduledTask task = ScheduledTask.builder(taskFactory).period(pollPeriod).displayName(ScheduledTask.prefixScheduledName(TASK_NAME)).tagTransient().build();
            this.pollingTask = this.managementContext.getExecutionManager().submit((TaskAdaptable)task);
        }
    }

    @VisibleForTesting
    public synchronized void publishAndCheck(boolean initializing) {
        this.publishHealth();
        this.checkMaster(initializing);
    }

    protected synchronized void publishHealth() {
        if (this.persister == null) {
            LOG.info("Cannot publish management-node health as no persister");
            return;
        }
        Stopwatch timer = Stopwatch.createStarted();
        try {
            ManagementNodeSyncRecord memento = this.createManagementNodeSyncRecord(false);
            ManagementPlaneSyncRecordPersister.Delta delta = ManagementPlaneSyncRecordDeltaImpl.builder().node(memento).build();
            this.persister.delta(delta);
            this.managementStateWritePersistenceMetrics.noteSuccess(Duration.of((Object)timer));
            this.updateLastManagementPlaneSyncRecordWithLocalKnowledge();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Published management-node health: {}", (Object)memento);
            }
        }
        catch (Throwable t) {
            this.managementStateWritePersistenceMetrics.noteFailure(Duration.of((Object)timer));
            this.managementStateWritePersistenceMetrics.noteError(t.toString());
            LOG.debug("Error publishing management-node health (rethrowing): " + t);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    public void publishClearNonMaster() {
        ManagementPlaneSyncRecord plane = this.getLastManagementPlaneSyncRecord();
        if (plane == null || this.persister == null) {
            LOG.warn("Cannot clear HA node records; HA not active (or not yet loaded)");
            return;
        }
        ManagementPlaneSyncRecordDeltaImpl.Builder db = ManagementPlaneSyncRecordDeltaImpl.builder();
        for (Map.Entry node : plane.getManagementNodes().entrySet()) {
            if (ManagementNodeState.MASTER.equals((Object)((ManagementNodeSyncRecord)node.getValue()).getStatus()) && Objects.equal((Object)plane.getMasterNodeId(), (Object)((ManagementNodeSyncRecord)node.getValue()).getNodeId()) || !this.nodeIdToRemove.equals("") && (this.nodeIdToRemove.equals("") || !((ManagementNodeSyncRecord)node.getValue()).getNodeId().equals(this.nodeIdToRemove))) continue;
            db.removedNodeId((String)node.getKey());
        }
        this.persister.delta(db.build());
        this.loadManagementPlaneSyncRecord(true);
        if (!this.nodeIdToRemove.equals("")) {
            this.setNodeIdToRemove("");
        }
    }

    public void setNodeIdToRemove(String nodeId) {
        this.nodeIdToRemove = nodeId;
    }

    protected synchronized void publishDemotion(boolean demotingFromMaster) {
        Preconditions.checkState((this.getNodeState() != ManagementNodeState.MASTER ? 1 : 0) != 0, (String)"node status must not be master when demoting", (Object)this.getNodeState());
        if (this.persister == null) {
            LOG.info("Cannot publish management-node health as no persister");
            return;
        }
        ManagementNodeSyncRecord memento = this.createManagementNodeSyncRecord(false);
        ManagementPlaneSyncRecordDeltaImpl.Builder deltaBuilder = ManagementPlaneSyncRecordDeltaImpl.builder().node(memento);
        if (demotingFromMaster) {
            deltaBuilder.clearMaster(this.ownNodeId);
        }
        ManagementPlaneSyncRecordPersister.Delta delta = deltaBuilder.build();
        this.persister.delta(delta);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Published management-node health: {}", (Object)memento);
        }
    }

    protected synchronized void publishPromotionToMaster() {
        Preconditions.checkState((this.getNodeState() == ManagementNodeState.MASTER ? 1 : 0) != 0, (String)"node status must be master on publish, but is %s", (Object)this.getNodeState());
        if (this.persister == null) {
            LOG.info("Cannot publish management-node health as no persister");
            return;
        }
        ManagementNodeSyncRecord memento = this.createManagementNodeSyncRecord(false);
        ManagementPlaneSyncRecordPersister.Delta delta = ManagementPlaneSyncRecordDeltaImpl.builder().node(memento).setMaster(this.ownNodeId).build();
        this.persister.delta(delta);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Published management-node health: {}", (Object)memento);
        }
    }

    protected boolean isHeartbeatOk(ManagementNodeSyncRecord masterNode, ManagementNodeSyncRecord meNode) {
        if (masterNode == null) {
            return false;
        }
        if (meNode == null) {
            return true;
        }
        Long timestampMaster = masterNode.getRemoteTimestamp();
        Long timestampMe = meNode.getRemoteTimestamp();
        if (timestampMaster == null || timestampMe == null) {
            return false;
        }
        return timestampMe - timestampMaster <= this.getHeartbeatTimeout().toMilliseconds();
    }

    protected ManagementNodeSyncRecord hasHealthyMaster(ManagementPlaneSyncRecord memento) {
        boolean result;
        String nodeId = memento.getMasterNodeId();
        ManagementNodeSyncRecord masterMemento = nodeId == null ? null : (ManagementNodeSyncRecord)memento.getManagementNodes().get(nodeId);
        ManagementNodeSyncRecord ourMemento = (ManagementNodeSyncRecord)memento.getManagementNodes().get(this.ownNodeId);
        boolean bl = result = masterMemento != null && masterMemento.getStatus() == ManagementNodeState.MASTER && this.isHeartbeatOk(masterMemento, ourMemento);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Healthy-master check result={}; masterId={}; masterMemento={}; ourMemento={}", new Object[]{result, nodeId, masterMemento == null ? "<none>" : masterMemento.toVerboseString(), ourMemento == null ? "<none>" : ourMemento.toVerboseString()});
        }
        return result ? masterMemento : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkMaster(boolean initializing) {
        boolean demotingSelfInFavourOfOtherMaster;
        ManagementNodeSyncRecord newMasterNodeRecord;
        ManagementNodeSyncRecord ownNodeRecord;
        ManagementNodeSyncRecord currMasterNodeRecord;
        String currMasterNodeId;
        ManagementNodeState ourPrevState;
        ManagementPlaneSyncRecord memento;
        block12: {
            memento = this.loadManagementPlaneSyncRecord(false);
            if (this.getNodeState() == ManagementNodeState.FAILED) return;
            if (this.getNodeState() == ManagementNodeState.HOT_BACKUP) {
                return;
            }
            ourPrevState = this.getNodeState();
            this.updateLocalPlaneId(memento);
            currMasterNodeId = memento.getMasterNodeId();
            currMasterNodeRecord = (ManagementNodeSyncRecord)memento.getManagementNodes().get(currMasterNodeId);
            ownNodeRecord = (ManagementNodeSyncRecord)memento.getManagementNodes().get(this.ownNodeId);
            newMasterNodeRecord = null;
            demotingSelfInFavourOfOtherMaster = false;
            if (currMasterNodeRecord != null && currMasterNodeRecord.getStatus() == ManagementNodeState.MASTER && this.isHeartbeatOk(currMasterNodeRecord, ownNodeRecord)) {
                if (this.ownNodeId.equals(currMasterNodeId)) {
                    if (!LOG.isTraceEnabled()) return;
                    LOG.trace("Existing master healthy (us): master={}", (Object)currMasterNodeRecord.toVerboseString());
                    return;
                }
                if (ownNodeRecord != null && ownNodeRecord.getStatus() == ManagementNodeState.MASTER) {
                    LOG.error("Management node " + this.ownNodeId + " detected master change, stolen from us, deferring to " + currMasterNodeId);
                    newMasterNodeRecord = currMasterNodeRecord;
                    demotingSelfInFavourOfOtherMaster = true;
                    break block12;
                } else {
                    if (!LOG.isTraceEnabled()) return;
                    LOG.trace("Existing master healthy (remote): master={}", (Object)currMasterNodeRecord.toVerboseString());
                    return;
                }
            }
            if (ownNodeRecord == null || !this.isHeartbeatOk(ownNodeRecord, ownNodeRecord)) {
                if (ownNodeRecord == null) {
                    LOG.error("No management node memento for self (" + this.ownNodeId + "); perhaps persister unwritable? Master (" + currMasterNodeId + ") reported failed but no-op as cannot tell conclusively");
                    return;
                }
                LOG.error("This management node (" + this.ownNodeId + ") memento heartbeats out-of-date; perhaps perister unwritable? Master (" + currMasterNodeId + ") reported failed but no-op as cannot tell conclusively: self=" + ownNodeRecord.toVerboseString());
                return;
            }
            if (this.ownNodeId.equals(currMasterNodeId)) {
                LOG.warn("This management node (" + this.ownNodeId + ") supposed to be master but reportedly unhealthy? no-op as expect other node to fix: self=" + ownNodeRecord.toVerboseString());
                return;
            }
        }
        if (demotingSelfInFavourOfOtherMaster) {
            LOG.debug("Master-change for this node only, demoting " + ownNodeRecord.toVerboseString() + " in favour of official master " + newMasterNodeRecord.toVerboseString());
            this.demoteTo(BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.defaultStandbyIsHot") ? ManagementNodeState.HOT_STANDBY : ManagementNodeState.STANDBY);
            return;
        }
        LOG.debug("Detected master heartbeat timeout. Initiating a new master election. Master was " + currMasterNodeRecord);
        newMasterNodeRecord = this.masterChooser.choose(memento, this.getHeartbeatTimeout(), this.ownNodeId);
        String newMasterNodeId = newMasterNodeRecord == null ? null : newMasterNodeRecord.getNodeId();
        URI newMasterNodeUri = newMasterNodeRecord == null ? null : newMasterNodeRecord.getUri();
        boolean weAreNewMaster = this.ownNodeId.equals(newMasterNodeId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Management node master-change required: newMaster={}; oldMaster={}; plane={}, self={}; heartbeatTimeout={}", new Object[]{newMasterNodeRecord == null ? "<none>" : newMasterNodeRecord.toVerboseString(), currMasterNodeRecord == null ? currMasterNodeId + " (no memento)" : currMasterNodeRecord.toVerboseString(), memento, ownNodeRecord.toVerboseString(), this.getHeartbeatTimeout()});
        }
        String message = "Management node " + this.ownNodeId + " detected ";
        String currMasterSummary = (Strings.isNonBlank((CharSequence)currMasterNodeId) ? currMasterNodeId + " " : "") + "(" + (currMasterNodeRecord == null ? "<none>" : HighAvailabilityManagerImpl.timestampString(currMasterNodeRecord.getRemoteTimestamp())) + ")";
        if (weAreNewMaster && ownNodeRecord.getStatus() == ManagementNodeState.MASTER) {
            LOG.warn(message + "we must reassert master status, as we believe we should be master and other master " + (currMasterNodeRecord == null ? "(a node which has gone away)" : currMasterSummary) + " has failed");
            this.publishPromotionToMaster();
            this.publishHealth();
            return;
        }
        if (!initializing) {
            message = weAreNewMaster ? message + "we should be master, promoting from " + ourPrevState + "; master changing from " : (currMasterNodeRecord == null && newMasterNodeId == null ? message + "master change attempted but no candidates " : message + "master change, from ");
            message = message + currMasterSummary + " to " + (newMasterNodeId == null ? "<none>" : (weAreNewMaster ? "us " : "") + newMasterNodeId + " (" + HighAvailabilityManagerImpl.timestampString(newMasterNodeRecord.getRemoteTimestamp()) + ")" + (newMasterNodeUri != null ? " " + newMasterNodeUri : ""));
            LOG.info(message);
        }
        if (!weAreNewMaster) return;
        this.promoteToMaster();
    }

    private static String timestampString(Long remoteTimestamp) {
        if (remoteTimestamp == null) {
            return null;
        }
        return remoteTimestamp + " / " + Time.makeTimeStringRounded((Duration)Duration.sinceUtc((long)remoteTimestamp)) + " ago";
    }

    protected void promoteToMaster() {
        LOG.debug("Promoting to master: " + this);
        if (Tasks.current() != null) {
            Task task = Tasks.current();
            LOG.debug("Task context for master promotion: " + task + " (" + task.getTags() + "); " + task.getStatusSummary());
        }
        if (!this.running) {
            LOG.warn("Ignoring promote-to-master request, as HighAvailabilityManager is not running");
            return;
        }
        if (this.promotionListener != null) {
            try {
                this.promotionListener.promotingToMaster();
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                LOG.warn("Problem in promption-listener (continuing)", (Throwable)e);
            }
        }
        ((LocalManagementContext)this.managementContext).noteStartupTransitioning();
        this.setInternalNodeState(ManagementNodeState.MASTER);
        this.publishPromotionToMaster();
        try {
            this.managementContext.getRebindManager().rebind(this.managementContext.getCatalogClassLoader(), null, this.getInternalNodeState());
        }
        catch (Exception e) {
            LOG.error("Management node " + this.managementContext.getManagementNodeId() + " enountered problem during rebind when promoting self to master; demoting to FAILED and rethrowing: " + e);
            this.demoteTo(ManagementNodeState.FAILED);
            throw Exceptions.propagate((Throwable)e);
        }
        this.managementContext.getRebindManager().start();
        ((LocalManagementContext)this.managementContext).noteStartupComplete();
    }

    protected void backupOnDemotionIfNeeded() {
        if (this.managementContext.getBrooklynProperties().getConfig(BrooklynServerConfig.PERSISTENCE_BACKUPS_REQUIRED_ON_DEMOTION).booleanValue()) {
            BrooklynPersistenceUtils.createBackup(this.managementContext, BrooklynPersistenceUtils.CreateBackupMode.DEMOTION, MementoCopyMode.LOCAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void demoteTo(ManagementNodeState toState) {
        boolean wasMaster;
        LOG.debug("Management node " + this.ownNodeId + " in " + (String)this.managementContext.getManagementPlaneIdMaybe().or((Object)"<new-plane>") + " demoting to " + toState + " (from " + this.nodeState + " / " + this.getNodeState() + ")");
        if (toState != ManagementNodeState.FAILED && !this.running) {
            LOG.warn("Ignoring demote-from-master request, as HighAvailabilityManager is no longer running");
            return;
        }
        boolean bl = wasMaster = this.getInternalNodeState() == ManagementNodeState.MASTER;
        if (wasMaster) {
            try {
                this.backupOnDemotionIfNeeded();
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                LOG.error("Unable to create backup on demotion (ignoring): " + e, (Throwable)e);
            }
        }
        ManagementTransitionMode mode = ManagementTransitionMode.transitioning(wasMaster ? BrooklynObjectManagementMode.MANAGED_PRIMARY : BrooklynObjectManagementMode.LOADED_READ_ONLY, BrooklynObjectManagementMode.UNMANAGED_PERSISTED);
        this.setNodeStateTransitionComplete(false);
        switch (toState) {
            case HOT_BACKUP: 
            case STANDBY: 
            case FAILED: {
                this.setInternalNodeState(toState);
                break;
            }
            case HOT_STANDBY: {
                this.setInternalNodeState(ManagementNodeState.STANDBY);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal target state: " + toState);
            }
        }
        this.onDemotionStopItems(mode);
        this.setNodeStateTransitionComplete(true);
        this.publishDemotion(wasMaster);
        if (toState == ManagementNodeState.HOT_BACKUP || toState == ManagementNodeState.HOT_STANDBY) {
            this.setNodeStateTransitionComplete(false);
            try {
                this.activateHotProxy(toState).get();
            }
            finally {
                this.setNodeStateTransitionComplete(true);
            }
            this.publishHealth();
        }
    }

    protected void onDemotionStopItems(ManagementTransitionMode mode) {
        LOG.debug("Stopping rebind on demotion to " + mode + " (in state " + this.nodeState + ")");
        this.managementContext.getRebindManager().stopPersistence();
        this.managementContext.getRebindManager().stopReadOnly();
        this.clearManagedItems(mode);
        this.managementContext.getRebindManager().reset();
    }

    @VisibleForTesting
    public void clearManagedItems(ManagementTransitionMode mode) {
        LOG.info("Clearing all managed items on transition to " + mode);
        for (Application app : this.managementContext.getApplications()) {
            if (!((EntityInternal)app).getManagementSupport().isDeployed()) continue;
            ((LocalEntityManager)((EntityInternal)app).getManagementContext().getEntityManager()).unmanage((Entity)app, mode);
        }
        for (Entity entity : this.managementContext.getEntityManager().getEntities()) {
            ((LocalEntityManager)this.managementContext.getEntityManager()).unmanage(entity, mode);
        }
        for (Location loc : this.managementContext.getLocationManager().getLocations()) {
            if (loc.getParent() != null) continue;
            ((LocationManagerInternal)this.managementContext.getLocationManager()).unmanage((BrooklynObject)loc, mode);
        }
        for (Location loc : this.managementContext.getLocationManager().getLocations()) {
            ((LocationManagerInternal)this.managementContext.getLocationManager()).unmanage((BrooklynObject)loc, mode);
        }
        ((BasicBrooklynCatalog)this.managementContext.getCatalog()).reset(CatalogDto.newEmptyInstance("<reset-by-ha-status-change>"));
        ((BasicBrooklynTypeRegistry)this.managementContext.getTypeRegistry()).clear();
        this.managementContext.getCatalogInitialization().clearBrooklynManagedBundles();
        this.managementContext.getRebindManager().stopEntityTasksAndCleanUp("when clearing mgmt on HA change", Duration.millis((Number)500), Duration.seconds((Number)2));
    }

    protected ReferenceWithError<Boolean> activateHotProxy(ManagementNodeState toState) {
        try {
            LOG.debug("Activating hot proxy for state " + toState);
            Preconditions.checkState((!this.nodeStateTransitionComplete ? 1 : 0) != 0, (Object)("Must be in transitioning state to go into " + toState));
            this.setInternalNodeState(toState);
            this.managementContext.getRebindManager().startReadOnly(toState);
            return ReferenceWithError.newInstanceWithoutError((Object)true);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            LOG.warn("Unable to change " + this.ownNodeId + " to " + toState + ", switching to FAILED: " + e, (Throwable)e);
            this.demoteTo(ManagementNodeState.FAILED);
            return ReferenceWithError.newInstanceThrowingError((Object)false, (Throwable)e);
        }
    }

    public ManagementPlaneSyncRecord loadManagementPlaneSyncRecord(boolean useLocalKnowledgeForThisNode) {
        ManagementPlaneSyncRecord record;
        this.lastSyncRecord = record = this.loadManagementPlaneSyncRecordInternal(useLocalKnowledgeForThisNode);
        return record;
    }

    private void updateLastManagementPlaneSyncRecordWithLocalKnowledge() {
        if (this.lastSyncRecord != null) {
            this.lastSyncRecord = this.updateManagementPlaneSyncRecordWithLocalKnowledge(this.lastSyncRecord);
        }
    }

    public ManagementPlaneSyncRecord getLastManagementPlaneSyncRecord() {
        return this.lastSyncRecord;
    }

    private ManagementPlaneSyncRecord loadManagementPlaneSyncRecordInternal(boolean useLocalKnowledgeForThisNode) {
        if (this.disabled) {
            ManagementPlaneSyncRecordImpl.Builder builder = ManagementPlaneSyncRecordImpl.builder().planeId((String)this.managementContext.getManagementPlaneIdMaybe().orNull()).node(this.createManagementNodeSyncRecord(true));
            if (this.getTransitionTargetNodeState() == ManagementNodeState.MASTER) {
                builder.masterNodeId(this.ownNodeId);
            }
            return builder.build();
        }
        if (this.persister == null) {
            LOG.debug("High availablity manager has no persister; returning empty record");
            return ManagementPlaneSyncRecordImpl.builder().build();
        }
        int maxLoadAttempts = 5;
        IOException lastException = null;
        Stopwatch timer = Stopwatch.createStarted();
        for (int i = 0; i < maxLoadAttempts; ++i) {
            try {
                ManagementPlaneSyncRecord result = this.persister.loadSyncRecord(this.managementContext.getBrooklynProperties().getConfig(this.TIMEOUT_FOR_INACTIVE_NODE_REMOVAL_ON_STARTUP));
                if (useLocalKnowledgeForThisNode) {
                    result = this.updateManagementPlaneSyncRecordWithLocalKnowledge(result);
                }
                if (i > 0) {
                    this.managementStateReadPersistenceMetrics.noteError("Succeeded only on attempt " + (i + 1) + ": " + lastException);
                }
                this.managementStateReadPersistenceMetrics.noteSuccess(Duration.of((Object)timer));
                return result;
            }
            catch (IOException e) {
                if (i < maxLoadAttempts - 1 && LOG.isDebugEnabled()) {
                    LOG.debug("Problem loading mangement-plane memento attempt " + (i + 1) + "/" + maxLoadAttempts + "; retrying", (Throwable)e);
                }
                lastException = e;
                continue;
            }
        }
        String message = "Failed to load mangement-plane memento " + maxLoadAttempts + " consecutive times";
        this.managementStateReadPersistenceMetrics.noteError(message + ": " + lastException);
        this.managementStateReadPersistenceMetrics.noteFailure(Duration.of((Object)timer));
        throw new IllegalStateException(message, lastException);
    }

    private ManagementPlaneSyncRecord updateManagementPlaneSyncRecordWithLocalKnowledge(ManagementPlaneSyncRecord result) {
        ManagementNodeSyncRecord me = BasicManagementNodeSyncRecord.builder().from((ManagementNodeSyncRecord)result.getManagementNodes().get(this.ownNodeId), true).from(this.createManagementNodeSyncRecord(false), true).build();
        Iterable<Object> allNodes = result.getManagementNodes().values();
        if (me.getRemoteTimestamp() != null) {
            allNodes = Iterables.transform(allNodes, (Function)new MarkAwolNodes(me));
        }
        ManagementPlaneSyncRecordImpl.Builder builder = ManagementPlaneSyncRecordImpl.builder().masterNodeId(result.getMasterNodeId()).nodes(allNodes);
        builder.node(me);
        if (this.getTransitionTargetNodeState() == ManagementNodeState.MASTER) {
            builder.masterNodeId(this.ownNodeId);
        }
        return builder.build();
    }

    protected ManagementNodeSyncRecord createManagementNodeSyncRecord(boolean useLocalTimestampAsRemoteTimestamp) {
        long timestamp = this.currentTimeMillis();
        BasicManagementNodeSyncRecord.Builder builder = BasicManagementNodeSyncRecord.builder().brooklynVersion(BrooklynVersion.get()).nodeId(this.ownNodeId).status(this.getNodeState()).priority(this.getPriority()).localTimestamp(timestamp).uri((URI)this.managementContext.getManagementNodeUri().orNull());
        if (useLocalTimestampAsRemoteTimestamp) {
            builder.remoteTimestamp(timestamp);
        } else if (this.optionalRemoteTickerUtc != null) {
            builder.remoteTimestamp(this.optionalRemoteTickerUtc.read());
        }
        return builder.build();
    }

    protected long currentTimeMillis() {
        return this.localTickerUtc.read();
    }

    public String toString() {
        return super.toString() + "[node:" + this.ownNodeId + ";running=" + this.running + "]";
    }

    public Map<String, Object> getMetrics() {
        MutableMap result = MutableMap.of();
        result.put("state", this.getNodeState());
        result.put("uptime", Time.makeTimeStringRounded((Duration)Duration.millis((Number)(this.currentTimeMillis() - this.startTimeUtc))));
        result.put("currentTimeUtc", this.currentTimeMillis());
        result.put("startTimeUtc", this.startTimeUtc);
        result.put("highAvailability", MutableMap.of((Object)"priority", (Object)this.getPriority(), (Object)"pollPeriod", (Object)this.getPollPeriod().toMilliseconds(), (Object)"heartbeatTimeout", (Object)this.getHeartbeatTimeout().toMilliseconds(), (Object)"history", this.nodeStateHistory));
        result.putAll(this.managementContext.getRebindManager().getMetrics());
        result.put("managementStatePersistence", MutableMap.of((Object)"read", (Object)this.managementStateReadPersistenceMetrics, (Object)"write", (Object)this.managementStateWritePersistenceMetrics));
        return result;
    }

    public long getLastStateChange() {
        if (this.nodeStateHistory.size() > 0) {
            return (Long)this.nodeStateHistory.get(0).get("timestamp");
        }
        return 0L;
    }

    private class MarkAwolNodes
    implements Function<ManagementNodeSyncRecord, ManagementNodeSyncRecord> {
        private final ManagementNodeSyncRecord referenceNode;

        private MarkAwolNodes(ManagementNodeSyncRecord referenceNode) {
            this.referenceNode = referenceNode;
        }

        @Nullable
        public ManagementNodeSyncRecord apply(@Nullable ManagementNodeSyncRecord input) {
            if (input == null) {
                return null;
            }
            if (input.getStatus() != ManagementNodeState.STANDBY && input.getStatus() != ManagementNodeState.HOT_STANDBY && input.getStatus() != ManagementNodeState.MASTER && input.getStatus() != ManagementNodeState.HOT_BACKUP) {
                return input;
            }
            if (HighAvailabilityManagerImpl.this.isHeartbeatOk(input, this.referenceNode)) {
                return input;
            }
            return BasicManagementNodeSyncRecord.builder().from(input).status(ManagementNodeState.FAILED).build();
        }
    }

    @VisibleForTesting
    public static interface PromotionListener {
        public void promotingToMaster();
    }
}

