/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.container.entity.helm;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.container.entity.helm.HelmEntity;
import org.apache.brooklyn.container.location.kubernetes.KubernetesLocation;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.core.sensor.function.FunctionSensor;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.internal.ssh.process.ProcessTool;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;

public class HelmEntityImpl
extends AbstractEntity
implements HelmEntity {
    private FunctionFeed serviceUpFeed;

    protected void connectSensors() {
        this.connectServiceUpIsRunning();
        this.addHelmFeed("status", (AttributeSensor<String>)STATUS);
        this.addKubernetesFeeds();
    }

    @Override
    public Integer resize(String deploymentName, Integer desiredSize) {
        this.scaleDeployment(desiredSize, deploymentName);
        return desiredSize;
    }

    public void start(Collection<? extends Location> locations) {
        this.addLocations(locations);
        this.doInstall();
        this.connectSensors();
    }

    public void stop() {
        this.disconnectSensors();
        this.deleteHelmDeployment();
    }

    public void restart() {
        this.stop();
        this.start((Collection<? extends Location>)ImmutableList.of());
    }

    public boolean isRunning() {
        ByteArrayOutputStream err;
        ByteArrayOutputStream out;
        String helmNameInstallName = (String)this.getConfig(HelmEntity.HELM_DEPLOYMENT_NAME);
        String namespace = this.getNamespace();
        ImmutableList command = ImmutableList.of((Object)String.format("helm status %s --namespace %s", helmNameInstallName, namespace));
        int exectionResponse = ProcessTool.execProcesses((List)command, null, null, (OutputStream)(out = new ByteArrayOutputStream()), (OutputStream)(err = new ByteArrayOutputStream()), (String)";", (boolean)false, (Object)this);
        return 0 == exectionResponse;
    }

    public void scaleDeployment(Integer scale, String deploymentName) {
        String config = (String)this.getLocation().getConfig(KubernetesLocation.KUBECONFIG);
        KubernetesClient client = this.getClient(config);
        ((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(this.getNamespace())).withName(deploymentName)).scale(scale.intValue());
    }

    protected void disconnectSensors() {
        this.disconnectServiceUpIsRunning();
    }

    private void addKubernetesFeeds() {
        Callable<Boolean> status = this.getKubeDeploymentsReady();
        FunctionSensor initializer = new FunctionSensor(ConfigBag.newInstance().configure(FunctionSensor.SENSOR_PERIOD, (Object)Duration.millis((Number)1000)).configure(FunctionSensor.SENSOR_NAME, (Object)DEPLOYMENT_READY.getName()).configure(FunctionSensor.SENSOR_TYPE, (Object)Boolean.class.getName()).configure(FunctionSensor.FUNCTION, status));
        initializer.apply((EntityLocal)this);
        FunctionFeed.builder().entity((Entity)this).poll(new FunctionPollConfig(DEPLOYMENTS).callable(this.getKubeDeploymentsCallable())).period(Duration.TEN_SECONDS).build(true);
        FunctionFeed.builder().entity((Entity)this).poll(new FunctionPollConfig(SERVICES).callable(this.getKubeServicesCallable())).period(Duration.TEN_SECONDS).build(true);
    }

    private void addHelmFeed(String command, AttributeSensor<String> sensor) {
        Callable<String> status = this.getCallable(command);
        FunctionPollConfig pollConfig = new FunctionPollConfig(sensor).callable(status);
        FunctionFeed.builder().entity((Entity)this).poll(pollConfig).period(Duration.FIVE_SECONDS).build(true);
    }

    private void connectServiceUpIsRunning() {
        Duration period = Duration.FIVE_SECONDS;
        this.serviceUpFeed = FunctionFeed.builder().entity((Entity)this).period(period).poll(((FunctionPollConfig)((FunctionPollConfig)new FunctionPollConfig(Attributes.SERVICE_UP).suppressDuplicates(true)).onException(Functions.constant((Object)Boolean.FALSE))).callable(() -> this.isRunning())).build(true);
    }

    private void disconnectServiceUpIsRunning() {
        this.serviceUpFeed.stop();
    }

    private void doInstall() {
        final String repoName = (String)this.getConfig(HelmEntity.REPO_NAME);
        final String repoUrl = (String)this.getConfig(HelmEntity.REPO_URL);
        final String helmTemplate = (String)this.getConfig(HelmEntity.HELM_TEMPLATE);
        final String helmDeploymentName = (String)this.getConfig(HelmEntity.HELM_DEPLOYMENT_NAME);
        final String installValues = (String)this.getConfig(HelmEntity.HELM_INSTALL_VALUES);
        final String namespace = this.getNamespace();
        if (Strings.isNonBlank((CharSequence)repoName) && Strings.isNonBlank((CharSequence)repoUrl)) {
            DynamicTasks.queue((String)"install repo", (Runnable)new Runnable(){

                @Override
                public void run() {
                    ImmutableList setupRepoCommand = ImmutableList.of((Object)HelmEntityImpl.this.buildAddRepoCommand(repoName, repoUrl));
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ByteArrayOutputStream err = new ByteArrayOutputStream();
                    ProcessTool.execProcesses((List)setupRepoCommand, null, null, (OutputStream)out, (OutputStream)err, (String)";", (boolean)false, (Object)this);
                    Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStreamSoft((String)"stdout", (ByteArrayOutputStream)out));
                    Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStreamSoft((String)"stderr", (ByteArrayOutputStream)err));
                }
            });
        }
        DynamicTasks.queue((String)"install", (Runnable)new Runnable(){

            @Override
            public void run() {
                ImmutableList installHelmTemplateCommand = ImmutableList.of((Object)HelmEntityImpl.this.buildInstallCommand(helmDeploymentName, helmTemplate, installValues, namespace));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                ProcessTool.execProcesses((List)installHelmTemplateCommand, null, null, (OutputStream)out, (OutputStream)err, (String)";", (boolean)false, (Object)this);
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStreamSoft((String)"stdout", (ByteArrayOutputStream)out));
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStreamSoft((String)"stderr", (ByteArrayOutputStream)err));
            }
        });
    }

    private String getNamespace() {
        return (String)this.getLocation().getConfig(KubernetesLocation.NAMESPACE);
    }

    private void deleteHelmDeployment() {
        DynamicTasks.queue((String)"stop", (Runnable)new Runnable(){

            @Override
            public void run() {
                String helmNameInstallName = (String)HelmEntityImpl.this.getConfig(HelmEntity.HELM_DEPLOYMENT_NAME);
                String namespace = HelmEntityImpl.this.getNamespace();
                ImmutableList command = ImmutableList.of((Object)String.format("helm delete %s --namespace %s", helmNameInstallName, namespace));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                ProcessTool.execProcesses((List)command, null, null, (OutputStream)out, (OutputStream)err, (String)";", (boolean)false, (Object)this);
            }
        });
    }

    private Callable<List<String>> getKubeServicesCallable() {
        final String helmNameInstallName = (String)this.getConfig(HelmEntity.HELM_DEPLOYMENT_NAME);
        final String config = (String)this.getLocation().getConfig(KubernetesLocation.KUBECONFIG);
        return new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                KubernetesClient client = HelmEntityImpl.this.getClient(config);
                List services = ((ServiceList)((NonNamespaceOperation)client.services().inNamespace(HelmEntityImpl.this.getNamespace())).list()).getItems();
                return services.stream().filter(service -> ((String)service.getMetadata().getAnnotations().get("meta.helm.sh/release-name")).equals(helmNameInstallName)).map(service -> service.getMetadata().getName()).collect(Collectors.toList());
            }
        };
    }

    private Callable<List<String>> getKubeDeploymentsCallable() {
        final String helmNameInstallName = (String)this.getConfig(HelmEntity.HELM_DEPLOYMENT_NAME);
        final String config = (String)this.getLocation().getConfig(KubernetesLocation.KUBECONFIG);
        return new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                KubernetesClient client = HelmEntityImpl.this.getClient(config);
                List deployments = HelmEntityImpl.this.getDeployments(client, helmNameInstallName);
                for (Deployment deployment2 : deployments) {
                    String sensorName = "helm.deployment." + deployment2.getMetadata().getName() + ".replicas";
                    HelmEntityImpl.this.sensors().set(Sensors.newIntegerSensor((String)sensorName), (Object)deployment2.getStatus().getReplicas());
                    HelmEntityImpl.this.sensors().set(Sensors.newIntegerSensor((String)(sensorName + ".available")), (Object)deployment2.getStatus().getAvailableReplicas());
                }
                return deployments.stream().map(deployment -> deployment.getMetadata().getName()).collect(Collectors.toList());
            }
        };
    }

    private Callable<String> getCallable(String command) {
        String helmNameInstallName = (String)this.getConfig(HelmEntity.HELM_DEPLOYMENT_NAME);
        String namespace = this.getNamespace();
        final ImmutableList installHelmTemplateCommand = ImmutableList.of((Object)String.format("helm %s %s --namespace %s", command, helmNameInstallName, namespace));
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                ProcessTool.execProcesses((List)installHelmTemplateCommand, null, null, (OutputStream)out, (OutputStream)err, (String)";", (boolean)false, (Object)this);
                return ((Object)out).toString();
            }
        };
    }

    private Callable<Boolean> getKubeDeploymentsReady() {
        final String helmNameInstallName = (String)this.getConfig(HelmEntity.HELM_DEPLOYMENT_NAME);
        final String config = (String)this.getLocation().getConfig(KubernetesLocation.KUBECONFIG);
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                KubernetesClient client = HelmEntityImpl.this.getClient(config);
                List deployments = HelmEntityImpl.this.getDeployments(client, helmNameInstallName);
                Integer availableReplicas = HelmEntityImpl.this.countAvailableReplicas(deployments);
                Integer replicas = HelmEntityImpl.this.countReplicas(deployments);
                return availableReplicas.equals(replicas);
            }
        };
    }

    private List<Deployment> getDeployments(KubernetesClient client, String helmNameInstallName) {
        List items = ((DeploymentList)((NonNamespaceOperation)client.apps().deployments().inNamespace(this.getNamespace())).list()).getItems();
        items.stream().filter(deployment -> ((String)deployment.getMetadata().getAnnotations().get("meta.helm.sh/release-name")).equals(helmNameInstallName)).collect(Collectors.toList());
        return items;
    }

    private Integer countReplicas(List<Deployment> deployments) {
        return deployments.stream().map(deployment -> deployment.getStatus().getReplicas()).mapToInt(Integer::intValue).sum();
    }

    private Integer countAvailableReplicas(List<Deployment> deployments) {
        return deployments.stream().map(deployment -> deployment.getStatus().getAvailableReplicas()).mapToInt(Integer::intValue).sum();
    }

    private KubernetesLocation getLocation() {
        return (KubernetesLocation)Entities.getAllInheritedLocations((Entity)this).stream().filter(KubernetesLocation.class::isInstance).findFirst().get();
    }

    private Callable<Integer> getKubeReplicasCallable(final String deploymentName) {
        final String config = (String)this.getLocation().getConfig(KubernetesLocation.KUBECONFIG);
        return new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                KubernetesClient client = HelmEntityImpl.this.getClient(config);
                Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(HelmEntityImpl.this.getNamespace())).withName(deploymentName)).get();
                return deployment.getStatus().getReplicas();
            }
        };
    }

    KubernetesClient getClient(String configFile) {
        Path configPath = Paths.get(configFile, new String[0]);
        try {
            Config clientConfig = Config.fromKubeconfig((String)new String(Files.readAllBytes(configPath)));
            ConfigBuilder configBuilder = new ConfigBuilder(clientConfig);
            return new DefaultKubernetesClient(configBuilder.build());
        }
        catch (IOException ioe) {
            Exceptions.propagate((Throwable)ioe);
            return null;
        }
    }

    private String buildAddRepoCommand(String repoName, String repoUrl) {
        return String.format("helm repo add %s %s", repoName, repoUrl);
    }

    private String buildInstallCommand(String helmDeploymentName, String helmTemplate, String installValues, String namespace) {
        String installCommand = String.format("helm install %s %s", helmDeploymentName, helmTemplate);
        if (Strings.isNonBlank((CharSequence)installValues)) {
            installCommand = installCommand + String.format(" --values %s", installValues);
        }
        if (Strings.isNonBlank((CharSequence)namespace)) {
            installCommand = installCommand + String.format(" --namespace %s", namespace);
        }
        return installCommand;
    }
}

