/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.ssh;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import org.jclouds.util.Strings2;

public class DSAKeys {
    public static String encodeAsOpenSSH(DSAPublicKey key) {
        DSAParams params = key.getParams();
        byte[] keyBlob = DSAKeys.keyBlob(params.getP(), params.getQ(), params.getG(), key.getY());
        return "ssh-dss " + BaseEncoding.base64().encode(keyBlob);
    }

    public static DSAPublicKeySpec publicKeySpecFromOpenSSH(String idDsaPub) {
        try {
            return DSAKeys.publicKeySpecFromOpenSSH(ByteSource.wrap((byte[])idDsaPub.getBytes(Charsets.UTF_8)));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static DSAPublicKeySpec publicKeySpecFromOpenSSH(ByteSource supplier) throws IOException {
        InputStream stream = supplier.openStream();
        Iterable parts = Splitter.on((char)' ').split((CharSequence)Strings2.toStringAndClose((InputStream)stream).trim());
        Preconditions.checkArgument((Iterables.size((Iterable)parts) >= 2 && "ssh-dss".equals(Iterables.get((Iterable)parts, (int)0)) ? 1 : 0) != 0, (Object)"bad format, should be: ssh-dss AAAAB3...");
        stream = new ByteArrayInputStream(BaseEncoding.base64().decode((CharSequence)Iterables.get((Iterable)parts, (int)1)));
        String marker = new String(DSAKeys.readLengthFirst(stream));
        Preconditions.checkArgument((boolean)"ssh-dss".equals(marker), (String)"looking for marker ssh-dss but got %s", (Object)marker);
        BigInteger p = new BigInteger(DSAKeys.readLengthFirst(stream));
        BigInteger q = new BigInteger(DSAKeys.readLengthFirst(stream));
        BigInteger g = new BigInteger(DSAKeys.readLengthFirst(stream));
        BigInteger y = new BigInteger(DSAKeys.readLengthFirst(stream));
        return new DSAPublicKeySpec(y, p, q, g);
    }

    public static String fingerprintPublicKey(String publicKeyOpenSSH) {
        DSAPublicKeySpec publicKeySpec = DSAKeys.publicKeySpecFromOpenSSH(publicKeyOpenSSH);
        return DSAKeys.fingerprint(publicKeySpec.getP(), publicKeySpec.getQ(), publicKeySpec.getG(), publicKeySpec.getY());
    }

    public static String fingerprint(BigInteger p, BigInteger q, BigInteger g, BigInteger y) {
        byte[] keyBlob = DSAKeys.keyBlob(p, q, g, y);
        return DSAKeys.hexColonDelimited(Hashing.md5().hashBytes(keyBlob));
    }

    private static String hexColonDelimited(HashCode hc) {
        return Joiner.on((char)':').join(Splitter.fixedLength((int)2).split((CharSequence)BaseEncoding.base16().lowerCase().encode(hc.asBytes())));
    }

    private static byte[] keyBlob(BigInteger p, BigInteger q, BigInteger g, BigInteger y) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DSAKeys.writeLengthFirst("ssh-dss".getBytes(), out);
            DSAKeys.writeLengthFirst(p.toByteArray(), out);
            DSAKeys.writeLengthFirst(q.toByteArray(), out);
            DSAKeys.writeLengthFirst(g.toByteArray(), out);
            DSAKeys.writeLengthFirst(y.toByteArray(), out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static byte[] readLengthFirst(InputStream in) throws IOException {
        int byte1 = in.read();
        int byte2 = in.read();
        int byte3 = in.read();
        int byte4 = in.read();
        int length = (byte1 << 24) + (byte2 << 16) + (byte3 << 8) + (byte4 << 0);
        byte[] val = new byte[length];
        ByteStreams.readFully((InputStream)in, (byte[])val);
        return val;
    }

    private static void writeLengthFirst(byte[] array, ByteArrayOutputStream out) throws IOException {
        out.write(array.length >>> 24 & 0xFF);
        out.write(array.length >>> 16 & 0xFF);
        out.write(array.length >>> 8 & 0xFF);
        out.write(array.length >>> 0 & 0xFF);
        if (array.length == 1 && array[0] == 0) {
            out.write(new byte[0]);
        } else {
            out.write(array);
        }
    }
}

