/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.collections4.iterators.AbstractMapIteratorTest;
import org.apache.commons.collections4.iterators.UnmodifiableMapIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableMapIteratorTest<K, V>
extends AbstractMapIteratorTest<K, V> {
    @Override
    public Map<K, V> getConfirmedMap() {
        HashMap<String, String> testMap = new HashMap<String, String>();
        testMap.put("A", "a");
        testMap.put("B", "b");
        testMap.put("C", "c");
        return testMap;
    }

    @Override
    public IterableMap<K, V> getMap() {
        DualHashBidiMap testMap = new DualHashBidiMap();
        testMap.put((Object)"A", (Object)"a");
        testMap.put((Object)"B", (Object)"b");
        testMap.put((Object)"C", (Object)"c");
        return testMap;
    }

    @Override
    public MapIterator<K, V> makeEmptyIterator() {
        return UnmodifiableMapIterator.unmodifiableMapIterator((MapIterator)new DualHashBidiMap().mapIterator());
    }

    @Override
    public MapIterator<K, V> makeObject() {
        return UnmodifiableMapIterator.unmodifiableMapIterator((MapIterator)this.getMap().mapIterator());
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Override
    public boolean supportsSetValue() {
        return false;
    }

    @Test
    public void testDecorateFactory() {
        MapIterator it = this.makeObject();
        Assertions.assertSame(it, (Object)UnmodifiableMapIterator.unmodifiableMapIterator(it));
        it = this.getMap().mapIterator();
        Assertions.assertNotSame((Object)it, (Object)UnmodifiableMapIterator.unmodifiableMapIterator((MapIterator)it));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableMapIterator.unmodifiableMapIterator(null));
    }

    @Test
    public void testMapIterator() {
        Assertions.assertTrue((boolean)(this.makeEmptyIterator() instanceof Unmodifiable));
    }
}

