/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.io.File;
import java.util.logging.Logger;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.Script;
import org.apache.commons.jexl2.VarTest;
import org.apache.commons.jexl2.introspection.Sandbox;
import org.apache.commons.jexl2.introspection.SandboxUberspectImpl;
import org.apache.commons.jexl2.introspection.Uberspect;

public class SandboxTest
extends JexlTestCase {
    static final Logger LOGGER = Logger.getLogger(VarTest.class.getName());

    public void testCtorBlack() throws Exception {
        String expr = "new('" + Foo.class.getName() + "', '42')";
        Script script = this.JEXL.createScript(expr);
        Object result = script.execute(null);
        SandboxTest.assertEquals((String)"42", (String)((Foo)result).getName());
        Sandbox sandbox = new Sandbox();
        sandbox.black(Foo.class.getName()).execute(new String[]{""});
        SandboxUberspectImpl uber = new SandboxUberspectImpl(null, sandbox);
        JexlEngine sjexl = new JexlEngine((Uberspect)uber, null, null, null);
        sjexl.setStrict(true);
        script = sjexl.createScript(expr);
        try {
            result = script.execute(null);
            SandboxTest.fail((String)"ctor should not be accessible");
        }
        catch (JexlException.Method xmethod) {
            LOGGER.info(xmethod.toString());
        }
    }

    public void testMethodBlack() throws Exception {
        String expr = "foo.Quux()";
        Script script = this.JEXL.createScript(expr, new String[]{"foo"});
        Foo foo = new Foo("42");
        Object result = script.execute(null, new Object[]{foo});
        SandboxTest.assertEquals((Object)foo.Quux(), (Object)result);
        Sandbox sandbox = new Sandbox();
        sandbox.black(Foo.class.getName()).execute(new String[]{"Quux"});
        SandboxUberspectImpl uber = new SandboxUberspectImpl(null, sandbox);
        JexlEngine sjexl = new JexlEngine((Uberspect)uber, null, null, null);
        sjexl.setStrict(true);
        script = sjexl.createScript(expr, new String[]{"foo"});
        try {
            result = script.execute(null, new Object[]{foo});
            SandboxTest.fail((String)"Quux should not be accessible");
        }
        catch (JexlException.Method xmethod) {
            LOGGER.info(xmethod.toString());
        }
    }

    public void testGetBlack() throws Exception {
        String expr = "foo.alias";
        Script script = this.JEXL.createScript(expr, new String[]{"foo"});
        Foo foo = new Foo("42");
        Object result = script.execute(null, new Object[]{foo});
        SandboxTest.assertEquals((Object)foo.alias, (Object)result);
        Sandbox sandbox = new Sandbox();
        sandbox.black(Foo.class.getName()).read(new String[]{"alias"});
        SandboxUberspectImpl uber = new SandboxUberspectImpl(null, sandbox);
        JexlEngine sjexl = new JexlEngine((Uberspect)uber, null, null, null);
        sjexl.setStrict(true);
        script = sjexl.createScript(expr, new String[]{"foo"});
        try {
            result = script.execute(null, new Object[]{foo});
            SandboxTest.fail((String)"alias should not be accessible");
        }
        catch (JexlException.Property xvar) {
            LOGGER.info(xvar.toString());
        }
    }

    public void testSetBlack() throws Exception {
        String expr = "foo.alias = $0";
        Script script = this.JEXL.createScript(expr, new String[]{"foo", "$0"});
        Foo foo = new Foo("42");
        Object result = script.execute(null, new Object[]{foo, "43"});
        SandboxTest.assertEquals((Object)"43", (Object)result);
        Sandbox sandbox = new Sandbox();
        sandbox.black(Foo.class.getName()).write(new String[]{"alias"});
        SandboxUberspectImpl uber = new SandboxUberspectImpl(null, sandbox);
        JexlEngine sjexl = new JexlEngine((Uberspect)uber, null, null, null);
        sjexl.setStrict(true);
        script = sjexl.createScript(expr, new String[]{"foo", "$0"});
        try {
            result = script.execute(null, new Object[]{foo, "43"});
            SandboxTest.fail((String)"alias should not be accessible");
        }
        catch (JexlException.Property xvar) {
            LOGGER.info(xvar.toString());
        }
    }

    public void testCtorWhite() throws Exception {
        String expr = "new('" + Foo.class.getName() + "', '42')";
        Sandbox sandbox = new Sandbox();
        sandbox.white(Foo.class.getName()).execute(new String[]{""});
        SandboxUberspectImpl uber = new SandboxUberspectImpl(null, sandbox);
        JexlEngine sjexl = new JexlEngine((Uberspect)uber, null, null, null);
        sjexl.setStrict(true);
        Script script = sjexl.createScript(expr);
        Object result = script.execute(null);
        SandboxTest.assertEquals((String)"42", (String)((Foo)result).getName());
    }

    public void testMethodWhite() throws Exception {
        Foo foo = new Foo("42");
        String expr = "foo.Quux()";
        Sandbox sandbox = new Sandbox();
        sandbox.white(Foo.class.getName()).execute(new String[]{"Quux"});
        SandboxUberspectImpl uber = new SandboxUberspectImpl(null, sandbox);
        JexlEngine sjexl = new JexlEngine((Uberspect)uber, null, null, null);
        sjexl.setStrict(true);
        Script script = sjexl.createScript(expr, new String[]{"foo"});
        Object result = script.execute(null, new Object[]{foo});
        SandboxTest.assertEquals((Object)foo.Quux(), (Object)result);
    }

    public void testGetWhite() throws Exception {
        Foo foo = new Foo("42");
        String expr = "foo.alias";
        Sandbox sandbox = new Sandbox();
        sandbox.white(Foo.class.getName()).read(new String[]{"alias"});
        sandbox.get(Foo.class.getName()).read().alias("alias", "ALIAS");
        SandboxUberspectImpl uber = new SandboxUberspectImpl(null, sandbox);
        JexlEngine sjexl = new JexlEngine((Uberspect)uber, null, null, null);
        sjexl.setStrict(true);
        Script script = sjexl.createScript(expr, new String[]{"foo"});
        Object result = script.execute(null, new Object[]{foo});
        SandboxTest.assertEquals((Object)foo.alias, (Object)result);
        script = sjexl.createScript("foo.ALIAS", new String[]{"foo"});
        result = script.execute(null, new Object[]{foo});
        SandboxTest.assertEquals((Object)foo.alias, (Object)result);
    }

    public void testSetWhite() throws Exception {
        Foo foo = new Foo("42");
        String expr = "foo.alias = $0";
        Sandbox sandbox = new Sandbox();
        sandbox.white(Foo.class.getName()).write(new String[]{"alias"});
        SandboxUberspectImpl uber = new SandboxUberspectImpl(null, sandbox);
        JexlEngine sjexl = new JexlEngine((Uberspect)uber, null, null, null);
        sjexl.setStrict(true);
        Script script = sjexl.createScript(expr, new String[]{"foo", "$0"});
        Object result = script.execute(null, new Object[]{foo, "43"});
        SandboxTest.assertEquals((Object)"43", (Object)result);
        SandboxTest.assertEquals((String)"43", (String)foo.alias);
    }

    public void testRestrict() throws Exception {
        Object result;
        MapContext context = new MapContext();
        context.set("System", System.class);
        Sandbox sandbox = new Sandbox();
        sandbox.white(System.class.getName()).execute(new String[]{"currentTimeMillis"});
        sandbox.black(File.class.getName()).execute(new String[]{""});
        SandboxUberspectImpl uber = new SandboxUberspectImpl(null, sandbox);
        JexlEngine sjexl = new JexlEngine((Uberspect)uber, null, null, null);
        sjexl.setStrict(true);
        Script script = sjexl.createScript("System.exit()");
        try {
            result = script.execute((JexlContext)context);
            SandboxTest.fail((String)"should not allow calling exit!");
        }
        catch (JexlException xjexl) {
            LOGGER.info(xjexl.toString());
        }
        script = sjexl.createScript("new('java.io.File', '/tmp/should-not-be-created')");
        try {
            result = script.execute((JexlContext)context);
            SandboxTest.fail((String)"should not allow creating a file");
        }
        catch (JexlException xjexl) {
            LOGGER.info(xjexl.toString());
        }
        String expr = "System.currentTimeMillis()";
        script = sjexl.createScript("System.currentTimeMillis()");
        result = script.execute((JexlContext)context);
        SandboxTest.assertNotNull((Object)result);
    }

    public static class Foo {
        String name;
        public String alias;

        public Foo(String name) {
            this.name = name;
            this.alias = name + "-alias";
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String Quux() {
            return this.name + "-quux";
        }
    }
}

