/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.IvParameterSpec;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;

public class AesCbcContentEncryptionAlgorithm
extends AbstractContentEncryptionAlgorithm {
    private static final Map<String, String> AES_HMAC_MAP = new HashMap<String, String>();
    private static final Map<String, Integer> AES_CEK_SIZE_MAP;

    public AesCbcContentEncryptionAlgorithm(ContentAlgorithm algo, boolean generateCekOnce) {
        super(AesCbcContentEncryptionAlgorithm.validateCekAlgorithm(algo), generateCekOnce);
    }

    public AesCbcContentEncryptionAlgorithm(byte[] cek, byte[] iv, ContentAlgorithm algo) {
        super(cek, iv, AesCbcContentEncryptionAlgorithm.validateCekAlgorithm(algo));
    }

    @Override
    public AlgorithmParameterSpec getAlgorithmParameterSpec(byte[] theIv) {
        return new IvParameterSpec(theIv);
    }

    @Override
    public byte[] getAdditionalAuthenticationData(String headersJson, byte[] aad) {
        return null;
    }

    @Override
    protected int getContentEncryptionKeySize(JweHeaders headers) {
        return AesCbcContentEncryptionAlgorithm.getFullCekKeySize(this.getAlgorithm().getJwaName()) * 8;
    }

    protected static int getFullCekKeySize(String algoJwt) {
        return AES_CEK_SIZE_MAP.get(algoJwt);
    }

    protected static String getHMACAlgorithm(String algoJwt) {
        return AES_HMAC_MAP.get(algoJwt);
    }

    protected static ContentAlgorithm validateCekAlgorithm(ContentAlgorithm cekAlgo) {
        if (!AlgorithmUtils.isAesCbcHmac(cekAlgo.getJwaName())) {
            LOG.warning("Invalid content encryption algorithm");
            throw new JweException(JweException.Error.INVALID_CONTENT_ALGORITHM);
        }
        return cekAlgo;
    }

    static {
        AES_HMAC_MAP.put(ContentAlgorithm.A128CBC_HS256.getJwaName(), "HmacSHA256");
        AES_HMAC_MAP.put(ContentAlgorithm.A192CBC_HS384.getJwaName(), "HmacSHA384");
        AES_HMAC_MAP.put(ContentAlgorithm.A256CBC_HS512.getJwaName(), "HmacSHA512");
        AES_CEK_SIZE_MAP = new HashMap<String, Integer>();
        AES_CEK_SIZE_MAP.put(ContentAlgorithm.A128CBC_HS256.getJwaName(), 32);
        AES_CEK_SIZE_MAP.put(ContentAlgorithm.A192CBC_HS384.getJwaName(), 48);
        AES_CEK_SIZE_MAP.put(ContentAlgorithm.A256CBC_HS512.getJwaName(), 64);
    }
}

