/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source;

import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementNodePointer;

public class SourceElementNodeIterator
implements NodeIterator {
    private final NodePointer parent;
    private final NodeTest nodeTest;
    private final SourceElement sourceElement;
    private SourceElement child = null;
    private final boolean reverse;
    private int position = 0;

    public SourceElementNodeIterator(NodePointer parent, NodeTest nodeTest, boolean reverse, NodePointer startWith) {
        this.parent = parent;
        this.sourceElement = (SourceElement)parent.getNode();
        if (startWith != null) {
            this.child = (SourceElement)startWith.getNode();
        }
        this.nodeTest = nodeTest;
        this.reverse = reverse;
    }

    public NodePointer getNodePointer() {
        if (this.position == 0) {
            this.setPosition(1);
        }
        if (this.child != null) {
            SourceElementNodePointer result = new SourceElementNodePointer(this.parent, this.child);
            result.setIndex(this.position - 1);
            return result;
        }
        return null;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        while (this.position < position) {
            if (this.next()) continue;
            return false;
        }
        while (this.position > position) {
            if (this.previous()) continue;
            return false;
        }
        return true;
    }

    private boolean previous() {
        --this.position;
        if (!this.reverse) {
            this.child = this.position == 0 ? null : (this.child == null ? this.sourceElement.getLastChild() : this.child.getPrecedingSourceElement(this.sourceElement));
            while (this.child != null && !this.testChild()) {
                this.child = this.child.getPrecedingSourceElement(this.sourceElement);
            }
        } else {
            this.child = this.child.getFollowingSourceElement(this.sourceElement);
            while (this.child != null && !this.testChild()) {
                this.child = this.child.getFollowingSourceElement(this.sourceElement);
            }
        }
        return this.child != null;
    }

    private boolean next() {
        ++this.position;
        if (!this.reverse) {
            this.child = this.position == 1 ? (this.child == null ? this.sourceElement.getFirstChild() : this.child.getFollowingSourceElement(this.sourceElement)) : this.child.getFollowingSourceElement(this.sourceElement);
            while (this.child != null && !this.testChild()) {
                this.child = this.child.getFollowingSourceElement(this.sourceElement);
            }
        } else {
            this.child = this.position == 1 ? (this.child == null ? this.sourceElement.getLastChild() : this.sourceElement.getPrecedingSourceElement(this.sourceElement)) : this.sourceElement.getPrecedingSourceElement(this.sourceElement);
            while (this.child != null && !this.testChild()) {
                this.child = this.child.getPrecedingSourceElement(this.sourceElement);
            }
        }
        return this.child != null;
    }

    private boolean testChild() {
        return SourceElementNodePointer.testSourceElement(this.child, this.nodeTest);
    }
}

