/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server;

import java.io.File;
import org.apache.directory.server.core.api.AbstractLayout;

public class InstallationLayout
extends AbstractLayout {
    public InstallationLayout(File installationDirectory) {
        super(installationDirectory);
        this.init();
    }

    public InstallationLayout(String installationDirectoryPath) {
        super(installationDirectoryPath);
        this.init();
    }

    private void init() {
        File[] requiredDirectories = new File[]{this.getInstallationDirectory(), this.getBinDirectory(), this.getConfDirectory(), this.getLibDirectory()};
        this.setRequiredDirectories(requiredDirectories);
        File[] requiredFiles = new File[]{this.getScriptFile(), this.getWrapperFile(), this.getWrapperConfigurationFile()};
        this.setRequiredFiles(requiredFiles);
    }

    public File getBinDirectory() {
        return new File(this.getInstallationDirectory(), "bin");
    }

    public File getConfDirectory() {
        return new File(this.getInstallationDirectory(), "conf");
    }

    public File getInstallationDirectory() {
        return this.getDirectory();
    }

    public File getLibDirectory() {
        return new File(this.getInstallationDirectory(), "lib");
    }

    public File getLicenseFile() {
        return new File(this.getInstallationDirectory(), "LICENSE");
    }

    public File getNoticeFile() {
        return new File(this.getInstallationDirectory(), "NOTICE");
    }

    public File getScriptFile() {
        return new File(this.getBinDirectory(), "apacheds");
    }

    public File getWrapperConfigurationFile() {
        return new File(this.getConfDirectory(), "wrapper.conf");
    }

    public File getWrapperFile() {
        return new File(this.getBinDirectory(), "wrapper");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Installation layout\n");
        sb.append("  Root dir          : ").append(this.getDirectory()).append('\n');
        sb.append("  Installation dir  : ").append(this.getInstallationDirectory()).append('\n');
        sb.append("  bin dir           : ").append(this.getBinDirectory()).append('\n');
        sb.append("  conf dir          : ").append(this.getConfDirectory()).append('\n');
        sb.append("Copied files\n");
        sb.append("  License file      : ").append(this.getLicenseFile()).append('\n');
        sb.append("  Notice file       : ").append(this.getNoticeFile()).append('\n');
        sb.append("  Script file       : ").append(this.getScriptFile()).append('\n');
        sb.append("  Wrapper file      : ").append(this.getWrapperFile()).append('\n');
        sb.append("  Wrapper Conf file : ").append(this.getWrapperConfigurationFile()).append('\n');
        return sb.toString();
    }
}

