/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text.list;

import java.util.Iterator;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.text.list.List;
import org.odftoolkit.simple.text.list.ListContainer;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListContainer
implements ListContainer {
    @Override
    public List addList() {
        return new List(this);
    }

    @Override
    public List addList(ListDecorator decorator) {
        return new List(this, decorator);
    }

    @Override
    public void clearList() {
        OdfElement containerElement = this.getListContainerElement();
        Node child = this.getListContainerElement().getFirstChild();
        while (child != null) {
            if (child instanceof TextListElement) {
                Node tmp = child;
                child = child.getNextSibling();
                containerElement.removeChild(tmp);
                continue;
            }
            child = child.getNextSibling();
        }
    }

    @Override
    public Iterator<List> getListIterator() {
        return new SimpleListIterator(this);
    }

    @Override
    public boolean removeList(List list) {
        OdfElement containerElement = this.getListContainerElement();
        OdfFileDom ownerDocument = (OdfFileDom)containerElement.getOwnerDocument();
        Document doc = (Document)ownerDocument.getDocument();
        for (Node child = containerElement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof TextListElement)) continue;
            TextListElement listElement1 = (TextListElement)child;
            String id1 = listElement1.getXmlIdAttribute();
            TextListElement listElement2 = list.getOdfElement();
            String id2 = listElement2.getXmlIdAttribute();
            if (listElement1 != listElement2 && (id1 == null || id2 == null || !id1.equals(id2))) continue;
            doc.removeElementLinkedResource((OdfElement)listElement1);
            containerElement.removeChild(child);
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleListIterator
    implements Iterator<List> {
        private OdfElement containerElement;
        private TextListElement nextListElement;
        private TextListElement tempListElement;

        private SimpleListIterator(ListContainer container) {
            this.containerElement = container.getListContainerElement();
        }

        @Override
        public boolean hasNext() {
            this.tempListElement = this.findNext(this.nextListElement);
            return this.tempListElement != null;
        }

        @Override
        public List next() {
            if (this.tempListElement != null) {
                this.nextListElement = this.tempListElement;
                this.tempListElement = null;
            } else {
                this.nextListElement = this.findNext(this.nextListElement);
            }
            if (this.nextListElement == null) {
                return null;
            }
            return new List(this.nextListElement);
        }

        @Override
        public void remove() {
            if (this.nextListElement == null) {
                throw new IllegalStateException("please call next() first.");
            }
            this.containerElement.removeChild((Node)this.nextListElement);
        }

        private TextListElement findNext(TextListElement nextListElement) {
            Node child = null;
            for (child = nextListElement == null ? this.containerElement.getFirstChild() : nextListElement.getNextSibling(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof TextListElement)) continue;
                return (TextListElement)child;
            }
            return null;
        }
    }
}

