/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.utils;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.connection.core.StudioControl;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Attribute;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Value;
import org.apache.directory.studio.ldifparser.LdifUtils;
import org.apache.directory.studio.ldifparser.model.LdifEOFPart;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeAddRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifChangeTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifCommentLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifControlLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;

public class ModelConverter {
    public static DummyEntry ldifContentRecordToEntry(LdifContentRecord ldifContentRecord, IBrowserConnection connection) throws LdapInvalidDnException {
        return ModelConverter.createIntern((LdifRecord)ldifContentRecord, connection);
    }

    public static DummyEntry ldifChangeAddRecordToEntry(LdifChangeAddRecord ldifChangeAddRecord, IBrowserConnection connection) throws LdapInvalidDnException {
        return ModelConverter.createIntern((LdifRecord)ldifChangeAddRecord, connection);
    }

    private static DummyEntry createIntern(LdifRecord ldifRecord, IBrowserConnection connection) throws LdapInvalidDnException {
        LdifPart[] parts = ldifRecord.getParts();
        EventRegistry.suspendEventFiringInCurrentThread();
        DummyEntry entry = new DummyEntry(new Dn(new String[]{ldifRecord.getDnLine().getValueAsString()}), connection);
        int i = 0;
        while (i < parts.length) {
            if (parts[i] instanceof LdifAttrValLine) {
                LdifAttrValLine line = (LdifAttrValLine)parts[i];
                String attributeName = line.getUnfoldedAttributeDescription();
                Object value = line.getValueAsObject();
                IAttribute attribute = entry.getAttribute(attributeName);
                if (attribute == null) {
                    attribute = new Attribute(entry, attributeName);
                    entry.addAttribute(attribute);
                }
                attribute.addValue(new Value(attribute, value));
            } else if (!(parts[i] instanceof LdifDnLine || parts[i] instanceof LdifSepLine || parts[i] instanceof LdifEOFPart || parts[i] instanceof LdifChangeTypeLine)) {
                String name = parts[i].toRawString();
                name = name.replaceAll("\n", "");
                name = name.replaceAll("\r", "");
                Attribute attribute = new Attribute(entry, name);
                attribute.addValue(new Value(attribute, parts[i]));
                entry.addAttribute(attribute);
            }
            ++i;
        }
        EventRegistry.resumeEventFiringInCurrentThread();
        return entry;
    }

    public static LdifChangeAddRecord entryToLdifChangeAddRecord(IEntry entry) {
        boolean mustCreateChangeTypeLine = true;
        IAttribute[] iAttributeArray = entry.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attribute = iAttributeArray[n2];
            IValue[] iValueArray = attribute.getValues();
            int n3 = iValueArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IValue value = iValueArray[n4];
                if (value.getRawValue() instanceof LdifPart) {
                    mustCreateChangeTypeLine = false;
                }
                ++n4;
            }
            ++n2;
        }
        LdifChangeAddRecord record = new LdifChangeAddRecord(LdifDnLine.create((String)entry.getDn().getName()));
        if (mustCreateChangeTypeLine) {
            ModelConverter.addControls((LdifChangeRecord)record, entry);
            record.setChangeType(LdifChangeTypeLine.createAdd());
        }
        IAttribute[] iAttributeArray2 = entry.getAttributes();
        int n5 = iAttributeArray2.length;
        n = 0;
        while (n < n5) {
            IAttribute attribute = iAttributeArray2[n];
            String name = attribute.getDescription();
            IValue[] iValueArray = attribute.getValues();
            int n6 = iValueArray.length;
            int n7 = 0;
            while (n7 < n6) {
                IValue value = iValueArray[n7];
                if (!value.isEmpty()) {
                    if (value.getRawValue() instanceof LdifPart) {
                        LdifPart part = (LdifPart)value.getRawValue();
                        if (part instanceof LdifChangeTypeLine) {
                            record.setChangeType((LdifChangeTypeLine)part);
                        } else if (part instanceof LdifCommentLine) {
                            record.addComment((LdifCommentLine)part);
                        } else if (part instanceof LdifControlLine) {
                            record.addControl((LdifControlLine)part);
                        }
                    } else if (value.isString()) {
                        record.addAttrVal(LdifAttrValLine.create((String)name, (String)value.getStringValue()));
                    } else {
                        record.addAttrVal(LdifAttrValLine.create((String)name, (byte[])value.getBinaryValue()));
                    }
                }
                ++n7;
            }
            ++n;
        }
        record.finish(LdifSepLine.create());
        return record;
    }

    public static LdifContentRecord entryToLdifContentRecord(IEntry entry) {
        LdifContentRecord record = LdifContentRecord.create((String)entry.getDn().getName());
        if (entry.getAttributes() != null) {
            IAttribute[] iAttributeArray = entry.getAttributes();
            int n = iAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAttribute attribute = iAttributeArray[n2];
                String name = attribute.getDescription();
                IValue[] iValueArray = attribute.getValues();
                int n3 = iValueArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IValue value = iValueArray[n4];
                    if (!value.isEmpty()) {
                        if (value.getRawValue() instanceof LdifPart) {
                            LdifPart part = (LdifPart)value.getRawValue();
                            if (part instanceof LdifCommentLine) {
                                record.addComment((LdifCommentLine)part);
                            }
                        } else if (value.isString()) {
                            record.addAttrVal(LdifAttrValLine.create((String)name, (String)value.getStringValue()));
                        } else {
                            record.addAttrVal(LdifAttrValLine.create((String)name, (byte[])value.getBinaryValue()));
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        record.finish(LdifSepLine.create());
        return record;
    }

    public static LdifAttrValLine valueToLdifAttrValLine(IValue value) {
        LdifAttrValLine line = value.isString() ? LdifAttrValLine.create((String)value.getAttribute().getDescription(), (String)value.getStringValue()) : LdifAttrValLine.create((String)value.getAttribute().getDescription(), (byte[])value.getBinaryValue());
        return line;
    }

    public static IValue ldifAttrValLineToValue(LdifAttrValLine line, IEntry entry) {
        try {
            Attribute attribute = new Attribute(entry, line.getUnfoldedAttributeDescription());
            Value value = new Value(attribute, line.getValueAsObject());
            return value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static LdifDnLine dnToLdifDnLine(Dn dn) {
        LdifDnLine line = LdifDnLine.create((String)dn.getName());
        return line;
    }

    public static void addControls(LdifChangeRecord cr, IEntry entry) {
        if (entry.isReferral()) {
            cr.addControl(LdifControlLine.create((String)StudioControl.MANAGEDSAIT_CONTROL.getOid(), (boolean)StudioControl.MANAGEDSAIT_CONTROL.isCritical(), (byte[])StudioControl.MANAGEDSAIT_CONTROL.getControlValue()));
        }
    }

    public static String getStringValue(IValue value, int binaryEncoding) {
        String s = value.getStringValue();
        if (value.isBinary() && LdifUtils.mustEncode((String)s)) {
            byte[] binary = value.getBinaryValue();
            s = binaryEncoding == 1 ? LdifUtils.base64encode((byte[])binary) : (binaryEncoding == 2 ? LdifUtils.hexEncode((byte[])binary) : "BINARY");
        }
        return s;
    }

    public static Entry toLdapApiEntry(IEntry entry) throws LdapException {
        DefaultEntry ldapApiEntry = new DefaultEntry(entry.getDn());
        IAttribute[] iAttributeArray = entry.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute iAttribute = iAttributeArray[n2];
            IValue[] iValueArray = iAttribute.getValues();
            int n3 = iValueArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IValue value = iValueArray[n4];
                String attributeDescription = value.getAttribute().getDescription();
                if (value.isString()) {
                    ldapApiEntry.add(attributeDescription, new String[]{value.getStringValue()});
                } else {
                    ldapApiEntry.add(attributeDescription, (byte[][])new byte[][]{value.getBinaryValue()});
                }
                ++n4;
            }
            ++n2;
        }
        return ldapApiEntry;
    }

    public static Collection<Modification> toReplaceModifications(Entry entry) {
        Collection modifications = entry.getAttributes().stream().map(attribute -> new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute)).collect(Collectors.toList());
        return modifications;
    }
}

