/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.directory.api.ldap.model.exception.LdapLoopDetectedException;
import org.apache.directory.api.ldap.model.message.Referral;

public class ReferralsInfo {
    private LinkedList<Referral> referralsToProcess = new LinkedList();
    private Set<String> processedUrls = new HashSet<String>();
    private boolean throwExceptionOnLoop;

    public ReferralsInfo(boolean throwExceptionOnLoop) {
        this.throwExceptionOnLoop = throwExceptionOnLoop;
    }

    public void addReferral(Referral referral) {
        this.referralsToProcess.addLast(referral);
    }

    public Referral getNextReferral() throws LdapLoopDetectedException {
        this.handleAlreadyProcessedUrls();
        if (!this.referralsToProcess.isEmpty()) {
            Referral referral = this.referralsToProcess.removeFirst();
            this.processedUrls.addAll(referral.getLdapUrls());
            return referral;
        }
        return null;
    }

    public boolean hasMoreReferrals() throws LdapLoopDetectedException {
        this.handleAlreadyProcessedUrls();
        return !this.referralsToProcess.isEmpty();
    }

    private void handleAlreadyProcessedUrls() throws LdapLoopDetectedException {
        while (!this.referralsToProcess.isEmpty()) {
            Referral referral = this.referralsToProcess.getFirst();
            boolean alreadyProcessed = referral.getLdapUrls().stream().anyMatch(url -> this.processedUrls.contains(url));
            if (alreadyProcessed) {
                if (this.throwExceptionOnLoop) {
                    throw new LdapLoopDetectedException("Referral " + referral.getLdapUrls() + " already processed");
                }
                this.referralsToProcess.removeFirst();
                continue;
            }
            return;
        }
    }
}

