/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.jobs;

import java.util.List;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IConnectionListener;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;

public class CloseConnectionsRunnable
implements StudioConnectionBulkRunnableWithProgress {
    private Connection[] connections;

    public CloseConnectionsRunnable(Connection connection) {
        this(new Connection[]{connection});
    }

    public CloseConnectionsRunnable(Connection[] connections) {
        this.connections = connections;
    }

    public CloseConnectionsRunnable(List<Connection> connections) {
        this.connections = connections.toArray(new Connection[connections.size()]);
    }

    public String getName() {
        return this.connections.length == 1 ? Messages.jobs__close_connections_name_1 : Messages.jobs__close_connections_name_n;
    }

    public Object[] getLockedObjects() {
        return this.connections;
    }

    public String getErrorMessage() {
        return this.connections.length == 1 ? Messages.jobs__close_connections_error_1 : Messages.jobs__close_connections_error_n;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(" ", this.connections.length * 6 + 1);
        monitor.reportProgress(" ");
        Connection[] connectionArray = this.connections;
        int n = this.connections.length;
        int n2 = 0;
        while (n2 < n) {
            Connection connection = connectionArray[n2];
            if (connection.getConnectionWrapper().isConnected()) {
                monitor.setTaskName(Messages.bind((String)Messages.jobs__close_connections_task, (Object[])new String[]{connection.getName()}));
                monitor.worked(1);
                connection.getConnectionWrapper().unbind();
                connection.getConnectionWrapper().disconnect();
            }
            ++n2;
        }
    }

    @Override
    public void runNotification(StudioProgressMonitor monitor) {
        Connection connection;
        Connection[] connectionArray = this.connections;
        int n = this.connections.length;
        int n2 = 0;
        while (n2 < n) {
            connection = connectionArray[n2];
            if (!connection.getConnectionWrapper().isConnected()) {
                for (IConnectionListener listener : ConnectionCorePlugin.getDefault().getConnectionListeners()) {
                    listener.connectionClosed(connection, monitor);
                }
            }
            ++n2;
        }
        connectionArray = this.connections;
        n = this.connections.length;
        n2 = 0;
        while (n2 < n) {
            connection = connectionArray[n2];
            if (!connection.getConnectionWrapper().isConnected()) {
                ConnectionEventRegistry.fireConnectionClosed(connection, this);
            }
            ++n2;
        }
    }

    @Override
    public Connection[] getConnections() {
        return null;
    }
}

