/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs;

import java.util.HashMap;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.dialogs.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextDialog
extends Dialog {
    private static final String DIALOG_TITLE = Messages.getString("TextDialog.TextEditor");
    private String initialValue;
    private String returnValue;
    private static final int TOGGLE_BUTTON_ID = 9999;
    private HashMap<Integer, Button> buttons = new HashMap();
    private Text text;
    private int defaultTextStyle = 2818;
    GridData gd = new GridData();

    public TextDialog(Shell parentShell, String initialValue) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10 | 0x400);
        this.initialValue = initialValue;
        this.returnValue = null;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        return this.createButton(parent, id, label, defaultButton, 8);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton, int style) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, style);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextDialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.buttons.put(id, button);
        this.setButtonLayoutData(button);
        return button;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
        shell.setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/texteditor.gif"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 9999, Messages.getString("TextDialog.WrapLines"), false, 2);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (9999 == buttonId) {
            String currentValue = this.text.getText();
            Composite composite = this.text.getParent();
            this.text.dispose();
            this.createText(composite, currentValue, this.getButton(9999).getSelection());
            this.text.requestLayout();
        }
        super.buttonPressed(buttonId);
    }

    protected Button getButton(int id) {
        return this.buttons.get(id);
    }

    protected void okPressed() {
        this.returnValue = this.text.getText();
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createText(composite, this.initialValue, false);
        return composite;
    }

    protected void createText(Composite composite, String value, boolean wrap) {
        this.text = wrap ? new Text(composite, this.defaultTextStyle | 0x40) : new Text(composite, this.defaultTextStyle);
        this.text.setText(value);
        this.gd = new GridData(4, 4, true, true);
        this.gd.widthHint = this.convertHorizontalDLUsToPixels(600);
        this.gd.heightHint = this.convertHorizontalDLUsToPixels(300);
        this.text.setLayoutData((Object)this.gd);
        TextDialog.applyDialogFont((Control)composite);
    }

    public String getText() {
        return this.returnValue;
    }
}

