/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller.actions;

import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.actions.Messages;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditor;
import org.apache.directory.studio.schemaeditor.view.views.HierarchyView;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;

public class LinkWithEditorHierarchyViewAction
extends Action {
    private static final String LINK_WITH_EDITOR_HIERARCHY_VIEW_DS_KEY = String.valueOf(LinkWithEditorHierarchyViewAction.class.getName()) + ".dialogsettingkey";
    private HierarchyView view;
    private IPartListener2 editorListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(true);
            if (part instanceof ObjectClassEditor) {
                LinkWithEditorHierarchyViewAction.this.linkViewWithEditor((SchemaObject)((ObjectClassEditor)part).getOriginalObjectClass());
            } else if (part instanceof AttributeTypeEditor) {
                LinkWithEditorHierarchyViewAction.this.linkViewWithEditor((SchemaObject)((AttributeTypeEditor)part).getOriginalAttributeType());
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }
    };

    public LinkWithEditorHierarchyViewAction(HierarchyView view) {
        super(Messages.getString("LinkWithEditorHierarchyViewAction.LinkEditorAction"), 2);
        this.setToolTipText(Messages.getString("LinkWithEditorHierarchyViewAction.LinkEditorToolTip"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/link_with_editor.gif"));
        this.setEnabled(true);
        this.view = view;
        if (Activator.getDefault().getDialogSettings().get(LINK_WITH_EDITOR_HIERARCHY_VIEW_DS_KEY) == null) {
            Activator.getDefault().getDialogSettings().put(LINK_WITH_EDITOR_HIERARCHY_VIEW_DS_KEY, false);
        }
        this.setChecked(Activator.getDefault().getDialogSettings().getBoolean(LINK_WITH_EDITOR_HIERARCHY_VIEW_DS_KEY));
        if (this.isChecked()) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener(this.editorListener);
        }
    }

    public void run() {
        this.setChecked(this.isChecked());
        Activator.getDefault().getDialogSettings().put(LINK_WITH_EDITOR_HIERARCHY_VIEW_DS_KEY, this.isChecked());
        if (this.isChecked()) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener(this.editorListener);
            IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (activeEditor instanceof ObjectClassEditor) {
                this.linkViewWithEditor((SchemaObject)((ObjectClassEditor)activeEditor).getOriginalObjectClass());
            } else if (activeEditor instanceof AttributeTypeEditor) {
                this.linkViewWithEditor((SchemaObject)((AttributeTypeEditor)activeEditor).getOriginalAttributeType());
            }
        } else {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().removePartListener(this.editorListener);
        }
    }

    private void linkViewWithEditor(SchemaObject schemaElement) {
        if (schemaElement instanceof AttributeType) {
            this.view.setInput(schemaElement);
        } else if (schemaElement instanceof ObjectClass) {
            this.view.setInput(schemaElement);
        }
    }
}

