/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;

public abstract class Expression
extends AnnotatedNode {
    public static final Expression[] EMPTY_ARRAY = new Expression[0];
    private static final ClassNode NULL_TYPE = ClassHelper.make("null");
    private ClassNode type = NULL_TYPE;

    public ClassNode getType() {
        if (this.type == NULL_TYPE) {
            this.type = ClassHelper.dynamicType();
        }
        return this.type;
    }

    public void setType(ClassNode type) {
        this.type = type;
    }

    public abstract Expression transformExpression(ExpressionTransformer var1);

    protected List<Expression> transformExpressions(List<? extends Expression> expressions, ExpressionTransformer transformer) {
        ArrayList<Expression> list = new ArrayList<Expression>(expressions.size());
        for (Expression expression : expressions) {
            Expression expression2 = transformer.transform(expression);
            list.add(expression2);
        }
        return list;
    }

    protected <T extends Expression> List<T> transformExpressions(List<? extends Expression> expressions, ExpressionTransformer transformer, Class<T> targetType) {
        ArrayList<Expression> list = new ArrayList<Expression>(expressions.size());
        for (Expression expression : expressions) {
            Expression expression2 = transformer.transform(expression);
            if (!targetType.isInstance(expression2)) {
                throw new GroovyBugError("Transformed expression should have type " + targetType.getName() + " but has type " + expression2.getClass().getName());
            }
            list.add((Expression)targetType.cast(expression2));
        }
        return list;
    }
}

