/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.addresultfilenames;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.actions.addresultfilenames.Argument;
import org.apache.hop.workflow.engine.IWorkflowEngine;

@Action(id="ADD_RESULT_FILENAMES", name="i18n::ActionAddResultFilenames.Name", description="i18n::ActionAddResultFilenames.Description", image="AddResultFileNames.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionAddResultFilenames.keyword"}, documentationUrl="/workflow/actions/addresultfilenames.html")
public class ActionAddResultFilenames
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionAddResultFilenames.class;
    @HopMetadataProperty(key="arg_from_previous")
    private boolean argFromPrevious;
    @HopMetadataProperty(key="delete_all_before")
    private boolean deleteAllBefore;
    @HopMetadataProperty(key="include_subfolders")
    private boolean includeSubFolders;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<Argument> arguments;

    public ActionAddResultFilenames(String n) {
        super(n, "");
        this.arguments = new ArrayList<Argument>();
        this.argFromPrevious = false;
        this.deleteAllBefore = false;
        this.includeSubFolders = false;
    }

    public ActionAddResultFilenames() {
        this("");
    }

    public ActionAddResultFilenames(ActionAddResultFilenames other) {
        super(other.getName(), other.getDescription(), other.getPluginId());
        this.argFromPrevious = other.argFromPrevious;
        this.arguments = other.arguments;
        this.deleteAllBefore = other.deleteAllBefore;
        this.includeSubFolders = other.includeSubFolders;
    }

    public Object clone() {
        return new ActionAddResultFilenames(this);
    }

    public Result execute(Result result, int nr) throws HopException {
        List rows = result.getRows();
        int nrErrFiles = 0;
        result.setResult(true);
        if (this.deleteAllBefore) {
            int size = result.getResultFiles().size();
            if (this.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"ActionAddResultFilenames.log.FilesFound", (String[])new String[]{"" + size}));
            }
            result.getResultFiles().clear();
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionAddResultFilenames.log.DeletedFiles", (String[])new String[]{"" + size}));
            }
        }
        if (this.argFromPrevious && this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionAddResultFilenames.FoundPreviousRows", (String[])new String[]{String.valueOf(rows != null ? rows.size() : 0)}));
        }
        if (this.argFromPrevious && rows != null) {
            for (int iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped(); ++iteration) {
                RowMetaAndData resultRow = (RowMetaAndData)rows.get(iteration);
                String fileFolderPrevious = resultRow.getString(0, null);
                String fileMasksPrevious = resultRow.getString(1, null);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionAddResultFilenames.ProcessingRow", (String[])new String[]{fileFolderPrevious, fileMasksPrevious}));
                }
                if (this.processFile(fileFolderPrevious, fileMasksPrevious, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, result)) continue;
                ++nrErrFiles;
            }
        } else if (this.arguments != null) {
            for (int i = 0; i < this.arguments.size() && !this.parentWorkflow.isStopped(); ++i) {
                Argument argument = this.arguments.get(i);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionAddResultFilenames.ProcessingArg", (String[])new String[]{argument.getArgument(), argument.getMask()}));
                }
                if (this.processFile(argument.getArgument(), argument.getMask(), (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, result)) continue;
                ++nrErrFiles;
            }
        }
        if (nrErrFiles > 0) {
            result.setResult(false);
            result.setNrErrors((long)nrErrFiles);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processFile(String filename, String wildcard, IWorkflowEngine<WorkflowMeta> parentWorkflow, Result result) {
        boolean rcode = true;
        FileObject filefolder = null;
        String realFilefoldername = this.resolve(filename);
        String realwildcard = this.resolve(wildcard);
        try {
            filefolder = HopVfs.getFileObject((String)realFilefoldername);
            if (filefolder.exists()) {
                if (filefolder.getType() == FileType.FILE) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionAddResultFilenames.AddingFileToResult", (String[])new String[]{filefolder.toString()}));
                    }
                    ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)filefolder.toString()), parentWorkflow.getWorkflowName(), this.toString());
                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                } else {
                    FileObject[] list = filefolder.findFiles((FileSelector)new TextFileSelector(filefolder.toString(), realwildcard));
                    for (int i = 0; i < list.length && !parentWorkflow.isStopped(); ++i) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionAddResultFilenames.AddingFileToResult", (String[])new String[]{list[i].toString()}));
                        }
                        ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)list[i].toString()), parentWorkflow.getWorkflowName(), this.toString());
                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                    }
                }
            } else {
                if (this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ActionAddResultFilenames.FileCanNotbeFound", (String[])new String[]{realFilefoldername}));
                }
                rcode = false;
            }
        }
        catch (Exception e) {
            rcode = false;
            this.logError(BaseMessages.getString(PKG, (String)"ActionAddResultFilenames.CouldNotProcess", (String[])new String[]{realFilefoldername, e.getMessage()}), e);
        }
        finally {
            if (filefolder != null) {
                try {
                    filefolder.close();
                    filefolder = null;
                }
                catch (IOException iOException) {}
            }
        }
        return rcode;
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Utils.isEmpty((CharSequence)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public void setIncludeSubFolders(boolean includeSubFolders) {
        this.includeSubFolders = includeSubFolders;
    }

    public void setArgumentsPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    public void setDeleteAllBefore(boolean deleteallbefore) {
        this.deleteAllBefore = deleteallbefore;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        boolean res = ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileExistsValidator()});
        for (int i = 0; i < this.arguments.size(); ++i) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    public void setArgFromPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    public boolean isDeleteAllBefore() {
        return this.deleteAllBefore;
    }

    public boolean isIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<Argument> arguments) {
        this.arguments = arguments;
    }

    private class TextFileSelector
    implements FileSelector {
        String fileWildcard = null;
        String sourceFolder = null;

        public TextFileSelector(String sourcefolderin, String filewildcard) {
            if (!Utils.isEmpty((CharSequence)sourcefolderin)) {
                this.sourceFolder = sourcefolderin;
            }
            if (!Utils.isEmpty((CharSequence)filewildcard)) {
                this.fileWildcard = filewildcard;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean returncode = false;
            try {
                if (!info.getFile().toString().equals(this.sourceFolder)) {
                    String shortFilename = info.getFile().getName().getBaseName();
                    if ((info.getFile().getParent().equals(info.getBaseFolder()) || !info.getFile().getParent().equals(info.getBaseFolder()) && ActionAddResultFilenames.this.includeSubFolders) && (info.getFile().getType() == FileType.FILE && this.fileWildcard == null || info.getFile().getType() == FileType.FILE && this.fileWildcard != null && ActionAddResultFilenames.this.GetFileWildcard(shortFilename, this.fileWildcard))) {
                        returncode = true;
                    }
                }
            }
            catch (Exception e) {
                ActionAddResultFilenames.this.logError("Error while finding files ... in [" + info.getFile().toString() + "]. Exception :" + e.getMessage());
                returncode = false;
            }
            return returncode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }
}

