/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.azure;

import com.azure.storage.file.datalake.DataLakeServiceClient;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.hop.vfs.azure.AzureFileName;
import org.apache.hop.vfs.azure.AzureFileObject;
import org.apache.hop.vfs.azure.AzureFileProvider;

public class AzureFileSystem
extends AbstractFileSystem {
    private final DataLakeServiceClient serviceClient;
    private final String fsName;
    private final String account;

    public AzureFileSystem(AzureFileName fileName, DataLakeServiceClient serviceClient, String fsName, FileSystemOptions fileSystemOptions, String account) throws FileSystemException {
        super((FileName)fileName, null, fileSystemOptions);
        this.serviceClient = serviceClient;
        this.fsName = fsName;
        this.account = account;
    }

    protected void addCapabilities(Collection<Capability> capabilities) {
        capabilities.addAll(AzureFileProvider.capabilities);
    }

    protected FileObject createFile(AbstractFileName name) throws Exception {
        return new AzureFileObject(name, this, this.serviceClient);
    }

    public String getFilesystemName() {
        return this.fsName;
    }

    public String getAccount() {
        return this.account;
    }
}

