/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.construction.ReplacementOutputs;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PrimitiveCreate<@UnknownKeyFor T>
extends PTransform<PBegin, PCollection<T>> {
    private final @UnknownKeyFor @NonNull @Initialized Create.Values<T> transform;
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;

    private PrimitiveCreate(@UnknownKeyFor @NonNull @Initialized Create.Values<T> transform, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        this.transform = transform;
        this.coder = coder;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
        return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.BOUNDED, this.coder);
    }

    public @UnknownKeyFor @NonNull @Initialized Iterable<T> getElements() {
        return this.transform.getElements();
    }

    public static class Factory<@UnknownKeyFor T>
    implements PTransformOverrideFactory<PBegin, PCollection<T>, Create.Values<T>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized Create.Values<T>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of(transform.getPipeline().begin(), new PrimitiveCreate(transform.getTransform(), ((PCollection)Iterables.getOnlyElement(transform.getOutputs().values())).getCoder()));
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollection<T> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }
}

