/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.xml.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import lombok.Generated;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.engine.IWorkflowEngine;

@Action(id="XSLT", name="i18n::XSLT.Name", description="i18n::XSLT.Description", image="XSLT.svg", categoryDescription="i18n::XSLT.Category", keywords={"i18n::Xslt.keyword"}, documentationUrl="/workflow/actions/xslt.html")
public class Xslt
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = Xslt.class;
    public static final String FACTORY_JAXP = "JAXP";
    public static final String FACTORY_SAXON = "SAXON";
    public static final String CONST_ACTION_XSLT_OUPUT_FILE_EXISTS_1_LABEL = "ActionXSLT.OuputFileExists1.Label";
    public static final String CONST_ACTION_XSLT_OUPUT_FILE_EXISTS_2_LABEL = "ActionXSLT.OuputFileExists2.Label";
    @HopMetadataProperty
    private String xmlfilename = null;
    @HopMetadataProperty
    private String xslfilename = null;
    @HopMetadataProperty
    private String outputfilename = null;
    @HopMetadataProperty
    public int ifFileExists = 1;
    private boolean addfiletoresult = false;
    private String xsltfactory = "JAXP";
    private boolean filenamesfromprevious = false;
    private String[] outputPropertyName;
    private String[] outputPropertyValue;
    private String[] parameterName;
    private String[] parameterField;
    private int nrParams;
    private String[] nameOfParams;
    private String[] valueOfParams;
    private boolean useParameters;
    private Properties outputProperties;
    private boolean setOutputProperties;

    public Xslt(String n) {
        super(n, "");
        int i;
        int nrparams = 0;
        int nroutputproperties = 0;
        this.allocate(nrparams, nroutputproperties);
        for (i = 0; i < nrparams; ++i) {
            this.parameterField[i] = "param" + i;
            this.parameterName[i] = "param";
        }
        for (i = 0; i < nroutputproperties; ++i) {
            this.outputPropertyName[i] = "outputprop" + i;
            this.outputPropertyValue[i] = "outputprop";
        }
    }

    public void allocate(int nrParameters, int outputProps) {
        this.parameterName = new String[nrParameters];
        this.parameterField = new String[nrParameters];
        this.outputPropertyName = new String[outputProps];
        this.outputPropertyValue = new String[outputProps];
    }

    public Xslt() {
        this("");
    }

    public Object clone() {
        int i;
        Xslt je = (Xslt)super.clone();
        int nrparams = this.parameterName.length;
        int nroutputprops = this.outputPropertyName.length;
        je.allocate(nrparams, nroutputprops);
        for (i = 0; i < nrparams; ++i) {
            je.parameterName[i] = this.parameterName[i];
            je.parameterField[i] = this.parameterField[i];
        }
        for (i = 0; i < nroutputprops; ++i) {
            je.outputPropertyName[i] = this.outputPropertyName[i];
            je.outputPropertyValue[i] = this.outputPropertyValue[i];
        }
        return je;
    }

    public String getXSLTFactory() {
        return this.xsltfactory;
    }

    public void setXSLTFactory(String xsltfactoryin) {
        this.xsltfactory = xsltfactoryin;
    }

    public void setFilenamesFromPrevious(boolean filenamesfromprevious) {
        this.filenamesfromprevious = filenamesfromprevious;
    }

    public String getRealxmlfilename() {
        return this.resolve(this.getXmlfilename());
    }

    public String getoutputfilename() {
        return this.resolve(this.getOutputfilename());
    }

    public String getOutputfilename() {
        return this.outputfilename;
    }

    public String getRealxslfilename() {
        return this.resolve(this.getXslfilename());
    }

    public boolean isFilenamesFromPrevious() {
        return this.filenamesfromprevious;
    }

    public Result execute(Result previousResult, int nr) throws HopException {
        int i;
        int nrOutputProps;
        Result result = previousResult;
        int nrErrors = 0;
        int nrSuccess = 0;
        int n = nrOutputProps = this.getOutputPropertyName() == null ? 0 : this.getOutputPropertyName().length;
        if (nrOutputProps > 0) {
            this.outputProperties = new Properties();
            for (i = 0; i < nrOutputProps; ++i) {
                this.outputProperties.put(this.getOutputPropertyName()[i], this.resolve(this.getOutputPropertyValue()[i]));
            }
            this.setOutputProperties = true;
        }
        int n2 = this.nrParams = this.getParameterField() == null ? 0 : this.getParameterField().length;
        if (this.nrParams > 0) {
            this.nameOfParams = new String[this.nrParams];
            this.valueOfParams = new String[this.nrParams];
            for (i = 0; i < this.nrParams; ++i) {
                String name = this.resolve(this.getParameterName()[i]);
                String value = this.resolve(this.getParameterField()[i]);
                if (Utils.isEmpty((CharSequence)value)) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ParameterFieldMissing", (Object[])new Object[]{name, i}));
                }
                this.nameOfParams[i] = name;
                this.valueOfParams[i] = value;
            }
            this.useParameters = true;
        }
        List rows = result.getRows();
        if (this.isFilenamesFromPrevious() && this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionXSLT.Log.ArgFromPrevious.Found", (String[])new String[]{"" + (rows != null ? rows.size() : 0)}));
        }
        if (this.isFilenamesFromPrevious() && rows != null) {
            RowMetaAndData resultRow = null;
            for (int iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped(); ++iteration) {
                resultRow = (RowMetaAndData)rows.get(iteration);
                String xmlfilenamePrevious = resultRow.getString(0, null);
                String xslfilenamePrevious = resultRow.getString(1, null);
                String ouputfilenamePrevious = resultRow.getString(2, null);
                if (!(Utils.isEmpty((CharSequence)xmlfilenamePrevious) || Utils.isEmpty((CharSequence)xslfilenamePrevious) || Utils.isEmpty((CharSequence)ouputfilenamePrevious))) {
                    if (this.processOneXMLFile(xmlfilenamePrevious, xslfilenamePrevious, ouputfilenamePrevious, result, this.parentWorkflow)) {
                        ++nrSuccess;
                        continue;
                    }
                    ++nrErrors;
                    continue;
                }
                this.logError(BaseMessages.getString(PKG, (String)"ActionXSLT.AllFilesNotNull.Label", (String[])new String[0]));
                ++nrErrors;
            }
        } else {
            String realxmlfilename = this.getRealxmlfilename();
            String realxslfilename = this.getRealxslfilename();
            String realoutputfilename = this.getoutputfilename();
            if (!(Utils.isEmpty((CharSequence)realxmlfilename) || Utils.isEmpty((CharSequence)realxslfilename) || Utils.isEmpty((CharSequence)realoutputfilename))) {
                if (this.processOneXMLFile(realxmlfilename, realxslfilename, realoutputfilename, result, this.parentWorkflow)) {
                    ++nrSuccess;
                } else {
                    ++nrErrors;
                }
            } else {
                this.logError(BaseMessages.getString(PKG, (String)"ActionXSLT.AllFilesNotNull.Label", (String[])new String[0]));
                ++nrErrors;
            }
        }
        result.setResult(nrErrors == 0);
        result.setNrErrors((long)nrErrors);
        result.setNrLinesWritten((long)nrSuccess);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processOneXMLFile(String xmlfilename, String xslfilename, String outputfilename, Result result, IWorkflowEngine parentWorkflow) {
        boolean retval;
        block51: {
            retval = false;
            FileObject xmlfile = null;
            FileObject xslfile = null;
            FileObject outputfile = null;
            try {
                xmlfile = HopVfs.getFileObject((String)xmlfilename);
                xslfile = HopVfs.getFileObject((String)xslfilename);
                outputfile = HopVfs.getFileObject((String)outputfilename);
                if (xmlfile.exists() && xslfile.exists()) {
                    if (outputfile.exists() && this.ifFileExists == 2) {
                        this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_XSLT_OUPUT_FILE_EXISTS_1_LABEL, (String[])new String[0]) + (String)outputfilename + BaseMessages.getString(PKG, (String)CONST_ACTION_XSLT_OUPUT_FILE_EXISTS_2_LABEL, (String[])new String[0]));
                        boolean bl = retval;
                        return bl;
                    }
                    if (outputfile.exists() && this.ifFileExists == 1) {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_XSLT_OUPUT_FILE_EXISTS_1_LABEL, (String[])new String[0]) + (String)outputfilename + BaseMessages.getString(PKG, (String)CONST_ACTION_XSLT_OUPUT_FILE_EXISTS_2_LABEL, (String[])new String[0]));
                        }
                        boolean bl = retval = true;
                        return bl;
                    }
                    if (outputfile.exists() && this.ifFileExists == 0) {
                        String wildcard = ((String)outputfilename).substring(((String)outputfilename).length() - 4, ((String)outputfilename).length());
                        outputfilename = wildcard.substring(0, 1).equals(".") ? ((String)outputfilename).substring(0, ((String)outputfilename).length() - 4) + "_" + StringUtil.getFormattedDateTimeNow((boolean)true) + wildcard : (String)outputfilename + "_" + StringUtil.getFormattedDateTimeNow((boolean)true);
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_XSLT_OUPUT_FILE_EXISTS_1_LABEL, (String[])new String[0]) + (String)outputfilename + BaseMessages.getString(PKG, (String)CONST_ACTION_XSLT_OUPUT_FILE_EXISTS_2_LABEL, (String[])new String[0]));
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionXSLT.OuputFileNameChange1.Label", (String[])new String[0]) + (String)outputfilename + BaseMessages.getString(PKG, (String)"ActionXSLT.OuputFileNameChange2.Label", (String[])new String[0]));
                        }
                    }
                    TransformerFactory factory = TransformerFactory.newInstance();
                    if (this.xsltfactory.equals(FACTORY_SAXON)) {
                        factory = new TransformerFactoryImpl();
                    }
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionXSL.Log.TransformerFactoryInfos", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"ActionXSL.Log.TransformerFactory", (String[])new String[]{factory.getClass().getName()})});
                    }
                    InputStream xslInputStream = HopVfs.getInputStream((FileObject)xslfile);
                    InputStream xmlInputStream = HopVfs.getInputStream((FileObject)xmlfile);
                    OutputStream os = null;
                    try {
                        Templates template = factory.newTemplates(new StreamSource(xslInputStream));
                        Transformer xformer = template.newTransformer();
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionXSL.Log.TransformerClassInfos", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"ActionXSL.Log.TransformerClass", (String[])new String[]{xformer.getClass().getName()})});
                        }
                        if (this.setOutputProperties) {
                            xformer.setOutputProperties(this.outputProperties);
                        }
                        if (this.useParameters) {
                            for (int i = 0; i < this.nrParams; ++i) {
                                xformer.setParameter(this.nameOfParams[i], this.valueOfParams[i]);
                            }
                        }
                        StreamSource source = new StreamSource(xmlInputStream);
                        os = HopVfs.getOutputStream((FileObject)outputfile, (boolean)false);
                        StreamResult resultat = new StreamResult(os);
                        xformer.transform(source, resultat);
                        if (this.isAddfiletoresult()) {
                            ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)outputfilename), parentWorkflow.getWorkflowName(), this.toString());
                            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        }
                        retval = true;
                        break block51;
                    }
                    finally {
                        try {
                            xslInputStream.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            xmlInputStream.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (!xmlfile.exists()) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionXSLT.FileDoesNotExist1.Label", (String[])new String[0]) + xmlfilename + BaseMessages.getString(PKG, (String)"ActionXSLT.FileDoesNotExist2.Label", (String[])new String[0]));
                }
                if (!xslfile.exists()) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionXSLT.FileDoesNotExist1.Label", (String[])new String[0]) + xmlfilename + BaseMessages.getString(PKG, (String)"ActionXSLT.FileDoesNotExist2.Label", (String[])new String[0]));
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionXSLT.ErrorXLST.Label", (String[])new String[0]) + BaseMessages.getString(PKG, (String)"ActionXSLT.ErrorXLSTXML1.Label", (String[])new String[0]) + xmlfilename + BaseMessages.getString(PKG, (String)"ActionXSLT.ErrorXLSTXML2.Label", (String[])new String[0]) + BaseMessages.getString(PKG, (String)"ActionXSLT.ErrorXLSTXSL1.Label", (String[])new String[0]) + xslfilename + BaseMessages.getString(PKG, (String)"ActionXSLT.ErrorXLSTXSL2.Label", (String[])new String[0]) + e.getMessage());
            }
            finally {
                try {
                    if (xmlfile != null) {
                        xmlfile.close();
                    }
                    if (xslfile != null) {
                        xslfile.close();
                    }
                    if (outputfile != null) {
                        outputfile.close();
                    }
                }
                catch (IOException e) {
                    this.logError("Unable to close file", e);
                }
            }
        }
        return retval;
    }

    public boolean isEvaluation() {
        return true;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.xslfilename) && !Utils.isEmpty((CharSequence)this.xmlfilename)) {
            String realXmlFileName = variables.resolve(this.xmlfilename);
            String realXslFileName = variables.resolve(this.xslfilename);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realXmlFileName, ResourceEntry.ResourceType.FILE));
            reference.getEntries().add(new ResourceEntry(realXslFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta jobMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "xmlFilename", remarks, ctx);
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "xslFilename", remarks, ctx);
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "outputFilename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }

    public String[] getOutputPropertyName() {
        return this.outputPropertyName;
    }

    public void setOutputPropertyName(String[] argumentDirection) {
        this.outputPropertyName = argumentDirection;
    }

    public String[] getOutputPropertyValue() {
        return this.outputPropertyValue;
    }

    public void setOutputPropertyValue(String[] argumentDirection) {
        this.outputPropertyValue = argumentDirection;
    }

    public String[] getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String[] argumentDirection) {
        this.parameterName = argumentDirection;
    }

    public String[] getParameterField() {
        return this.parameterField;
    }

    @Generated
    public String getXmlfilename() {
        return this.xmlfilename;
    }

    @Generated
    public String getXslfilename() {
        return this.xslfilename;
    }

    @Generated
    public int getIfFileExists() {
        return this.ifFileExists;
    }

    @Generated
    public boolean isAddfiletoresult() {
        return this.addfiletoresult;
    }

    @Generated
    public int getNrParams() {
        return this.nrParams;
    }

    @Generated
    public String[] getNameOfParams() {
        return this.nameOfParams;
    }

    @Generated
    public String[] getValueOfParams() {
        return this.valueOfParams;
    }

    @Generated
    public boolean isUseParameters() {
        return this.useParameters;
    }

    @Generated
    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    @Generated
    public boolean isSetOutputProperties() {
        return this.setOutputProperties;
    }

    @Generated
    public void setXmlfilename(String xmlfilename) {
        this.xmlfilename = xmlfilename;
    }

    @Generated
    public void setXslfilename(String xslfilename) {
        this.xslfilename = xslfilename;
    }

    @Generated
    public void setOutputfilename(String outputfilename) {
        this.outputfilename = outputfilename;
    }

    @Generated
    public void setIfFileExists(int ifFileExists) {
        this.ifFileExists = ifFileExists;
    }

    @Generated
    public void setAddfiletoresult(boolean addfiletoresult) {
        this.addfiletoresult = addfiletoresult;
    }

    @Generated
    public void setParameterField(String[] parameterField) {
        this.parameterField = parameterField;
    }

    @Generated
    public void setNrParams(int nrParams) {
        this.nrParams = nrParams;
    }

    @Generated
    public void setNameOfParams(String[] nameOfParams) {
        this.nameOfParams = nameOfParams;
    }

    @Generated
    public void setValueOfParams(String[] valueOfParams) {
        this.valueOfParams = valueOfParams;
    }

    @Generated
    public void setUseParameters(boolean useParameters) {
        this.useParameters = useParameters;
    }

    @Generated
    public void setOutputProperties(Properties outputProperties) {
        this.outputProperties = outputProperties;
    }

    @Generated
    public void setSetOutputProperties(boolean setOutputProperties) {
        this.setOutputProperties = setOutputProperties;
    }
}

