/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.loadfileinput;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.loadfileinput.LoadFileInputData;
import org.apache.hop.pipeline.transforms.loadfileinput.LoadFileInputField;
import org.apache.hop.pipeline.transforms.loadfileinput.LoadFileInputMeta;

public class LoadFileInput
extends BaseTransform<LoadFileInputMeta, LoadFileInputData> {
    private static final Class<?> PKG = LoadFileInputMeta.class;

    public LoadFileInput(TransformMeta transformMeta, LoadFileInputMeta meta, LoadFileInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private void addFileToResultFilesName(FileObject file) throws Exception {
        if (((LoadFileInputMeta)this.meta).getAddResultFile()) {
            ResultFile resultFile = new ResultFile(0, file, this.getPipelineMeta().getName(), this.getTransformName());
            resultFile.setComment("File was read by a LoadFileInput transform");
            this.addResultFile(resultFile);
        }
    }

    boolean openNextFile() {
        try {
            if (((LoadFileInputMeta)this.meta).getFileInFields()) {
                ((LoadFileInputData)this.data).readrow = this.getRow();
                if (((LoadFileInputData)this.data).readrow == null) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    return false;
                }
                if (this.first) {
                    this.first = false;
                    ((LoadFileInputData)this.data).inputRowMeta = this.getInputRowMeta();
                    ((LoadFileInputData)this.data).outputRowMeta = ((LoadFileInputData)this.data).inputRowMeta.clone();
                    ((LoadFileInputMeta)this.meta).getFields(((LoadFileInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    ((LoadFileInputData)this.data).convertRowMeta = ((LoadFileInputData)this.data).outputRowMeta.cloneToType(2);
                    if (((LoadFileInputMeta)this.meta).getFileInFields()) {
                        if (Utils.isEmpty((CharSequence)((LoadFileInputMeta)this.meta).getDynamicFilenameField())) {
                            this.logError(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.NoField", (String[])new String[0]));
                            throw new HopException(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.NoField", (String[])new String[0]));
                        }
                        if (((LoadFileInputData)this.data).indexOfFilenameField < 0) {
                            ((LoadFileInputData)this.data).indexOfFilenameField = ((LoadFileInputData)this.data).inputRowMeta.indexOfValue(((LoadFileInputMeta)this.meta).getDynamicFilenameField());
                            if (((LoadFileInputData)this.data).indexOfFilenameField < 0) {
                                this.logError(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.ErrorFindingField", (String[])new String[0]) + "[" + ((LoadFileInputMeta)this.meta).getDynamicFilenameField() + "]");
                                throw new HopException(BaseMessages.getString(PKG, (String)"LoadFileInput.Exception.CouldnotFindField", (String[])new String[]{((LoadFileInputMeta)this.meta).getDynamicFilenameField()}));
                            }
                        }
                        ((LoadFileInputData)this.data).totalpreviousfields = ((LoadFileInputData)this.data).inputRowMeta.size();
                    }
                }
                String fieldvalue = ((LoadFileInputData)this.data).inputRowMeta.getString(((LoadFileInputData)this.data).readrow, ((LoadFileInputData)this.data).indexOfFilenameField);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.Stream", (String[])new String[]{((LoadFileInputMeta)this.meta).getDynamicFilenameField(), fieldvalue}));
                }
                try {
                    ((LoadFileInputData)this.data).file = HopVfs.getFileObject((String)fieldvalue, (IVariables)this.variables);
                }
                catch (Exception e) {
                    throw new HopException((Throwable)e);
                }
            } else {
                if (((LoadFileInputData)this.data).filenr >= ((LoadFileInputData)this.data).files.nrOfFiles()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    return false;
                }
                ((LoadFileInputData)this.data).last_file = ((LoadFileInputData)this.data).filenr == ((LoadFileInputData)this.data).files.nrOfFiles() - 1;
                ((LoadFileInputData)this.data).file = ((LoadFileInputData)this.data).files.getFile(((LoadFileInputData)this.data).filenr);
            }
            if (((LoadFileInputMeta)this.meta).isIgnoreMissingPath() && !((LoadFileInputData)this.data).file.exists()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"LoadFileInput.Error.FileNotExists", (String[])new String[]{String.valueOf(((LoadFileInputData)this.data).file.getName())}));
                return this.openNextFile();
            }
            ((LoadFileInputData)this.data).fileSize = ((LoadFileInputData)this.data).file.getContent().getSize();
            ++((LoadFileInputData)this.data).filenr;
            if (((LoadFileInputMeta)this.meta).isIgnoreEmptyFile() && ((LoadFileInputData)this.data).fileSize == 0L) {
                this.logError(BaseMessages.getString(PKG, (String)"LoadFileInput.Error.FileSizeZero", (String[])new String[]{String.valueOf(((LoadFileInputData)this.data).file.getName())}));
                return this.openNextFile();
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.OpeningFile", (String[])new String[]{((LoadFileInputData)this.data).file.toString()}));
            }
            ((LoadFileInputData)this.data).filename = HopVfs.getFilename((FileObject)((LoadFileInputData)this.data).file);
            if (((LoadFileInputMeta)this.meta).getShortFileNameField() != null && ((LoadFileInputMeta)this.meta).getShortFileNameField().length() > 0) {
                ((LoadFileInputData)this.data).shortFilename = ((LoadFileInputData)this.data).file.getName().getBaseName();
            }
            if (((LoadFileInputMeta)this.meta).getPathField() != null && ((LoadFileInputMeta)this.meta).getPathField().length() > 0) {
                ((LoadFileInputData)this.data).path = HopVfs.getFilename((FileObject)((LoadFileInputData)this.data).file.getParent());
            }
            if (((LoadFileInputMeta)this.meta).isHiddenField() != null && ((LoadFileInputMeta)this.meta).isHiddenField().length() > 0) {
                ((LoadFileInputData)this.data).hidden = ((LoadFileInputData)this.data).file.isHidden();
            }
            if (((LoadFileInputMeta)this.meta).getExtensionField() != null && ((LoadFileInputMeta)this.meta).getExtensionField().length() > 0) {
                ((LoadFileInputData)this.data).extension = ((LoadFileInputData)this.data).file.getName().getExtension();
            }
            if (((LoadFileInputMeta)this.meta).getLastModificationDateField() != null && ((LoadFileInputMeta)this.meta).getLastModificationDateField().length() > 0) {
                ((LoadFileInputData)this.data).lastModificationDateTime = new Date(((LoadFileInputData)this.data).file.getContent().getLastModifiedTime());
            }
            if (((LoadFileInputMeta)this.meta).getUriField() != null && ((LoadFileInputMeta)this.meta).getUriField().length() > 0) {
                ((LoadFileInputData)this.data).uriName = ((LoadFileInputData)this.data).file.getName().getURI();
            }
            if (((LoadFileInputMeta)this.meta).getRootUriField() != null && ((LoadFileInputMeta)this.meta).getRootUriField().length() > 0) {
                ((LoadFileInputData)this.data).rootUriName = ((LoadFileInputData)this.data).file.getName().getRootURI();
            }
            this.getFileContent();
            this.addFileToResultFilesName(((LoadFileInputData)this.data).file);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.FileOpened", (String[])new String[]{((LoadFileInputData)this.data).file.toString()}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.UnableToOpenFile", (String[])new String[]{"" + ((LoadFileInputData)this.data).filenr, ((LoadFileInputData)this.data).file.toString(), e.toString()}));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    public boolean processRow() throws HopException {
        try {
            Object[] outputRowData = this.getOneRow();
            if (outputRowData == null) {
                this.setOutputDone();
                return false;
            }
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.ReadRow", (String[])new String[]{((LoadFileInputData)this.data).outputRowMeta.getString(outputRowData)}));
            }
            this.putRow(((LoadFileInputData)this.data).outputRowMeta, outputRowData);
            if (((LoadFileInputMeta)this.meta).getRowLimit() > 0L && ((LoadFileInputData)this.data).rownr > ((LoadFileInputMeta)this.meta).getRowLimit()) {
                this.setOutputDone();
                return false;
            }
        }
        catch (HopException e) {
            this.logError(BaseMessages.getString(PKG, (String)"LoadFileInput.ErrorInTransformRunning", (String[])new String[]{e.getMessage()}));
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    void getFileContent() throws HopException {
        try {
            ((LoadFileInputData)this.data).filecontent = LoadFileInput.getFileBinaryContent(((LoadFileInputData)this.data).file.toString(), this.variables);
        }
        catch (OutOfMemoryError o) {
            this.logError("There is no enaugh memory to load the content of the file [" + String.valueOf(((LoadFileInputData)this.data).file.getName()) + "]");
            throw new HopException((Throwable)o);
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public static byte[] getFileBinaryContent(String vfsFilename, IVariables variables) throws HopException {
        InputStream inputStream = null;
        byte[] retval = null;
        try {
            inputStream = HopVfs.getInputStream((String)vfsFilename, (IVariables)variables);
            retval = IOUtils.toByteArray((InputStream)new BufferedInputStream(inputStream));
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"LoadFileInput.Error.GettingFileContent", (String[])new String[]{vfsFilename, e.toString()}));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return retval;
    }

    private void handleMissingFiles() throws HopException {
        List nonExistantFiles = ((LoadFileInputData)this.data).files.getNonExistentFiles();
        if (!nonExistantFiles.isEmpty()) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.logError(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"LoadFileInput.Log.RequiredFiles", (String[])new String[]{message})});
            throw new HopException(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.RequiredFilesMissing", (String[])new String[]{message}));
        }
        List nonAccessibleFiles = ((LoadFileInputData)this.data).files.getNonAccessibleFiles();
        if (!nonAccessibleFiles.isEmpty()) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.logError(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"LoadFileInput.Log.RequiredNotAccessibleFiles", (String[])new String[]{message})});
            throw new HopException(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.RequiredNotAccessibleFilesMissing", (String[])new String[]{message}));
        }
    }

    private Object[] buildEmptyRow() {
        return RowDataUtil.allocateRowData((int)((LoadFileInputData)this.data).outputRowMeta.size());
    }

    Object[] getOneRow() throws HopException {
        if (!this.openNextFile()) {
            return null;
        }
        Object[] outputRowData = this.buildEmptyRow();
        try {
            if (((LoadFileInputMeta)this.meta).getFileInFields()) {
                outputRowData = this.copyOrCloneArrayFromLoadFile(outputRowData, ((LoadFileInputData)this.data).readrow);
            }
            for (int i = 0; i < ((LoadFileInputData)this.data).nrInputFields; ++i) {
                LoadFileInputField loadFileInputField = ((LoadFileInputMeta)this.meta).getInputFields()[i];
                Object o = null;
                int indexField = ((LoadFileInputData)this.data).totalpreviousfields + i;
                IValueMeta targetValueMeta = ((LoadFileInputData)this.data).outputRowMeta.getValueMeta(indexField);
                IValueMeta sourceValueMeta = ((LoadFileInputData)this.data).convertRowMeta.getValueMeta(indexField);
                switch (loadFileInputField.getElementType()) {
                    case 0: {
                        switch (loadFileInputField.getTrimType()) {
                            case 1: {
                                if (((LoadFileInputMeta)this.meta).getEncoding() != null) {
                                    ((LoadFileInputData)this.data).filecontent = Const.ltrim((String)new String(((LoadFileInputData)this.data).filecontent, ((LoadFileInputMeta)this.meta).getEncoding())).getBytes();
                                    break;
                                }
                                ((LoadFileInputData)this.data).filecontent = Const.ltrim((String)new String(((LoadFileInputData)this.data).filecontent)).getBytes();
                                break;
                            }
                            case 2: {
                                if (((LoadFileInputMeta)this.meta).getEncoding() != null) {
                                    ((LoadFileInputData)this.data).filecontent = Const.rtrim((String)new String(((LoadFileInputData)this.data).filecontent, ((LoadFileInputMeta)this.meta).getEncoding())).getBytes();
                                    break;
                                }
                                ((LoadFileInputData)this.data).filecontent = Const.rtrim((String)new String(((LoadFileInputData)this.data).filecontent)).getBytes();
                                break;
                            }
                            case 3: {
                                if (((LoadFileInputMeta)this.meta).getEncoding() != null) {
                                    ((LoadFileInputData)this.data).filecontent = Const.trim((String)new String(((LoadFileInputData)this.data).filecontent, ((LoadFileInputMeta)this.meta).getEncoding())).getBytes();
                                    break;
                                }
                                ((LoadFileInputData)this.data).filecontent = Const.trim((String)new String(((LoadFileInputData)this.data).filecontent)).getBytes();
                                break;
                            }
                        }
                        if (targetValueMeta.getType() != 8) {
                            if (((LoadFileInputMeta)this.meta).getEncoding() != null) {
                                o = new String(((LoadFileInputData)this.data).filecontent, ((LoadFileInputMeta)this.meta).getEncoding());
                                break;
                            }
                            o = new String(((LoadFileInputData)this.data).filecontent);
                            break;
                        }
                        o = ((LoadFileInputData)this.data).filecontent;
                        break;
                    }
                    case 1: {
                        o = String.valueOf(((LoadFileInputData)this.data).fileSize);
                        break;
                    }
                }
                outputRowData[indexField] = targetValueMeta.getType() == 8 ? o : targetValueMeta.convertData(sourceValueMeta, o);
                if (!loadFileInputField.isRepeated() || ((LoadFileInputData)this.data).previousRow == null || o != null) continue;
                outputRowData[indexField] = ((LoadFileInputData)this.data).previousRow[indexField];
            }
            int rowIndex = ((LoadFileInputData)this.data).totalpreviousfields + ((LoadFileInputData)this.data).nrInputFields;
            if (((LoadFileInputMeta)this.meta).getIncludeFilename() && ((LoadFileInputMeta)this.meta).getFilenameField() != null && ((LoadFileInputMeta)this.meta).getFilenameField().length() > 0) {
                outputRowData[rowIndex++] = ((LoadFileInputData)this.data).filename;
            }
            if (((LoadFileInputMeta)this.meta).getIncludeRowNumber() && ((LoadFileInputMeta)this.meta).getRowNumberField() != null && ((LoadFileInputMeta)this.meta).getRowNumberField().length() > 0) {
                outputRowData[rowIndex++] = ((LoadFileInputData)this.data).rownr;
            }
            if (((LoadFileInputMeta)this.meta).getShortFileNameField() != null && ((LoadFileInputMeta)this.meta).getShortFileNameField().length() > 0) {
                outputRowData[rowIndex++] = ((LoadFileInputData)this.data).shortFilename;
            }
            if (((LoadFileInputMeta)this.meta).getExtensionField() != null && ((LoadFileInputMeta)this.meta).getExtensionField().length() > 0) {
                outputRowData[rowIndex++] = ((LoadFileInputData)this.data).extension;
            }
            if (((LoadFileInputMeta)this.meta).getPathField() != null && ((LoadFileInputMeta)this.meta).getPathField().length() > 0) {
                outputRowData[rowIndex++] = ((LoadFileInputData)this.data).path;
            }
            if (((LoadFileInputMeta)this.meta).isHiddenField() != null && ((LoadFileInputMeta)this.meta).isHiddenField().length() > 0) {
                outputRowData[rowIndex++] = ((LoadFileInputData)this.data).hidden;
            }
            if (((LoadFileInputMeta)this.meta).getLastModificationDateField() != null && ((LoadFileInputMeta)this.meta).getLastModificationDateField().length() > 0) {
                outputRowData[rowIndex++] = ((LoadFileInputData)this.data).lastModificationDateTime;
            }
            if (((LoadFileInputMeta)this.meta).getUriField() != null && ((LoadFileInputMeta)this.meta).getUriField().length() > 0) {
                outputRowData[rowIndex++] = ((LoadFileInputData)this.data).uriName;
            }
            if (((LoadFileInputMeta)this.meta).getRootUriField() != null && ((LoadFileInputMeta)this.meta).getRootUriField().length() > 0) {
                outputRowData[rowIndex++] = ((LoadFileInputData)this.data).rootUriName;
            }
            IRowMeta irow = this.getInputRowMeta();
            ((LoadFileInputData)this.data).previousRow = irow == null ? outputRowData : irow.cloneRow(outputRowData);
            this.incrementLinesInput();
            ++((LoadFileInputData)this.data).rownr;
        }
        catch (Exception e) {
            throw new HopException("Error during processing a row", (Throwable)e);
        }
        return outputRowData;
    }

    public boolean init() {
        if (super.init()) {
            if (!((LoadFileInputMeta)this.meta).getFileInFields()) {
                try {
                    ((LoadFileInputData)this.data).files = ((LoadFileInputMeta)this.meta).getFiles((IVariables)this);
                    this.handleMissingFiles();
                    ((LoadFileInputData)this.data).outputRowMeta = new RowMeta();
                    ((LoadFileInputMeta)this.meta).getFields(((LoadFileInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    ((LoadFileInputData)this.data).convertRowMeta = ((LoadFileInputData)this.data).outputRowMeta.cloneToType(2);
                }
                catch (Exception e) {
                    this.logError("Error at transform initialization: " + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                    return false;
                }
            }
            ((LoadFileInputData)this.data).rownr = 1L;
            ((LoadFileInputData)this.data).nrInputFields = ((LoadFileInputMeta)this.meta).getInputFields().length;
            return true;
        }
        return false;
    }

    public void dispose() {
        if (((LoadFileInputData)this.data).file != null) {
            try {
                ((LoadFileInputData)this.data).file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose();
    }

    protected Object[] copyOrCloneArrayFromLoadFile(Object[] outputRowData, Object[] readrow) {
        if (readrow.length <= outputRowData.length) {
            System.arraycopy(readrow, 0, outputRowData, 0, readrow.length);
        } else {
            outputRowData = (Object[])readrow.clone();
        }
        return outputRowData;
    }
}

