/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.secondaryemails;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class SecondaryEmail {
    @Nonnull
    protected final String email;
    protected final boolean isVerified;

    public SecondaryEmail(@Nonnull String email, boolean isVerified) {
        if (email == null) {
            throw new IllegalArgumentException("Required value for 'email' is null");
        }
        if (email.length() > 255) {
            throw new IllegalArgumentException("String 'email' is longer than 255");
        }
        if (!Pattern.matches("^['#&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", email)) {
            throw new IllegalArgumentException("String 'email' does not match pattern");
        }
        this.email = email;
        this.isVerified = isVerified;
    }

    @Nonnull
    public String getEmail() {
        return this.email;
    }

    public boolean getIsVerified() {
        return this.isVerified;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.email, this.isVerified});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SecondaryEmail other = (SecondaryEmail)obj;
            return (this.email == other.email || this.email.equals(other.email)) && this.isVerified == other.isVerified;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends StructSerializer<SecondaryEmail> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(SecondaryEmail value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("email");
            StoneSerializers.string().serialize(value.email, g);
            g.writeFieldName("is_verified");
            StoneSerializers.boolean_().serialize((Boolean)value.isVerified, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SecondaryEmail deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_isVerified;
            String f_email;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_email = null;
                f_isVerified = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("email".equals(field)) {
                        f_email = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("is_verified".equals(field)) {
                        f_isVerified = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_email == null) {
                    throw new JsonParseException(p, "Required field \"email\" missing.");
                }
                if (f_isVerified == null) {
                    throw new JsonParseException(p, "Required field \"is_verified\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SecondaryEmail value = new SecondaryEmail(f_email, f_isVerified);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

