/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault;

import com.bettercloud.vault.VaultException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;

public class VaultConfig {
    private EnvironmentLoader environmentLoader;
    private String address;
    private String token;
    private String sslPemUTF8;
    private Boolean sslVerify;
    private Integer openTimeout;
    private Integer readTimeout;
    private int maxRetries;
    private int retryIntervalMilliseconds;

    public VaultConfig() {
    }

    public VaultConfig(String address, String token) throws VaultException {
        this(address, token, new EnvironmentLoader());
    }

    public VaultConfig(String address) throws VaultException {
        this(address, new EnvironmentLoader());
    }

    protected VaultConfig(String address, String token, EnvironmentLoader environmentLoader) throws VaultException {
        this.address = address;
        this.token = token;
        this.environmentLoader = environmentLoader;
        this.build();
    }

    protected VaultConfig(String address, EnvironmentLoader environmentLoader) throws VaultException {
        this.address = address;
        this.environmentLoader = environmentLoader;
        this.build();
    }

    VaultConfig environmentLoader(EnvironmentLoader environmentLoader) {
        this.environmentLoader = environmentLoader;
        return this;
    }

    public VaultConfig address(String address) {
        this.address = address;
        return this;
    }

    public VaultConfig token(String token) {
        this.token = token;
        return this;
    }

    public VaultConfig sslPemUTF8(String sslPemUTF8) {
        this.sslPemUTF8 = sslPemUTF8;
        return this;
    }

    public VaultConfig sslPemFile(File sslPemFile) throws VaultException {
        try (FileInputStream input = new FileInputStream(sslPemFile);){
            this.sslPemUTF8 = this.inputStreamToUTF8(input);
        }
        catch (IOException e) {
            throw new VaultException(e);
        }
        return this;
    }

    public VaultConfig sslPemResource(String classpathResource) throws VaultException {
        try (InputStream input = this.getClass().getResourceAsStream(classpathResource);){
            this.sslPemUTF8 = this.inputStreamToUTF8(input);
        }
        catch (IOException e) {
            throw new VaultException(e);
        }
        return this;
    }

    public VaultConfig sslVerify(Boolean sslVerify) {
        this.sslVerify = sslVerify;
        return this;
    }

    public VaultConfig openTimeout(Integer openTimeout) {
        this.openTimeout = openTimeout;
        return this;
    }

    public VaultConfig readTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    protected void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    protected void setRetryIntervalMilliseconds(int retryIntervalMilliseconds) {
        this.retryIntervalMilliseconds = retryIntervalMilliseconds;
    }

    public VaultConfig build() throws VaultException {
        if (this.environmentLoader == null) {
            this.environmentLoader = new EnvironmentLoader();
        }
        if (this.address == null) {
            String addressFromEnv = this.environmentLoader.loadVariable("VAULT_ADDR");
            if (addressFromEnv != null) {
                this.address = addressFromEnv;
            } else {
                throw new VaultException("No address is set");
            }
        }
        if (this.token == null && this.environmentLoader.loadVariable("VAULT_TOKEN") != null) {
            this.token = this.environmentLoader.loadVariable("VAULT_TOKEN");
        }
        if (this.sslPemUTF8 == null && this.environmentLoader.loadVariable("VAULT_SSL_CERT") != null) {
            File pemFile = new File(this.environmentLoader.loadVariable("VAULT_SSL_CERT"));
            try (FileInputStream input = new FileInputStream(pemFile);){
                this.sslPemUTF8 = this.inputStreamToUTF8(input);
            }
            catch (IOException e) {
                throw new VaultException(e);
            }
        }
        if (this.sslVerify == null && this.environmentLoader.loadVariable("VAULT_SSL_VERIFY") != null) {
            this.sslVerify = Boolean.valueOf(this.environmentLoader.loadVariable("VAULT_SSL_VERIFY"));
        }
        if (this.openTimeout == null && this.environmentLoader.loadVariable("VAULT_OPEN_TIMEOUT") != null) {
            try {
                this.openTimeout = Integer.valueOf(this.environmentLoader.loadVariable("VAULT_OPEN_TIMEOUT"));
            }
            catch (NumberFormatException e) {
                System.err.printf("The \"VAULT_OPEN_TIMEOUT\" environment variable contains value \"%s\", which cannot be parsed as an integer timeout period.%n", this.environmentLoader.loadVariable("VAULT_OPEN_TIMEOUT"));
            }
        }
        if (this.readTimeout == null && this.environmentLoader.loadVariable("VAULT_READ_TIMEOUT") != null) {
            try {
                this.readTimeout = Integer.valueOf(this.environmentLoader.loadVariable("VAULT_READ_TIMEOUT"));
            }
            catch (NumberFormatException e) {
                System.err.printf("The \"VAULT_READ_TIMEOUT\" environment variable contains value \"%s\", which cannot be parsed as an integer timeout period.%n", this.environmentLoader.loadVariable("VAULT_READ_TIMEOUT"));
            }
        }
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public String getToken() {
        return this.token;
    }

    public String getSslPemUTF8() {
        return this.sslPemUTF8;
    }

    public Boolean isSslVerify() {
        return this.sslVerify;
    }

    public Integer getOpenTimeout() {
        return this.openTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getRetryIntervalMilliseconds() {
        return this.retryIntervalMilliseconds;
    }

    private String inputStreamToUTF8(InputStream input) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(new InputStreamReader(input, "UTF-8"));
        StringBuilder utf8 = new StringBuilder("");
        while ((str = in.readLine()) != null) {
            utf8.append(str).append(System.lineSeparator());
        }
        in.close();
        return utf8.toString();
    }

    static class EnvironmentLoader {
        EnvironmentLoader() {
        }

        public String loadVariable(String name) {
            String value = null;
            if ("VAULT_TOKEN".equals(name)) {
                if (System.getenv("VAULT_TOKEN") != null) {
                    value = System.getenv(name);
                } else {
                    try {
                        byte[] bytes = Files.readAllBytes(Paths.get(System.getProperty("user.home"), new String[0]).resolve(".vault-token"));
                        value = new String(bytes, "UTF-8").trim();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                value = System.getenv(name);
            }
            return value;
        }
    }
}

