/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.service;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.internal.service.InternalServiceWrapperBuilder;
import org.jetbrains.annotations.NotNull;

public interface ServiceWrapper
extends Closeable {
    public ChronicleQueue[] inputQueues();

    public ChronicleQueue outputQueue();

    public static <O> Builder<O> builder(@NotNull String inputPath, @NotNull String outputPath, @NotNull Class<O> outClass, @NotNull Function<O, Object> serviceFunction) {
        return InternalServiceWrapperBuilder.serviceBuilder(inputPath, outputPath, outClass, serviceFunction);
    }

    public static interface Builder<O>
    extends Supplier<ServiceWrapper> {
        @NotNull
        public List<String> inputPath();

        public Class<O> outClass();

        @NotNull
        public Builder<O> addInputPath(String var1);

        @NotNull
        public Builder<O> outClass(Class<O> var1);

        public String outputPath();

        @NotNull
        public Builder<O> outputPath(String var1);

        @NotNull
        public List<Function<O, Object>> getServiceFunctions();

        @NotNull
        public Builder<O> addServiceFunction(Function<O, Object> var1);

        public EventLoop eventLoop();

        public boolean createdEventLoop();

        public void eventLoop(EventLoop var1);

        public HandlerPriority priority();

        @NotNull
        public Builder<O> priority(HandlerPriority var1);

        public int inputSourceId();

        @NotNull
        public Builder<O> inputSourceId(int var1);

        public int outputSourceId();

        @NotNull
        public Builder<O> outputSourceId(int var1);

        @Override
        @NotNull
        public ServiceWrapper get();

        @NotNull
        public ChronicleQueue inputQueue();

        @NotNull
        public ChronicleQueue outputQueue();

        @NotNull
        public MethodReader outputReader(Object ... var1);

        @NotNull
        public <T> T inputWriter(Class<T> var1);

        public void closeQueues();
    }
}

