/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.kafka.consumer;

import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.kafka.consumer.KafkaConsumerInputMeta;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.DoubleDeserializer;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;

public class KafkaConsumerField {
    private static final Class<?> PKG = KafkaConsumerField.class;
    private Name kafkaName;
    @Injection(name="OUTPUT_NAME")
    private String outputName;
    @Injection(name="TYPE")
    private Type outputType = Type.String;

    public KafkaConsumerField() {
    }

    public KafkaConsumerField(KafkaConsumerField orig) {
        this.kafkaName = orig.kafkaName;
        this.outputName = orig.outputName;
        this.outputType = orig.outputType;
    }

    public KafkaConsumerField(Name kafkaName, String outputName) {
        this(kafkaName, outputName, Type.String);
    }

    public KafkaConsumerField(Name kafkaName, String outputName, Type outputType) {
        this.kafkaName = kafkaName;
        this.outputName = outputName;
        this.outputType = outputType;
    }

    public Name getKafkaName() {
        return this.kafkaName;
    }

    public void setKafkaName(Name kafkaName) {
        this.kafkaName = kafkaName;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public Type getOutputType() {
        return this.outputType;
    }

    public void setOutputType(Type outputType) {
        this.outputType = outputType;
    }

    public static enum Type {
        String("String", 2, StringSerializer.class.getName(), StringDeserializer.class.getName()),
        Integer("Integer", 5, LongSerializer.class.getName(), LongDeserializer.class.getName()),
        Binary("Binary", 8, ByteArraySerializer.class.getName(), ByteArrayDeserializer.class.getName()),
        Number("Number", 1, DoubleSerializer.class.getName(), DoubleDeserializer.class.getName()),
        Avro("Avro", 20, "io.confluent.kafka.serializers.KafkaAvroSerializer", "io.confluent.kafka.serializers.KafkaAvroDeserializer");

        private final String value;
        private final int valueMetaInterfaceType;
        private String kafkaSerializerClass;
        private String kafkaDeserializerClass;

        private Type(String value, int valueMetaInterfaceType, String kafkaSerializerClass, String kafkaDeserializerClass) {
            this.value = value;
            this.valueMetaInterfaceType = valueMetaInterfaceType;
            this.kafkaSerializerClass = kafkaSerializerClass;
            this.kafkaDeserializerClass = kafkaDeserializerClass;
        }

        public String toString() {
            return this.value;
        }

        boolean isEqual(String value) {
            return this.value.equals(value);
        }

        public int getIValueMetaType() {
            return this.valueMetaInterfaceType;
        }

        public String getKafkaSerializerClass() {
            return this.kafkaSerializerClass;
        }

        public String getKafkaDeserializerClass() {
            return this.kafkaDeserializerClass;
        }

        public static Type fromValueMeta(IValueMeta vmi) {
            if (vmi != null) {
                for (Type t : Type.values()) {
                    if (vmi.getType() != t.getIValueMetaType()) continue;
                    return t;
                }
                throw new IllegalArgumentException(BaseMessages.getString(PKG, (String)"KafkaConsumerField.Type.ERROR.NoIValueMetaMapping", (Object[])new Object[]{vmi.getName(), vmi.getType()}));
            }
            return String;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Name {
        KEY("key"){

            @Override
            public void setFieldOnMeta(KafkaConsumerInputMeta meta, KafkaConsumerField field) {
                meta.setKeyField(field);
            }

            @Override
            public KafkaConsumerField getFieldFromMeta(KafkaConsumerInputMeta meta) {
                return meta.getKeyField();
            }
        }
        ,
        MESSAGE("message"){

            @Override
            public void setFieldOnMeta(KafkaConsumerInputMeta meta, KafkaConsumerField field) {
                meta.setMessageField(field);
            }

            @Override
            public KafkaConsumerField getFieldFromMeta(KafkaConsumerInputMeta meta) {
                return meta.getMessageField();
            }
        }
        ,
        TOPIC("topic"){

            @Override
            public void setFieldOnMeta(KafkaConsumerInputMeta meta, KafkaConsumerField field) {
                meta.setTopicField(field);
            }

            @Override
            public KafkaConsumerField getFieldFromMeta(KafkaConsumerInputMeta meta) {
                return meta.getTopicField();
            }
        }
        ,
        PARTITION("partition"){

            @Override
            public void setFieldOnMeta(KafkaConsumerInputMeta meta, KafkaConsumerField field) {
                meta.setPartitionField(field);
            }

            @Override
            public KafkaConsumerField getFieldFromMeta(KafkaConsumerInputMeta meta) {
                return meta.getPartitionField();
            }
        }
        ,
        OFFSET("offset"){

            @Override
            public void setFieldOnMeta(KafkaConsumerInputMeta meta, KafkaConsumerField field) {
                meta.setOffsetField(field);
            }

            @Override
            public KafkaConsumerField getFieldFromMeta(KafkaConsumerInputMeta meta) {
                return meta.getOffsetField();
            }
        }
        ,
        TIMESTAMP("timestamp"){

            @Override
            public void setFieldOnMeta(KafkaConsumerInputMeta meta, KafkaConsumerField field) {
                meta.setTimestampField(field);
            }

            @Override
            public KafkaConsumerField getFieldFromMeta(KafkaConsumerInputMeta meta) {
                return meta.getTimestampField();
            }
        };

        private final String name;

        private Name(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        boolean isEqual(String name) {
            return this.name.equals(name);
        }

        public abstract void setFieldOnMeta(KafkaConsumerInputMeta var1, KafkaConsumerField var2);

        public abstract KafkaConsumerField getFieldFromMeta(KafkaConsumerInputMeta var1);
    }
}

