/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.TruncateResponse;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.exceptions.TruncateException;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.concurrent.Condition;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TruncateResponseHandler
implements RequestCallback<TruncateResponse> {
    protected static final Logger logger = LoggerFactory.getLogger(TruncateResponseHandler.class);
    protected final Condition condition = Condition.newOneTimeCondition();
    private final int responseCount;
    protected final AtomicInteger responses = new AtomicInteger(0);
    private final long start;
    private volatile InetAddress truncateFailingReplica;

    public TruncateResponseHandler(int responseCount) {
        assert (1 <= responseCount) : "invalid response count " + responseCount;
        this.responseCount = responseCount;
        this.start = Clock.Global.nanoTime();
    }

    public void get() throws TimeoutException {
        boolean completedInTime;
        long timeoutNanos = DatabaseDescriptor.getTruncateRpcTimeout(TimeUnit.NANOSECONDS) - (Clock.Global.nanoTime() - this.start);
        try {
            completedInTime = this.condition.await(timeoutNanos, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
        if (!completedInTime) {
            throw new TimeoutException("Truncate timed out - received only " + this.responses.get() + " responses");
        }
        if (this.truncateFailingReplica != null) {
            throw new TruncateException("Truncate failed on replica " + this.truncateFailingReplica);
        }
    }

    @Override
    public void onResponse(Message<TruncateResponse> message) {
        this.responses.incrementAndGet();
        if (this.responses.get() >= this.responseCount) {
            this.condition.signalAll();
        }
    }

    @Override
    public void onFailure(InetAddressAndPort from, RequestFailureReason failureReason) {
        this.truncateFailingReplica = from.getAddress();
        this.condition.signalAll();
    }

    @Override
    public boolean invokeOnFailure() {
        return true;
    }
}

