/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.util;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabasePluginType;
import org.apache.hop.core.plugins.ActionPluginType;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class HelpUtils {
    private static final Class<?> PKG = HelpUtils.class;

    public static Button createHelpButton(Composite parent, IPlugin plugin) {
        Button button = HelpUtils.newButton(parent);
        button.addListener(13, e -> HelpUtils.openHelp(parent.getShell(), plugin));
        return button;
    }

    public static Button createHelpButton(Composite parent, String url) {
        Button button = HelpUtils.newButton(parent);
        button.addListener(13, e -> {
            try {
                EnvironmentUtils.getInstance().openUrl(url);
            }
            catch (Exception ex) {
                new ErrorDialog(parent.getShell(), "Error", "Error opening URL", ex);
            }
        });
        return button;
    }

    private static Button newButton(Composite parent) {
        Button button = new Button(parent, 8);
        PropsUi.setLook((Widget)button);
        button.setImage(GuiResource.getInstance().getImageHelpWeb());
        button.setText(BaseMessages.getString(PKG, (String)"System.Button.Help", (String[])new String[0]));
        button.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.Help", (String[])new String[0]));
        FormData fdButton = new FormData();
        fdButton.left = new FormAttachment(0, 0);
        fdButton.bottom = new FormAttachment(100, 0);
        button.setLayoutData((Object)fdButton);
        return button;
    }

    public static boolean isPluginDocumented(IPlugin plugin) {
        if (plugin == null) {
            return false;
        }
        return !StringUtil.isEmpty((String)plugin.getDocumentationUrl());
    }

    public static void openHelp(Shell shell, IPlugin plugin) {
        if (shell == null || plugin == null) {
            return;
        }
        if (HelpUtils.isPluginDocumented(plugin)) {
            try {
                EnvironmentUtils.getInstance().openUrl(Const.getDocUrl((String)plugin.getDocumentationUrl()));
            }
            catch (Exception ex) {
                new ErrorDialog(shell, "Error", "Error opening URL", ex);
            }
        } else {
            MessageBox mb = new MessageBox(shell, 33);
            String msg = "";
            msg = plugin.getPluginType().equals(TransformPluginType.class) ? BaseMessages.getString(PKG, (String)"System.Help.Transform.IsNotAvailable", (String[])new String[]{plugin.getName()}) : (plugin.getPluginType().equals(ActionPluginType.class) ? BaseMessages.getString(PKG, (String)"System.Help.Action.IsNotAvailable", (String[])new String[]{plugin.getName()}) : (plugin.getPluginType().equals(DatabasePluginType.class) ? BaseMessages.getString(PKG, (String)"System.Help.Database.IsNotAvailable", (String[])new String[]{plugin.getName()}) : BaseMessages.getString(PKG, (String)"System.Help.Metadata.IsNotAvailable", (String[])new String[]{plugin.getName()})));
            mb.setMessage(msg);
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
        }
    }
}

