/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.net.SocketException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.xml.IXml;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.server.HopServerMeta;
import org.w3c.dom.Node;

public class HopServerConfig
implements IXml {
    public static final String XML_TAG = "hop-server-config";
    public static final String XML_TAG_JETTY_OPTIONS = "jetty_options";
    public static final String XML_TAG_ACCEPTORS = "acceptors";
    public static final String XML_TAG_ACCEPT_QUEUE_SIZE = "acceptQueueSize";
    public static final String XML_TAG_LOW_RES_MAX_IDLE_TIME = "lowResourcesMaxIdleTime";
    public static final String XML_METADATA_FOLDER = "metadata_folder";
    private HopServerMeta hopServer;
    private boolean joining;
    private int maxLogLines;
    private int maxLogTimeoutMinutes;
    private int objectTimeoutMinutes;
    private String filename;
    private String passwordFile = null;
    private String metadataFolder;
    private IVariables variables = Variables.getADefaultVariableSpace();
    private MultiMetadataProvider metadataProvider = new MultiMetadataProvider(Encr.getEncoder(), Collections.emptyList(), this.variables);

    public HopServerConfig() {
    }

    public HopServerConfig(HopServerMeta hopServer) {
        this();
        this.hopServer = hopServer;
    }

    public String getXml(IVariables variables) {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.openTag((String)XML_TAG));
        if (this.hopServer != null) {
            xml.append(this.hopServer.getXml(variables));
        }
        XmlHandler.addTagValue((String)"joining", (boolean)this.joining);
        XmlHandler.addTagValue((String)"max_log_lines", (int)this.maxLogLines);
        XmlHandler.addTagValue((String)"max_log_timeout_minutes", (int)this.maxLogTimeoutMinutes);
        XmlHandler.addTagValue((String)"object_timeout_minutes", (int)this.objectTimeoutMinutes);
        XmlHandler.addTagValue((String)XML_METADATA_FOLDER, (String)this.metadataFolder);
        xml.append(XmlHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public HopServerConfig(ILogChannel log, Node node) {
        this();
        Node hopServerNode = XmlHandler.getSubNode((Node)node, (String)"hop-server");
        if (hopServerNode != null) {
            this.hopServer = new HopServerMeta(hopServerNode);
            this.checkNetworkInterfaceSetting(log, hopServerNode, this.hopServer);
        }
        this.joining = XmlHandler.getTagBoolean((Node)node, (String)"joining", (boolean)true);
        this.maxLogLines = Const.toInt((String)XmlHandler.getTagValue((Node)node, (String)"max_log_lines"), (int)0);
        this.maxLogTimeoutMinutes = Const.toInt((String)XmlHandler.getTagValue((Node)node, (String)"max_log_timeout_minutes"), (int)0);
        this.objectTimeoutMinutes = Const.toInt((String)XmlHandler.getTagValue((Node)node, (String)"object_timeout_minutes"), (int)0);
        this.metadataFolder = XmlHandler.getTagValue((Node)node, (String)XML_METADATA_FOLDER);
        this.setUpJettyOptions(node);
    }

    protected void setUpJettyOptions(Node node) {
        Map<String, String> jettyOptions = this.parseJettyOptions(node);
        if (jettyOptions != null && jettyOptions.size() > 0) {
            for (Map.Entry<String, String> jettyOption : jettyOptions.entrySet()) {
                System.setProperty(jettyOption.getKey(), jettyOption.getValue());
            }
        }
    }

    protected Map<String, String> parseJettyOptions(Node node) {
        HashMap<String, String> jettyOptions = null;
        Node jettyOptionsNode = XmlHandler.getSubNode((Node)node, (String)XML_TAG_JETTY_OPTIONS);
        if (jettyOptionsNode != null) {
            jettyOptions = new HashMap<String, String>();
            if (XmlHandler.getTagValue((Node)jettyOptionsNode, (String)XML_TAG_ACCEPTORS) != null) {
                jettyOptions.put("HOP_SERVER_JETTY_ACCEPTORS", XmlHandler.getTagValue((Node)jettyOptionsNode, (String)XML_TAG_ACCEPTORS));
            }
            if (XmlHandler.getTagValue((Node)jettyOptionsNode, (String)XML_TAG_ACCEPT_QUEUE_SIZE) != null) {
                jettyOptions.put("HOP_SERVER_JETTY_ACCEPT_QUEUE_SIZE", XmlHandler.getTagValue((Node)jettyOptionsNode, (String)XML_TAG_ACCEPT_QUEUE_SIZE));
            }
            if (XmlHandler.getTagValue((Node)jettyOptionsNode, (String)XML_TAG_LOW_RES_MAX_IDLE_TIME) != null) {
                jettyOptions.put("HOP_SERVER_JETTY_RES_MAX_IDLE_TIME", XmlHandler.getTagValue((Node)jettyOptionsNode, (String)XML_TAG_LOW_RES_MAX_IDLE_TIME));
            }
        }
        return jettyOptions;
    }

    private void checkNetworkInterfaceSetting(ILogChannel log, Node serverNode, HopServerMeta hopServer) {
        String networkInterfaceName = XmlHandler.getTagValue((Node)serverNode, (String)"network_interface");
        if (!Utils.isEmpty((CharSequence)networkInterfaceName)) {
            try {
                String newHostname = Const.getIPAddress((String)networkInterfaceName);
                if (newHostname != null) {
                    hopServer.setHostname(newHostname);
                    hopServer.setName(hopServer.getName() + "-" + newHostname);
                    log.logBasic("Hostname for hop server [" + hopServer.getName() + "] is set to [" + newHostname + "], information derived from network " + networkInterfaceName);
                }
            }
            catch (SocketException e) {
                log.logError("Unable to get the IP address for network interface " + networkInterfaceName + " for hop server [" + hopServer.getName() + "]", (Throwable)e);
            }
        }
    }

    public HopServerConfig(String hostname, int port, int shutdownPort, boolean joining) {
        this();
        this.joining = joining;
        this.hopServer = new HopServerMeta(hostname + ":" + port, hostname, "" + port, "" + shutdownPort, null, null);
    }

    public HopServerMeta getHopServer() {
        return this.hopServer;
    }

    public void setHopServer(HopServerMeta hopServer) {
        this.hopServer = hopServer;
    }

    public boolean isJoining() {
        return this.joining;
    }

    public void setJoining(boolean joining) {
        this.joining = joining;
    }

    public int getMaxLogLines() {
        return this.maxLogLines;
    }

    public void setMaxLogLines(int maxLogLines) {
        this.maxLogLines = maxLogLines;
    }

    public int getMaxLogTimeoutMinutes() {
        return this.maxLogTimeoutMinutes;
    }

    public void setMaxLogTimeoutMinutes(int maxLogTimeoutMinutes) {
        this.maxLogTimeoutMinutes = maxLogTimeoutMinutes;
    }

    public int getObjectTimeoutMinutes() {
        return this.objectTimeoutMinutes;
    }

    public void setObjectTimeoutMinutes(int objectTimeoutMinutes) {
        this.objectTimeoutMinutes = objectTimeoutMinutes;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public String getMetadataFolder() {
        return this.metadataFolder;
    }

    public void setMetadataFolder(String metadataFolder) {
        this.metadataFolder = metadataFolder;
    }

    public MultiMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(MultiMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }
}

